/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.ui;

import com.intellij.execution.services.ServiceViewManager;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.logs.ui.KubernetesLogSourcesTree;
import com.intellij.kubernetes.logs.ui.LogClusterEventsNodeDescriptor;
import com.intellij.kubernetes.logs.ui.LogContainerNodeLeafDescriptor;
import com.intellij.kubernetes.logs.ui.LogGroupNodeDescriptor;
import com.intellij.kubernetes.logs.ui.LogSourceChooserTreeDialogKt;
import com.intellij.kubernetes.view.nodes.KubernetesServiceViewContributor;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.actions.contexts.ContextsTree;
import com.intellij.kubernetes.view.ui.actions.contexts.ContextsTreeDialogKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.ListFocusTraversalPolicy;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.AlignY;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0012\u0010\u0011\u001a\u00020\b2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/logs/ui/LogSourceChooserTreeDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "logManager", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;", "onOkActionSuccessCallback", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;Lkotlin/jvm/functions/Function0;)V", "logSourcesTree", "Lcom/intellij/kubernetes/logs/ui/KubernetesLogSourcesTree;", "notificationsPanel", "Ljavax/swing/JPanel;", "createCenterPanel", "Ljavax/swing/JComponent;", "showError", "messageText", "", "showAndGet", "", "doOKAction", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nLogSourceChooserTreeDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogSourceChooserTreeDialog.kt\ncom/intellij/kubernetes/logs/ui/LogSourceChooserTreeDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,204:1\n1863#2:205\n1755#2,3:206\n1864#2:211\n774#2:212\n865#2,2:213\n1611#2,9:215\n1863#2:224\n1864#2:226\n1620#2:227\n1611#2,9:228\n1863#2:237\n1864#2:239\n1620#2:240\n1251#3,2:209\n1#4:225\n1#4:238\n1#4:242\n135#5:241\n*S KotlinDebug\n*F\n+ 1 LogSourceChooserTreeDialog.kt\ncom/intellij/kubernetes/logs/ui/LogSourceChooserTreeDialog\n*L\n49#1:205\n53#1:206,3\n49#1:211\n168#1:212\n168#1:213,2\n169#1:215,9\n169#1:224\n169#1:226\n169#1:227\n171#1:228,9\n171#1:237\n171#1:239\n171#1:240\n59#1:209,2\n169#1:225\n171#1:238\n182#1:242\n182#1:241\n*E\n"})
public final class LogSourceChooserTreeDialog
extends DialogWrapper {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final KubernetesContextLogsManager logManager;
    @NotNull
    private final Function0<Unit> onOkActionSuccessCallback;
    @NotNull
    private final KubernetesLogSourcesTree logSourcesTree;
    private JPanel notificationsPanel;

    /*
     * WARNING - void declaration
     */
    public LogSourceChooserTreeDialog(@NotNull KubernetesApiModel apiModel2, @NotNull KubernetesContextLogsManager logManager, @NotNull Function0<Unit> onOkActionSuccessCallback) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)logManager, (String)"logManager");
        Intrinsics.checkNotNullParameter(onOkActionSuccessCallback, (String)"onOkActionSuccessCallback");
        super(apiModel2.getProject(), true);
        this.apiModel = apiModel2;
        this.logManager = logManager;
        this.onOkActionSuccessCallback = onOkActionSuccessCallback;
        this.logSourcesTree = new KubernetesLogSourcesTree(this.apiModel, this.logManager);
        this.init();
        this.setTitle(KubernetesBundle.message("k8s.logs.add.log.sources.text", new Object[0]));
        this.setOKButtonText(this.getTitle());
        try {
            void $this$forEach$iv;
            JBIterable jBIterable = TreeUtil.treeNodeTraverser((TreeNode)this.logSourcesTree.getRoot()).postOrderDfsTraversal();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"postOrderDfsTraversal(...)");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                TreeNode treeNode;
                block14: {
                    treeNode = (TreeNode)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                    CheckedTreeNode cfr_ignored_0 = (CheckedTreeNode)treeNode;
                    Object userObject = ((CheckedTreeNode)treeNode).getUserObject();
                    if (userObject instanceof LogContainerNodeLeafDescriptor) {
                        $this$any$iv = (Iterable)this.logManager.getStateManager$intellij_clouds_kubernetes().getCurrentContainers$intellij_clouds_kubernetes().getValue();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                it = (KubernetesContainerObject)element$iv2;
                                boolean bl3 = false;
                                if (!(Intrinsics.areEqual((Object)((KubernetesContainerObject)it).getName(), (Object)((LogContainerNodeLeafDescriptor)userObject).getContainer().getName()) && Intrinsics.areEqual((Object)it.getMetadata().getUid(), (Object)((LogContainerNodeLeafDescriptor)userObject).getContainer().getMetadata().getUid()))) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    } else if (userObject instanceof LogGroupNodeDescriptor) {
                        Enumeration enumeration = ((CheckedTreeNode)treeNode).children();
                        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
                        $this$any$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration));
                        $i$f$any = false;
                        for (Object element$iv2 : $this$any$iv) {
                            it = (TreeNode)element$iv2;
                            boolean bl4 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                            if (!((CheckedTreeNode)it).isChecked()) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    } else if (userObject instanceof LogClusterEventsNodeDescriptor) {
                        bl = (Boolean)this.logManager.getStateManager$intellij_clouds_kubernetes().getAddClusterEventsAsLogs$intellij_clouds_kubernetes().getValue();
                    } else {
                        throw new IllegalArgumentException("Unknown value: " + userObject);
                    }
                }
                boolean isChecked = bl;
                ((CheckedTreeNode)treeNode).setEnabled(true);
                ((CheckedTreeNode)treeNode).setChecked(isChecked);
            }
        }
        catch (ClassCastException e) {
            LogSourceChooserTreeDialogKt.access$getLOG$p().error("Unknown node type", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LogSourceChooserTreeDialogKt.access$getLOG$p().error((Throwable)e);
        }
        this.logSourcesTree.getTree().addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(CheckedTreeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                node.setChecked(node.isEnabled() && node.isChecked());
            }
        });
        this.logSourcesTree.getTree().getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.setOKActionEnabled(true);
                Object[] objectArray = event2.getChildren();
                Object object = objectArray != null ? objectArray[0] : null;
                CheckedTreeNode checkedTreeNode = object instanceof CheckedTreeNode ? (CheckedTreeNode)object : null;
                if (checkedTreeNode == null) {
                    return;
                }
                CheckedTreeNode node = checkedTreeNode;
                this.updateOtherCheckNodesInTheTree(node);
            }

            private final void updateOtherCheckNodesInTheTree(CheckedTreeNode node) {
                block4: {
                    Object object;
                    block3: {
                        object = node.getUserObject();
                        if (!(object instanceof LogContainerNodeLeafDescriptor)) break block3;
                        Object object2 = node.getUserObject();
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.kubernetes.logs.ui.LogContainerNodeLeafDescriptor");
                        LogContainerNodeLeafDescriptor containerLeaf = (LogContainerNodeLeafDescriptor)object2;
                        ConcurrentHashMap<LogContainerNodeLeafDescriptor, CheckedTreeNode> concurrentHashMap = logManager.getStateManager$intellij_clouds_kubernetes().getMyTreeLogContainerLeafNodeDescriptorRegistry$intellij_clouds_kubernetes().get(containerLeaf.getContainer());
                        if (concurrentHashMap == null) {
                            return;
                        }
                        ConcurrentHashMap<LogContainerNodeLeafDescriptor, CheckedTreeNode> storage = concurrentHashMap;
                        Map $this$forEach$iv = MapsKt.minus((Map)storage, (Object)containerLeaf);
                        boolean $i$f$forEach = false;
                        Iterator iterator = $this$forEach$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv;
                            Map.Entry it = element$iv = iterator.next();
                            boolean bl = false;
                            ((CheckedTreeNode)it.getValue()).setChecked(node.isChecked());
                        }
                        break block4;
                    }
                    if (!(object instanceof LogGroupNodeDescriptor)) break block4;
                    Enumeration enumeration = node.children();
                    Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"children(...)");
                    Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator((Enumeration)enumeration));
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        TreeNode it = (TreeNode)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                        this.updateOtherCheckNodesInTheTree((CheckedTreeNode)it);
                    }
                }
            }
        });
        this.setOKActionEnabled(true);
    }

    public /* synthetic */ LogSourceChooserTreeDialog(KubernetesApiModel kubernetesApiModel, KubernetesContextLogsManager kubernetesContextLogsManager, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = LogSourceChooserTreeDialog::_init_$lambda$0;
        }
        this(kubernetesApiModel, kubernetesContextLogsManager, (Function0<Unit>)function0);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        CheckboxTree tree = this.logSourcesTree.getTree();
        SearchTextField searchTextField = this.logSourcesTree.installSearchField();
        Intrinsics.checkNotNullExpressionValue((Object)searchTextField, (String)"installSearchField(...)");
        SearchTextField searchTextField2 = searchTextField;
        JBScrollPane scrollPane = new JBScrollPane((Component)tree);
        DialogPanel $this$createCenterPanel_u24lambda_u249 = dialogPanel = BuilderKt.panel(arg_0 -> LogSourceChooserTreeDialog.createCenterPanel$lambda$8(searchTextField2, tree, scrollPane, this, arg_0));
        boolean bl = false;
        Object[] objectArray = new Object[]{searchTextField2, tree};
        $this$createCenterPanel_u24lambda_u249.setFocusTraversalPolicy((FocusTraversalPolicy)new ListFocusTraversalPolicy(CollectionsKt.listOf((Object[])objectArray)));
        $this$createCenterPanel_u24lambda_u249.setFocusTraversalPolicyProvider(true);
        $this$createCenterPanel_u24lambda_u249.setFocusCycleRoot(true);
        $this$createCenterPanel_u24lambda_u249.setPreferredSize(new Dimension(700, 600));
        return (JComponent)dialogPanel;
    }

    private final void showError(@Nls String messageText) {
        JPanel jPanel = this.notificationsPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationsPanel");
            jPanel = null;
        }
        jPanel.add((Component)new InlineBanner(messageText, EditorNotificationPanel.Status.Error));
        this.pack();
    }

    public boolean showAndGet() {
        this.logSourcesTree.collapseFromSecondLevel$intellij_clouds_kubernetes();
        return super.showAndGet();
    }

    /*
     * WARNING - void declaration
     */
    protected void doOKAction() {
        try {
            Object v3;
            Object v2;
            List checkedContainers;
            block15: {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNullTo$iv$iv2;
                Object it;
                Iterable $this$filterTo$iv$iv;
                if (!this.isOKActionEnabled()) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = this.logSourcesTree.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"getRoot(...)");
                Iterable $this$filter$iv = SequencesKt.toSet((Sequence)CollectionsKt.asSequence((Iterable)ContextsTree.Companion.getLeafs(defaultMutableTreeNode)));
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable<Object> destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (CheckedTreeNode)element$iv$iv;
                    boolean bl = false;
                    if (!it.isChecked()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach = false;
                it = $this$forEach$iv$iv$iv.iterator();
                while (it.hasNext()) {
                    Object it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = it.next();
                    boolean bl = false;
                    CheckedTreeNode it2 = (CheckedTreeNode)element$iv$iv;
                    boolean bl2 = false;
                    if (it2.getUserObject() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List checkedObjects = (List)destination$iv$iv;
                Iterable $this$mapNotNull$iv2 = checkedObjects;
                boolean $i$f$mapNotNull2 = false;
                destination$iv$iv = $this$mapNotNull$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator element$iv$iv$iv = $this$forEach$iv$iv$iv2.iterator();
                while (element$iv$iv$iv.hasNext()) {
                    KubernetesContainerObject kubernetesContainerObject;
                    Object element$iv$iv$iv2;
                    Object element$iv$iv = element$iv$iv$iv2 = element$iv$iv$iv.next();
                    boolean bl = false;
                    Object userObj = element$iv$iv;
                    boolean bl4 = false;
                    Object t = userObj;
                    if (t instanceof LogContainerNodeLeafDescriptor) {
                        kubernetesContainerObject = ((LogContainerNodeLeafDescriptor)userObj).getContainer();
                    } else if (t instanceof LogClusterEventsNodeDescriptor) {
                        kubernetesContainerObject = null;
                    } else {
                        LogSourceChooserTreeDialogKt.access$getLOG$p().warn("Tree should not have leafs of " + userObj.getClass() + ", unless children are empty");
                        kubernetesContainerObject = null;
                    }
                    if (kubernetesContainerObject == null) continue;
                    KubernetesContainerObject it$iv$iv = kubernetesContainerObject;
                    boolean bl5 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                checkedContainers = CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
                Iterable $this$findInstanceOf$iv = checkedObjects;
                boolean $i$f$findInstanceOf = false;
                Iterable iterable2 = $this$findInstanceOf$iv;
                Iterator iterator = iterable2.iterator();
                while (iterator.hasNext()) {
                    Object t;
                    Object it$iv = t = iterator.next();
                    boolean bl = false;
                    if (!(it$iv instanceof LogClusterEventsNodeDescriptor)) continue;
                    v2 = t;
                    break block15;
                }
                v2 = v3 = null;
            }
            if (!(v2 instanceof LogClusterEventsNodeDescriptor)) {
                v3 = null;
            }
            LogClusterEventsNodeDescriptor clusterEvents = v3;
            this.logManager.getStateManager$intellij_clouds_kubernetes().getAddClusterEventsAsLogs$intellij_clouds_kubernetes().setValue((Object)(clusterEvents != null ? 1 : 0));
            this.logManager.getStateManager$intellij_clouds_kubernetes().getCurrentContainers$intellij_clouds_kubernetes().setValue((Object)checkedContainers);
            this.logManager.getStateManager$intellij_clouds_kubernetes().getMyTreeLogContainerLeafNodeDescriptorRegistry$intellij_clouds_kubernetes().clear();
            String string = ServiceViewManager.getInstance((Project)this.apiModel.getProject()).getToolWindowId(KubernetesServiceViewContributor.class);
            if (string == null) {
                return;
            }
            String toolWindowId = string;
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.apiModel.getProject()).getToolWindow(toolWindowId);
            if (toolWindow == null) {
                return;
            }
            ToolWindow toolWindow2 = toolWindow;
            toolWindow2.activate(null);
            super.doOKAction();
            this.onOkActionSuccessCallback.invoke();
        }
        catch (Throwable e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Unknown error";
            }
            this.showError(string);
            ContextsTreeDialogKt.getLOG().error(e);
        }
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$8$lambda$4(SearchTextField $searchTextField, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)$searchTextField).align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.TOP.INSTANCE).focused();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$8$lambda$5(CheckboxTree $tree, JBScrollPane $scrollPane, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TreeUtil.expand((JTree)((JTree)$tree), (int)0);
        $this$row.cell((JComponent)$scrollPane).align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$8$lambda$7(LogSourceChooserTreeDialog this$0, Row $this$row) {
        void $this$createCenterPanel_u24lambda_u248_u24lambda_u247_u24lambda_u246;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JPanel jPanel2 = jPanel = new JPanel();
        Row row = $this$row;
        LogSourceChooserTreeDialog logSourceChooserTreeDialog = this$0;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u248_u24lambda_u247_u24lambda_u246.setLayout(new BoxLayout((Container)$this$createCenterPanel_u24lambda_u248_u24lambda_u247_u24lambda_u246, 1));
        Unit unit = Unit.INSTANCE;
        logSourceChooserTreeDialog.notificationsPanel = (JPanel)row.cell((JComponent)jPanel).align((Align)AlignX.FILL.INSTANCE).align((Align)AlignY.BOTTOM.INSTANCE).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$8(SearchTextField $searchTextField, CheckboxTree $tree, JBScrollPane $scrollPane, LogSourceChooserTreeDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LogSourceChooserTreeDialog.createCenterPanel$lambda$8$lambda$4($searchTextField, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LogSourceChooserTreeDialog.createCenterPanel$lambda$8$lambda$5($tree, $scrollPane, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> LogSourceChooserTreeDialog.createCenterPanel$lambda$8$lambda$7(this$0, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }
}

