/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.ui;

import com.intellij.openapi.project.Project;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0007H\u0002J\b\u0010\"\u001a\u00020\u001fH\u0002R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/kubernetes/logs/ui/KubernetesJumpToTimestampComponent;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "selectedTimestamp", "Ljava/time/Instant;", "getSelectedTimestamp", "()Ljava/time/Instant;", "myRootPanel", "Ljavax/swing/JPanel;", "dateField", "Ljavax/swing/JFormattedTextField;", "timeField", "jumpNowButton", "Ljavax/swing/JButton;", "jump1HourButton", "jump24HoursButton", "okButton", "dateFormatter", "Ljava/text/SimpleDateFormat;", "timeFormatter", "getPanel", "parseDateTime", "dateTimeStr", "", "createFormattedDateField", "format", "createFormattedTimeField", "setupButtons", "", "setDateTime", "instant", "setupUI", "intellij.clouds.kubernetes"})
public final class KubernetesJumpToTimestampComponent {
    @NotNull
    private final JPanel myRootPanel;
    @NotNull
    private final JFormattedTextField dateField;
    @NotNull
    private final JFormattedTextField timeField;
    @NotNull
    private final JButton jumpNowButton;
    @NotNull
    private final JButton jump1HourButton;
    @NotNull
    private final JButton jump24HoursButton;
    @NotNull
    private final JButton okButton;
    @NotNull
    private final SimpleDateFormat dateFormatter;
    @NotNull
    private final SimpleDateFormat timeFormatter;

    public KubernetesJumpToTimestampComponent(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myRootPanel = new JPanel(new GridBagLayout());
        this.jumpNowButton = new JButton("Now");
        this.jump1HourButton = new JButton("Hour Ago");
        this.jump24HoursButton = new JButton("24 Hours Ago");
        this.okButton = new JButton("OK");
        this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.timeFormatter = new SimpleDateFormat("HH:mm");
        this.dateField = this.createFormattedDateField("####-##-##");
        this.timeField = this.createFormattedTimeField("##:##");
        KeyAdapter keyAdapterForTextField2 = new KeyAdapter(this){
            final /* synthetic */ KubernetesJumpToTimestampComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    KubernetesJumpToTimestampComponent.access$getMyRootPanel$p(this.this$0).dispatchEvent(e);
                }
            }
        };
        this.dateField.addKeyListener(keyAdapterForTextField2);
        this.timeField.addKeyListener(keyAdapterForTextField2);
        this.setupButtons();
        this.setupUI();
    }

    @Nullable
    public final Instant getSelectedTimestamp() {
        return this.parseDateTime(this.dateField.getText() + " " + this.timeField.getText());
    }

    @NotNull
    public final JPanel getPanel() {
        return this.myRootPanel;
    }

    private final Instant parseDateTime(String dateTimeStr) {
        Instant instant;
        try {
            Date parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateTimeStr);
            instant = parsedDate.toInstant();
        }
        catch (Exception e) {
            instant = null;
        }
        return instant;
    }

    private final JFormattedTextField createFormattedDateField(String format) {
        JFormattedTextField jFormattedTextField;
        try {
            MaskFormatter formatter = new MaskFormatter(format);
            formatter.setPlaceholderCharacter('_');
            jFormattedTextField = new JFormattedTextField(formatter);
        }
        catch (Exception e) {
            jFormattedTextField = new JFormattedTextField();
        }
        return jFormattedTextField;
    }

    private final JFormattedTextField createFormattedTimeField(String format) {
        JFormattedTextField jFormattedTextField;
        try {
            MaskFormatter formatter = new MaskFormatter(format);
            formatter.setPlaceholderCharacter('_');
            jFormattedTextField = new JFormattedTextField(formatter);
        }
        catch (Exception e) {
            jFormattedTextField = new JFormattedTextField();
        }
        return jFormattedTextField;
    }

    private final void setupButtons() {
        ActionListener actionNow = arg_0 -> KubernetesJumpToTimestampComponent.setupButtons$lambda$0(this, arg_0);
        ActionListener action1Hour = arg_0 -> KubernetesJumpToTimestampComponent.setupButtons$lambda$1(this, arg_0);
        ActionListener action24Hours = arg_0 -> KubernetesJumpToTimestampComponent.setupButtons$lambda$2(this, arg_0);
        this.jumpNowButton.addActionListener(actionNow);
        this.jump1HourButton.addActionListener(action1Hour);
        this.jump24HoursButton.addActionListener(action24Hours);
        this.okButton.addActionListener(arg_0 -> KubernetesJumpToTimestampComponent.setupButtons$lambda$3(this, arg_0));
    }

    private final void setDateTime(Instant instant) {
        this.dateField.setText(this.dateFormatter.format(Date.from(instant)));
        this.timeField.setText(this.timeFormatter.format(Date.from(instant)));
    }

    private final void setupUI() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = (Insets)JBUI.insets((int)5);
        gbc.fill = 2;
        Font consistentFont = new Font("Monospaced", 0, 13);
        this.dateField.setFont(consistentFont);
        this.timeField.setFont(consistentFont);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.myRootPanel.add((Component)this.jumpNowButton, gbc);
        gbc.gridx = 1;
        this.myRootPanel.add((Component)this.jump1HourButton, gbc);
        gbc.gridx = 2;
        this.myRootPanel.add((Component)this.jump24HoursButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.myRootPanel.add((Component)new JLabel("Date (yyyy-MM-dd):"), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.myRootPanel.add((Component)this.dateField, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.myRootPanel.add((Component)new JLabel("Time (HH:mm):"), gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.myRootPanel.add((Component)this.timeField, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        this.myRootPanel.add((Component)this.okButton, gbc);
        gbc.gridwidth = 1;
    }

    private static final void setupButtons$lambda$0(KubernetesJumpToTimestampComponent this$0, ActionEvent it) {
        Instant now = Instant.now();
        Intrinsics.checkNotNull((Object)now);
        this$0.setDateTime(now);
    }

    private static final void setupButtons$lambda$1(KubernetesJumpToTimestampComponent this$0, ActionEvent it) {
        Instant now = Instant.now();
        Instant instant = now.minusSeconds(3600L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minusSeconds(...)");
        this$0.setDateTime(instant);
    }

    private static final void setupButtons$lambda$2(KubernetesJumpToTimestampComponent this$0, ActionEvent it) {
        Instant now = Instant.now();
        Instant instant = now.minusSeconds(86400L);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minusSeconds(...)");
        this$0.setDateTime(instant);
    }

    private static final void setupButtons$lambda$3(KubernetesJumpToTimestampComponent this$0, ActionEvent it) {
        KeyEvent evt = new KeyEvent(this$0.myRootPanel, 401, System.currentTimeMillis(), 0, 10, '\n');
        this$0.myRootPanel.dispatchEvent(evt);
    }

    public static final /* synthetic */ JPanel access$getMyRootPanel$p(KubernetesJumpToTimestampComponent $this) {
        return $this.myRootPanel;
    }
}

