/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.pattern.matching;

import com.intellij.kubernetes.logs.pattern.matching.InternalLogClusterKt;
import com.intellij.kubernetes.logs.pattern.matching.LogCluster;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0013\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/logs/pattern/matching/OneWordLogCluster;", "Lcom/intellij/kubernetes/logs/pattern/matching/LogCluster;", "token", "", "sightings", "", "<init>", "(Ljava/lang/String;I)V", "tokens", "", "fitsCluster", "", "text", "equals", "other", "", "toString", "toStringWithCounts", "toHTML", "hashCode", "intellij.clouds.kubernetes"})
public final class OneWordLogCluster
implements LogCluster {
    @NotNull
    private final String token;
    private int sightings;

    public OneWordLogCluster(@NotNull String token, int sightings) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.token = token;
        this.sightings = sightings;
    }

    public /* synthetic */ OneWordLogCluster(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(string, n);
    }

    @Override
    @NotNull
    public List<String> tokens() {
        return CollectionsKt.listOf((Object)this.token);
    }

    @Override
    public int sightings() {
        return this.sightings;
    }

    @Override
    public boolean fitsCluster(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.contains((CharSequence)text, (CharSequence)this.token, (boolean)true);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof OneWordLogCluster && Intrinsics.areEqual((Object)((OneWordLogCluster)other).token, (Object)this.token);
    }

    @NotNull
    public String toString() {
        return this.token;
    }

    @Override
    @NotNull
    public String toStringWithCounts() {
        return "(size " + this.sightings + "): " + this.token;
    }

    @Override
    @NotNull
    public String toHTML() {
        return InternalLogClusterKt.access$escapeHTML(this.token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }
}

