/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.ILogConsistentCache;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.TimeSlice;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001c\u0010\u0017\u001a\u00020\u000f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0017\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\nH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/kubernetes/logs/LogConsistentCache;", "Lcom/intellij/kubernetes/logs/ILogConsistentCache;", "<init>", "()V", "logsCache", "Ljava/util/concurrent/ConcurrentSkipListSet;", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "getLogsCache", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "_globalConsistentLogsRange", "Lcom/intellij/kubernetes/logs/TimeSlice;", "consistentLogsRange", "getConsistentLogsRange", "()Lcom/intellij/kubernetes/logs/TimeSlice;", "size", "", "getSize", "()I", "getSnapshot", "", "getLogsAround", "timestamp", "Ljava/time/Instant;", "indexOfFirst", "predicate", "Lkotlin/Function1;", "", "plusAssign", "", "newLogs", "", "clear", "relaxConsistentLogsRange", "newSlice", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogsConsistentCaches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogsConsistentCaches.kt\ncom/intellij/kubernetes/logs/LogConsistentCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n346#2,8:288\n346#2,8:296\n*S KotlinDebug\n*F\n+ 1 KubernetesLogsConsistentCaches.kt\ncom/intellij/kubernetes/logs/LogConsistentCache\n*L\n48#1:288,8\n58#1:296,8\n*E\n"})
public class LogConsistentCache
implements ILogConsistentCache {
    @NotNull
    private final ConcurrentSkipListSet<KubernetesContextLog> logsCache = new ConcurrentSkipListSet();
    @NotNull
    private TimeSlice _globalConsistentLogsRange = new TimeSlice(null, null);

    @NotNull
    protected final ConcurrentSkipListSet<KubernetesContextLog> getLogsCache() {
        return this.logsCache;
    }

    @Override
    @NotNull
    public TimeSlice getConsistentLogsRange() {
        return this._globalConsistentLogsRange;
    }

    @Override
    public int getSize() {
        return this.logsCache.size();
    }

    @Override
    @NotNull
    public List<KubernetesContextLog> getSnapshot() {
        return CollectionsKt.toList((Iterable)this.logsCache);
    }

    @Override
    @NotNull
    public List<KubernetesContextLog> getLogsAround(@NotNull Instant timestamp) {
        int n;
        int totalLogsNeeded;
        block3: {
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            totalLogsNeeded = 250;
            Iterable $this$indexOfFirst$iv = this.logsCache;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                KubernetesContextLog log2 = (KubernetesContextLog)item$iv;
                boolean bl = false;
                if (log2.getTimestamp().compareTo(timestamp) >= 0) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int newTimestampIndex = n;
        int start2 = Math.max(0, newTimestampIndex - 100);
        int end = Math.min(start2 + totalLogsNeeded, this.logsCache.size());
        int adjustedStart = Math.max(0, end - totalLogsNeeded);
        return CollectionsKt.take((Iterable)CollectionsKt.drop((Iterable)this.logsCache, (int)adjustedStart), (int)totalLogsNeeded);
    }

    @Override
    public int indexOfFirst(@NotNull Function1<? super KubernetesContextLog, Boolean> predicate) {
        int n;
        block3: {
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$indexOfFirst$iv = this.logsCache;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                if (((Boolean)predicate.invoke(item$iv)).booleanValue()) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        return n;
    }

    @Override
    public void plusAssign(@NotNull Collection<? extends KubernetesContextLog> newLogs) {
        Intrinsics.checkNotNullParameter(newLogs, (String)"newLogs");
        CollectionsKt.addAll((Collection)this.logsCache, (Iterable)newLogs);
        if (!newLogs.isEmpty()) {
            this.relaxConsistentLogsRange(new TimeSlice(((KubernetesContextLog)CollectionsKt.first((Iterable)newLogs)).getTimestamp(), ((KubernetesContextLog)CollectionsKt.last((Iterable)newLogs)).getTimestamp()));
        }
    }

    @Override
    public void clear() {
        this.logsCache.clear();
        this._globalConsistentLogsRange = new TimeSlice(null, null);
    }

    @Override
    public void relaxConsistentLogsRange(@NotNull TimeSlice newSlice) {
        TimeSlice relaxed;
        Intrinsics.checkNotNullParameter((Object)newSlice, (String)"newSlice");
        Instant instant = newSlice.getBeginTime();
        Intrinsics.checkNotNull((Object)instant);
        Comparable comparable = instant;
        Instant instant2 = this._globalConsistentLogsRange.getBeginTime();
        if (instant2 == null) {
            instant2 = Instant.MAX;
        }
        Instant instant3 = instant2;
        Intrinsics.checkNotNull((Object)instant3);
        Instant instant4 = (Instant)ComparisonsKt.minOf((Comparable)comparable, (Comparable)instant3);
        Instant instant5 = newSlice.getEndTime();
        Intrinsics.checkNotNull((Object)instant5);
        Comparable comparable2 = instant5;
        Instant instant6 = this._globalConsistentLogsRange.getEndTime();
        if (instant6 == null) {
            instant6 = Instant.MIN;
        }
        instant3 = instant6;
        Intrinsics.checkNotNull((Object)instant3);
        this._globalConsistentLogsRange = relaxed = new TimeSlice(instant4, (Instant)ComparisonsKt.maxOf((Comparable)comparable2, (Comparable)instant3));
    }
}

