/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.KubernetesLogFilterSettings;
import com.intellij.kubernetes.logs.KubernetesLogStateManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0010J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00158@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesTextFilterModel;", "", "stateManager", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "<init>", "(Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;)V", "getStateManager", "()Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "currentFilterSettings", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/kubernetes/logs/KubernetesLogFilterSettings;", "value", "getValue", "()Lcom/intellij/kubernetes/logs/KubernetesLogFilterSettings;", "updateSettings", "updateAction", "Lkotlin/Function1;", "getSettingsFlow", "Lkotlinx/coroutines/flow/Flow;", "clearFilters", "", "", "text", "getText$intellij_clouds_kubernetes", "()Ljava/lang/String;", "setText$intellij_clouds_kubernetes", "(Ljava/lang/String;)V", "apply", "", "log", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogFilters.kt\ncom/intellij/kubernetes/logs/KubernetesTextFilterModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,106:1\n210#2,5:107\n*S KotlinDebug\n*F\n+ 1 KubernetesLogFilters.kt\ncom/intellij/kubernetes/logs/KubernetesTextFilterModel\n*L\n43#1:107,5\n*E\n"})
public class KubernetesTextFilterModel {
    @NotNull
    private final KubernetesLogStateManager stateManager;
    @NotNull
    private final MutableStateFlow<KubernetesLogFilterSettings> currentFilterSettings;

    public KubernetesTextFilterModel(@NotNull KubernetesLogStateManager stateManager) {
        Intrinsics.checkNotNullParameter((Object)stateManager, (String)"stateManager");
        this.stateManager = stateManager;
        this.currentFilterSettings = StateFlowKt.MutableStateFlow((Object)new KubernetesLogFilterSettings("", false, false));
    }

    @NotNull
    public final KubernetesLogStateManager getStateManager() {
        return this.stateManager;
    }

    @NotNull
    public final KubernetesLogFilterSettings getValue() {
        return (KubernetesLogFilterSettings)this.currentFilterSettings.getValue();
    }

    @NotNull
    public final KubernetesLogFilterSettings updateSettings(@NotNull Function1<? super KubernetesLogFilterSettings, KubernetesLogFilterSettings> updateAction) {
        KubernetesLogFilterSettings newSettings;
        KubernetesLogFilterSettings nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(updateAction, (String)"updateAction");
        MutableStateFlow<KubernetesLogFilterSettings> $this$getAndUpdate$iv = this.currentFilterSettings;
        boolean $i$f$getAndUpdate = false;
        do {
            prevValue$iv = $this$getAndUpdate$iv.getValue();
            KubernetesLogFilterSettings snapshot = (KubernetesLogFilterSettings)prevValue$iv;
            boolean bl = false;
            newSettings = (KubernetesLogFilterSettings)updateAction.invoke((Object)snapshot);
            if (!Intrinsics.areEqual((Object)newSettings.getRequest(), (Object)snapshot.getRequest())) {
                KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.stateManager.getApiModel$intellij_clouds_kubernetes().getProject(), "logs-log-text-filter-used-action");
            }
            if (newSettings.getUseRegex() != snapshot.getUseRegex()) {
                KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.stateManager.getApiModel$intellij_clouds_kubernetes().getProject(), "logs-log-text-filter-use-regex-selected");
            }
            if (newSettings.getMatchCase() == snapshot.getMatchCase()) continue;
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(this.stateManager.getApiModel$intellij_clouds_kubernetes().getProject(), "logs-log-text-filter-match-case-selected");
        } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = newSettings)));
        return (KubernetesLogFilterSettings)prevValue$iv;
    }

    @NotNull
    public final Flow<KubernetesLogFilterSettings> getSettingsFlow() {
        return (Flow)this.currentFilterSettings;
    }

    public void clearFilters() {
        this.updateSettings((Function1<? super KubernetesLogFilterSettings, KubernetesLogFilterSettings>)((Function1)KubernetesTextFilterModel::clearFilters$lambda$1));
    }

    @NotNull
    public final String getText$intellij_clouds_kubernetes() {
        return ((KubernetesLogFilterSettings)this.currentFilterSettings.getValue()).getRequest();
    }

    public final void setText$intellij_clouds_kubernetes(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.updateSettings((Function1<? super KubernetesLogFilterSettings, KubernetesLogFilterSettings>)((Function1)arg_0 -> KubernetesTextFilterModel._set_text_$lambda$2(value2, arg_0)));
    }

    public boolean apply(@NotNull KubernetesContextLog log2) {
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        return this.getValue().apply(log2.getMessage());
    }

    private static final KubernetesLogFilterSettings clearFilters$lambda$1(KubernetesLogFilterSettings snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        return KubernetesLogFilterSettings.copy$default(snapshot, "", false, false, 6, null);
    }

    private static final KubernetesLogFilterSettings _set_text_$lambda$2(String $value, KubernetesLogFilterSettings snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        return KubernetesLogFilterSettings.copy$default(snapshot, $value, false, false, 6, null);
    }
}

