/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.ILogConsistentCache;
import com.intellij.kubernetes.logs.TimeSlice;
import com.intellij.openapi.diagnostic.Logger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "relax", "Lcom/intellij/kubernetes/logs/TimeSlice;", "timestamp", "Ljava/time/Instant;", "diff", "", "other", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogsConsistentCaches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogsConsistentCaches.kt\ncom/intellij/kubernetes/logs/KubernetesLogsConsistentCachesKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,287:1\n15#2:288\n*S KotlinDebug\n*F\n+ 1 KubernetesLogsConsistentCaches.kt\ncom/intellij/kubernetes/logs/KubernetesLogsConsistentCachesKt\n*L\n20#1:288\n*E\n"})
public final class KubernetesLogsConsistentCachesKt {
    @NotNull
    private static final Logger LOG;

    private static final TimeSlice relax(TimeSlice $this$relax, Instant timestamp) {
        Comparable comparable = timestamp;
        Instant instant = $this$relax.getEndTime();
        if (instant == null) {
            instant = Instant.MIN;
        }
        Instant instant2 = instant;
        Intrinsics.checkNotNull((Object)instant2);
        Instant newEndTime = (Instant)ComparisonsKt.maxOf((Comparable)comparable, (Comparable)instant2);
        Comparable comparable2 = timestamp;
        Instant instant3 = $this$relax.getBeginTime();
        if (instant3 == null) {
            instant3 = Instant.MAX;
        }
        Instant instant4 = instant3;
        Intrinsics.checkNotNull((Object)instant4);
        Instant newBeginTime = (Instant)ComparisonsKt.minOf((Comparable)comparable2, (Comparable)instant4);
        return new TimeSlice(newBeginTime, newEndTime);
    }

    @NotNull
    public static final List<TimeSlice> diff(@NotNull TimeSlice $this$diff, @NotNull TimeSlice other) {
        Intrinsics.checkNotNullParameter((Object)$this$diff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$diff.getBeginTime() == null || $this$diff.getEndTime() == null) {
            return CollectionsKt.emptyList();
        }
        if (other.getBeginTime() == null || other.getEndTime() == null) {
            return CollectionsKt.listOf((Object)$this$diff);
        }
        if ($this$diff.getBeginTime().compareTo(other.getEndTime()) > 0) {
            return CollectionsKt.listOf((Object)new TimeSlice(other.getEndTime(), $this$diff.getEndTime()));
        }
        if ($this$diff.getEndTime().compareTo(other.getBeginTime()) < 0) {
            return CollectionsKt.listOf((Object)new TimeSlice($this$diff.getBeginTime(), other.getBeginTime()));
        }
        List result2 = new ArrayList();
        if ($this$diff.getBeginTime().compareTo(other.getBeginTime()) < 0) {
            result2.add(new TimeSlice($this$diff.getBeginTime(), other.getBeginTime()));
        }
        if ($this$diff.getEndTime().compareTo(other.getEndTime()) > 0) {
            result2.add(new TimeSlice(other.getEndTime(), $this$diff.getEndTime()));
        }
        return result2;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ILogConsistentCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

