/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesLogFilterSettings;", "", "request", "", "matchCase", "", "useRegex", "<init>", "(Ljava/lang/String;ZZ)V", "getRequest", "()Ljava/lang/String;", "getMatchCase", "()Z", "getUseRegex", "apply", "text", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes"})
public final class KubernetesLogFilterSettings {
    @NotNull
    private final String request;
    private final boolean matchCase;
    private final boolean useRegex;

    public KubernetesLogFilterSettings(@NotNull String request, boolean matchCase, boolean useRegex) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.matchCase = matchCase;
        this.useRegex = useRegex;
    }

    @NotNull
    public final String getRequest() {
        return this.request;
    }

    public final boolean getMatchCase() {
        return this.matchCase;
    }

    public final boolean getUseRegex() {
        return this.useRegex;
    }

    public final boolean apply(@NotNull String text) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.useRegex) {
            Regex regex = this.matchCase ? new Regex(this.request) : new Regex(this.request, RegexOption.IGNORE_CASE);
            bl = regex.containsMatchIn((CharSequence)text);
        } else {
            bl = this.matchCase ? StringsKt.contains$default((CharSequence)text, (CharSequence)this.request, (boolean)false, (int)2, null) : StringsKt.contains((CharSequence)text, (CharSequence)this.request, (boolean)true);
        }
        return bl;
    }

    @NotNull
    public final String component1() {
        return this.request;
    }

    public final boolean component2() {
        return this.matchCase;
    }

    public final boolean component3() {
        return this.useRegex;
    }

    @NotNull
    public final KubernetesLogFilterSettings copy(@NotNull String request, boolean matchCase, boolean useRegex) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new KubernetesLogFilterSettings(request, matchCase, useRegex);
    }

    public static /* synthetic */ KubernetesLogFilterSettings copy$default(KubernetesLogFilterSettings kubernetesLogFilterSettings, String string, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            string = kubernetesLogFilterSettings.request;
        }
        if ((n & 2) != 0) {
            bl = kubernetesLogFilterSettings.matchCase;
        }
        if ((n & 4) != 0) {
            bl2 = kubernetesLogFilterSettings.useRegex;
        }
        return kubernetesLogFilterSettings.copy(string, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "KubernetesLogFilterSettings(request=" + this.request + ", matchCase=" + this.matchCase + ", useRegex=" + this.useRegex + ")";
    }

    public int hashCode() {
        int result2 = this.request.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.matchCase);
        result2 = result2 * 31 + Boolean.hashCode(this.useRegex);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KubernetesLogFilterSettings)) {
            return false;
        }
        KubernetesLogFilterSettings kubernetesLogFilterSettings = (KubernetesLogFilterSettings)other;
        if (!Intrinsics.areEqual((Object)this.request, (Object)kubernetesLogFilterSettings.request)) {
            return false;
        }
        if (this.matchCase != kubernetesLogFilterSettings.matchCase) {
            return false;
        }
        return this.useRegex == kubernetesLogFilterSettings.useRegex;
    }
}

