/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.kubernetes.api.settings.KubernetesLogsGlobalSettings;
import com.intellij.kubernetes.api.settings.LogHighlightingPattern;
import com.intellij.kubernetes.logs.AnsiSegment;
import com.intellij.kubernetes.logs.KubernetesAnsiParsingException;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.KubernetesLogAnsiSegmentKt;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.logs.KubernetesLogStateManager;
import com.intellij.kubernetes.logs.LogEntry;
import com.intellij.kubernetes.logs.LogLineEntry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a4\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002\u001a\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000bH\u0002\u001a\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0000\u001a\u0012\u0010(\u001a\u00020)*\b\u0012\u0004\u0012\u00020\t0\u000bH\u0000\"'\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0018\u0010\u0018\u001a\n \u0003*\u0004\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\"\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u001b\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00170\u00170\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"HYPERLINK_INFO_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getHYPERLINK_INFO_KEY", "()Lcom/intellij/openapi/util/Key;", "buildLogEntriesList", "", "Lcom/intellij/kubernetes/logs/LogLineEntry;", "logsList", "", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "presentationSettings", "Lcom/intellij/kubernetes/logs/KubernetesLogPresentationSettings;", "hyperLinkRegistry", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager$HyperLinkCachedCreator;", "createLogEntry", "Lcom/intellij/kubernetes/logs/LogEntry;", "log", "highlighters", "Lcom/intellij/kubernetes/api/settings/LogHighlightingPattern;", "determineContentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "NORMAL_OUTPUT", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "TIMESTAMP_CONTENT_TYPE", "SOURCE_CONTENT_TYPE", "getSOURCE_CONTENT_TYPE", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "LAZY_NORMAL", "Lkotlin/Lazy;", "LAZY_SOURCE", "LAZY_TIMESTAMP", "OPENING_BRACKET_ENTRY", "CLOSING_BRACKET_TAB_ENTRY", "LINE_BREAK_ENTRY", "disposeHighlighting", "", "logsToDispose", "joinToString", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogEntry.kt\ncom/intellij/kubernetes/logs/KubernetesLogEntryKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n15#2:148\n295#3,2:149\n1368#3:152\n1454#3,5:153\n1#4:151\n*S KotlinDebug\n*F\n+ 1 KubernetesLogEntry.kt\ncom/intellij/kubernetes/logs/KubernetesLogEntryKt\n*L\n71#1:148\n91#1:149,2\n147#1:152\n147#1:153,5\n*E\n"})
public final class KubernetesLogEntryKt {
    @NotNull
    private static final Key<HyperlinkInfo> HYPERLINK_INFO_KEY;
    private static final ConsoleViewContentType NORMAL_OUTPUT;
    @NotNull
    private static final ConsoleViewContentType TIMESTAMP_CONTENT_TYPE;
    @NotNull
    private static final ConsoleViewContentType SOURCE_CONTENT_TYPE;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_NORMAL;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_SOURCE;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_TIMESTAMP;
    @NotNull
    private static final LogEntry OPENING_BRACKET_ENTRY;
    @NotNull
    private static final LogEntry CLOSING_BRACKET_TAB_ENTRY;
    @NotNull
    private static final LogEntry LINE_BREAK_ENTRY;

    @NotNull
    public static final Key<HyperlinkInfo> getHYPERLINK_INFO_KEY() {
        return HYPERLINK_INFO_KEY;
    }

    @NotNull
    public static final List<LogLineEntry> buildLogEntriesList(@NotNull List<? extends KubernetesContextLog> logsList, @NotNull KubernetesLogPresentationSettings presentationSettings, @NotNull KubernetesLogStateManager.HyperLinkCachedCreator hyperLinkRegistry) {
        Intrinsics.checkNotNullParameter(logsList, (String)"logsList");
        Intrinsics.checkNotNullParameter((Object)presentationSettings, (String)"presentationSettings");
        Intrinsics.checkNotNullParameter((Object)hyperLinkRegistry, (String)"hyperLinkRegistry");
        List logEntries = new ArrayList();
        List<LogHighlightingPattern> highlighters = KubernetesLogsGlobalSettings.Companion.getInstance().getLogsHighlighters$intellij_clouds_kubernetes();
        Iterator iterator = ((Iterable)logsList).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int lineIndex = n++;
            KubernetesContextLog log2 = (KubernetesContextLog)iterator.next();
            LogLineEntry logLineEntry = new LogLineEntry(lineIndex, KubernetesLogEntryKt.createLogEntry(presentationSettings, log2, hyperLinkRegistry, highlighters), log2);
            logEntries.add(logLineEntry);
        }
        return logEntries;
    }

    private static final List<LogEntry> createLogEntry(KubernetesLogPresentationSettings presentationSettings, KubernetesContextLog log2, KubernetesLogStateManager.HyperLinkCachedCreator hyperLinkRegistry, List<LogHighlightingPattern> highlighters) {
        List logLineEntries = new ArrayList();
        if (presentationSettings.getShowTimestamp()) {
            logLineEntries.add(new LogEntry("[" + log2.getPrettyTimestamp() + "]\t", LAZY_TIMESTAMP, null, null, 12, null));
        }
        if (presentationSettings.getShowSource()) {
            logLineEntries.add(OPENING_BRACKET_ENTRY);
            logLineEntries.add(new LogEntry(log2.getSource(), LAZY_SOURCE, hyperLinkRegistry.getHyperlinkInfoForLog$intellij_clouds_kubernetes(log2), null, 8, null));
            logLineEntries.add(CLOSING_BRACKET_TAB_ENTRY);
        }
        if (presentationSettings.getShowMessage()) {
            if (KubernetesLogAnsiSegmentKt.containsAnsiCsi(log2.getMessage())) {
                boolean ansiSegments22;
                try {
                    List<AnsiSegment> ansiSegments22 = KubernetesLogAnsiSegmentKt.parseStringWithAnsiCsi(log2.getMessage());
                    for (AnsiSegment it : ansiSegments22) {
                        logLineEntries.add(it.toLogEntry$intellij_clouds_kubernetes());
                    }
                    ansiSegments22 = logLineEntries.add(new LogEntry("\n", LAZY_NORMAL, null, null, 12, null));
                }
                catch (KubernetesAnsiParsingException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(AnsiSegment.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warnWithDebug("Exception during log ANSI line parsing", (Throwable)e);
                    ansiSegments22 = logLineEntries.add(new LogEntry(KubernetesLogAnsiSegmentKt.stripAnsiCsi(log2.getMessage()) + "\n", LAZY_NORMAL, null, null, 12, null));
                }
                v1 = ansiSegments22;
            } else {
                ConsoleViewContentType logEntryContentType = KubernetesLogEntryKt.determineContentType(log2, highlighters);
                v1 = logLineEntries.add(new LogEntry(log2.getMessage() + "\n", LazyKt.lazy(() -> KubernetesLogEntryKt.createLogEntry$lambda$0(logEntryContentType)), null, null, 12, null));
            }
        } else {
            v1 = logLineEntries.add(LINE_BREAK_ENTRY);
        }
        return logLineEntries;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConsoleViewContentType determineContentType(KubernetesContextLog log2, List<LogHighlightingPattern> highlighters) {
        ConsoleViewContentType consoleViewContentType;
        LogHighlightingPattern matchedHighlighter;
        Object v0;
        int n;
        block3: {
            String message2 = log2.getMessage();
            Iterable $this$firstOrNull$iv = highlighters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                LogHighlightingPattern it = (LogHighlightingPattern)element$iv;
                n = 0;
                if (!(it.getEnabled() && new Regex(it.getPattern()).containsMatchIn((CharSequence)message2))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        LogHighlightingPattern logHighlightingPattern = matchedHighlighter = (LogHighlightingPattern)v0;
        if (logHighlightingPattern != null) {
            void it;
            LogHighlightingPattern it2 = logHighlightingPattern;
            boolean bl = false;
            int fontStyle = it2.getBold() && it2.getItalic() ? 3 : (it2.getBold() ? 1 : (it2.getItalic() ? 2 : 0));
            n = it2.getFgRgb();
            String string = "KUBERNETES_LOG_CVCT";
            boolean bl2 = false;
            int n2 = fontStyle;
            EffectType effectType = null;
            Color color = null;
            Color color2 = null;
            Color color3 = (Color)new JBColor((int)it, (int)it);
            TextAttributes textAttributes = new TextAttributes(color3, color2, color, effectType, n2);
            String string2 = string;
            consoleViewContentType = new ConsoleViewContentType(string2, textAttributes);
        } else {
            ConsoleViewContentType consoleViewContentType2 = NORMAL_OUTPUT;
            consoleViewContentType = consoleViewContentType2;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
        }
        return consoleViewContentType;
    }

    @NotNull
    public static final ConsoleViewContentType getSOURCE_CONTENT_TYPE() {
        return SOURCE_CONTENT_TYPE;
    }

    public static final void disposeHighlighting(@NotNull List<LogLineEntry> logsToDispose) {
        Intrinsics.checkNotNullParameter(logsToDispose, (String)"logsToDispose");
        for (LogLineEntry previousLogLine : logsToDispose) {
            for (LogEntry previousEntry : previousLogLine.getLogEntries()) {
                RangeHighlighter rangeHighlighter = previousEntry.getHighlighter();
                if (rangeHighlighter == null) continue;
                rangeHighlighter.dispose();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String joinToString(@NotNull List<LogLineEntry> $this$joinToString) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$joinToString, (String)"<this>");
        Iterable $this$flatMap$iv = $this$joinToString;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LogLineEntry it = (LogLineEntry)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLogEntries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, KubernetesLogEntryKt::joinToString$lambda$8, (int)30, null);
    }

    private static final ConsoleViewContentType createLogEntry$lambda$0(ConsoleViewContentType $logEntryContentType) {
        return $logEntryContentType;
    }

    private static final ConsoleViewContentType LAZY_NORMAL$lambda$4() {
        return NORMAL_OUTPUT;
    }

    private static final ConsoleViewContentType LAZY_SOURCE$lambda$5() {
        return SOURCE_CONTENT_TYPE;
    }

    private static final ConsoleViewContentType LAZY_TIMESTAMP$lambda$6() {
        return TIMESTAMP_CONTENT_TYPE;
    }

    private static final CharSequence joinToString$lambda$8(LogEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    static {
        Key key = Key.create((String)"HYPERLINK_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HYPERLINK_INFO_KEY = key;
        NORMAL_OUTPUT = ConsoleViewContentType.NORMAL_OUTPUT;
        TIMESTAMP_CONTENT_TYPE = new ConsoleViewContentType("KUBERNETES_TIMESTAMP", new TextAttributes((Color)JBColor.GRAY, null, null, null, 0));
        SOURCE_CONTENT_TYPE = new ConsoleViewContentType("KUBERNETES_SOURCE", new TextAttributes((Color)JBColor.namedColor((String)"Link.activeForeground", (Color)((Color)new JBColor(5807606, 5807606))), null, (Color)JBColor.namedColor((String)"Link.activeForeground", (Color)((Color)new JBColor(5807606, 5807606))), EffectType.LINE_UNDERSCORE, 0));
        LAZY_NORMAL = LazyKt.lazy(KubernetesLogEntryKt::LAZY_NORMAL$lambda$4);
        LAZY_SOURCE = LazyKt.lazy(KubernetesLogEntryKt::LAZY_SOURCE$lambda$5);
        LAZY_TIMESTAMP = LazyKt.lazy(KubernetesLogEntryKt::LAZY_TIMESTAMP$lambda$6);
        OPENING_BRACKET_ENTRY = new LogEntry("(", LAZY_NORMAL, null, null, 12, null);
        CLOSING_BRACKET_TAB_ENTRY = new LogEntry(")\t", LAZY_NORMAL, null, null, 12, null);
        LINE_BREAK_ENTRY = new LogEntry("\n", LAZY_NORMAL, null, null, 12, null);
    }
}

