/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.logs.KubernetesLogJobController;
import com.intellij.kubernetes.logs.KubernetesLogJobManagerKt;
import com.intellij.kubernetes.logs.KubernetesLogStateManager;
import com.intellij.kubernetes.logs.KubernetesLogUIManager;
import com.intellij.kubernetes.logs.ui.KubernetesContextLogsTabPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;", "Lcom/intellij/openapi/Disposable;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "stateManager", "Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "getStateManager$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/logs/KubernetesLogStateManager;", "logJobController", "Lcom/intellij/kubernetes/logs/KubernetesLogJobController;", "uiManager", "Lcom/intellij/kubernetes/logs/KubernetesLogUIManager;", "getUiManager$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/logs/KubernetesLogUIManager;", "logTabPanel", "Lcom/intellij/kubernetes/logs/ui/KubernetesContextLogsTabPanel;", "getLogTabPanel$intellij_clouds_kubernetes", "()Lcom/intellij/kubernetes/logs/ui/KubernetesContextLogsTabPanel;", "launchDownloadLogs", "Lkotlinx/coroutines/Job;", "launchDownloadLogs$intellij_clouds_kubernetes", "dispose", "", "isStateManagerDisposed", "", "intellij.clouds.kubernetes"})
public final class KubernetesContextLogsManager
implements Disposable {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final KubernetesLogStateManager stateManager;
    @NotNull
    private final KubernetesLogJobController logJobController;
    @NotNull
    private final KubernetesLogUIManager uiManager;

    public KubernetesContextLogsManager(@NotNull KubernetesApiModel apiModel2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        this.apiModel = apiModel2;
        this.stateManager = new KubernetesLogStateManager(this.apiModel);
        this.logJobController = new KubernetesLogJobController(this.stateManager);
        this.uiManager = new KubernetesLogUIManager(this.stateManager, this.logJobController);
        Disposer.register((Disposable)((Disposable)this.apiModel), (Disposable)this);
    }

    @NotNull
    public final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    @NotNull
    public final KubernetesLogStateManager getStateManager$intellij_clouds_kubernetes() {
        return this.stateManager;
    }

    @NotNull
    public final KubernetesLogUIManager getUiManager$intellij_clouds_kubernetes() {
        return this.uiManager;
    }

    @NotNull
    public final KubernetesContextLogsTabPanel getLogTabPanel$intellij_clouds_kubernetes() {
        return this.uiManager.getLogTabPanel();
    }

    @NotNull
    public final Job launchDownloadLogs$intellij_clouds_kubernetes() {
        return KubernetesLogJobManagerKt.launchDownloadLogs(this.stateManager);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.logJobController);
        Disposer.dispose((Disposable)this.uiManager);
    }

    public final boolean isStateManagerDisposed() {
        return !CoroutineScopeKt.isActive((CoroutineScope)this.stateManager.getCoroutineScope$intellij_clouds_kubernetes());
    }
}

