/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.psi.PsiElement;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.SemverException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/helm/model/SemVerRangeMetaClass;", "Lorg/jetbrains/yaml/meta/model/YamlStringType;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "<init>", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "validateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
public final class SemVerRangeMetaClass
extends YamlStringType {
    public SemVerRangeMetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        try {
            Requirement.buildNPM(YamlUtilKt.getEffectiveText((YAMLValue)scalarValue));
        }
        catch (SemverException e) {
            PsiElement psiElement = (PsiElement)scalarValue;
            String string = e.getMessage();
            if (string == null) {
                String string2 = KubernetesBundle.message("HelmChartUnknownValuesInspection.invalid.semver.requirement.message", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            holder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

