/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.DependencyAliasPomTarget;
import com.intellij.kubernetes.helm.model.DependencyObject;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/helm/model/AliasedDependencyObject;", "Lcom/intellij/kubernetes/helm/model/DependencyObject;", "hostChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "dependency", "Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;", "keyVals", "", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "<init>", "(Lcom/intellij/kubernetes/helm/chart/Chart;Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;Ljava/util/Collection;)V", "createPomTarget", "Lcom/intellij/pom/PomTarget;", "secondaryElements", "Lcom/intellij/psi/PsiElement;", "getSecondaryElements", "()Ljava/util/Collection;", "isRenameable", "", "()Z", "intellij.clouds.kubernetes"})
public final class AliasedDependencyObject
extends DependencyObject {
    private final boolean isRenameable;

    public AliasedDependencyObject(@NotNull Chart hostChart, @NotNull Chart.Dependency dependency, @NotNull Collection<? extends YAMLKeyValue> keyVals) {
        Intrinsics.checkNotNullParameter((Object)hostChart, (String)"hostChart");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter(keyVals, (String)"keyVals");
        super(hostChart, dependency, keyVals, null);
        this.isRenameable = true;
    }

    @Override
    @NotNull
    protected PomTarget createPomTarget() {
        String string = this.getDependency().getAlias();
        Intrinsics.checkNotNull((Object)string);
        return (PomTarget)new DependencyAliasPomTarget(string, this.getPathInChart(), this.getDependency());
    }

    @Override
    @NotNull
    public Collection<PsiElement> getSecondaryElements() {
        YAMLMapping yAMLMapping = this.getDependency().getElement();
        return CollectionsKt.listOfNotNull((Object)(yAMLMapping != null ? YamlUtilKt.get(yAMLMapping, "alias") : null));
    }

    @Override
    public boolean isRenameable() {
        return this.isRenameable;
    }
}

