/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.gotpl;

import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.gotpl.HelmTextLanguage;
import com.intellij.kubernetes.helm.gotpl.i18n.ChartsGoTemplateBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/HelmTextFileType;", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "Lcom/intellij/openapi/fileTypes/TemplateLanguageFileType;", "Lcom/intellij/openapi/fileTypes/ex/FileTypeIdentifiableByVirtualFile;", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "()V", "isMyFileType", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "getDescription", "getDefaultExtension", "getIcon", "Ljavax/swing/Icon;", "getCharset", "content", "", "intellij.clouds.kubernetes.charts.gotpl"})
public final class HelmTextFileType
extends LanguageFileType
implements TemplateLanguageFileType,
FileTypeIdentifiableByVirtualFile,
FileType {
    private HelmTextFileType() {
        super((Language)HelmTextLanguage.Companion.getInstance());
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !YamlUtilKt.hasYamlExtension(file) && !YamlUtilKt.hasJsonExtension(file) && Chart.Companion.isChartsTemplateFile(file);
    }

    @NotNull
    public String getName() {
        return "Helm TEXT template";
    }

    @NotNull
    public String getDescription() {
        String string = ChartsGoTemplateBundle.message("filetype.HelmText.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "txt";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = KubernetesIcons.Helm;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Helm");
        return icon;
    }

    @NotNull
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return "UTF-8";
    }
}

