/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.gotpl;

import com.goide.template.GoTemplateCompletionContributor;
import com.goide.template.GoTemplateTypes;
import com.goide.template.file.GoTemplateFileType;
import com.goide.template.psi.GoTemplateDefineStatement;
import com.goide.template.psi.GoTemplateElementFactory;
import com.goide.template.psi.GoTemplateExpression;
import com.goide.template.psi.GoTemplateFieldChainExpr;
import com.goide.template.psi.GoTemplateFile;
import com.goide.template.psi.GoTemplateLiteral;
import com.goide.template.psi.GoTemplateLiteralExpr;
import com.goide.template.psi.GoTemplatePipeline;
import com.goide.template.psi.GoTemplatePipelineStatement;
import com.goide.template.psi.GoTemplateStringLiteral;
import com.goide.template.psi.GoTemplateTemplateStatement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.FilteredTraverserBase;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0005\u001a\u0016\u0010\t\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0005\u001a\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f\u001a\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0017\u001a\u00020\u000f\u001a\u0010\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u001a\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u0007\u001a\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0007\u001a\u000e\u0010!\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0007\u001a\u001e\u0010\"\u001a\u00020\u00162\b\u0010#\u001a\u0004\u0018\u00010\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%\"\u0015\u0010\u0012\u001a\u00020\u0005*\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"createDummyGoTemplateWithText", "Lcom/goide/template/psi/GoTemplateFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "createGoTemplateIdentifier", "Lcom/intellij/psi/PsiElement;", "id", "createGoTemplateStringLiteral", "varName", "createGoTemplatePipelineStatement", "body", "getStringFromStringLiteral", "literal", "Lcom/goide/template/psi/GoTemplateStringLiteral;", "createLDoubleBrace", "createRDoubleBrace", "unquotedString", "getUnquotedString", "(Lcom/goide/template/psi/GoTemplateStringLiteral;)Ljava/lang/String;", "isTemplateReference", "", "str", "getTemplateDefinition", "Lcom/goide/template/psi/GoTemplateDefineStatement;", "isStandardGoTemplateFunction", "name", "isFunctionReference", "refElement", "getOwnerFieldChain", "Lcom/goide/template/psi/GoTemplateFieldChainExpr;", "element", "isIdentifier", "match", "fieldChain", "nameChain", "", "intellij.clouds.kubernetes.charts.gotpl"})
@SourceDebugExtension(value={"SMAP\nGoTemplateUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoTemplateUtil.kt\ncom/intellij/kubernetes/helm/gotpl/GoTemplateUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1#2:141\n*E\n"})
public final class GoTemplateUtilKt {
    @NotNull
    public static final GoTemplateFile createDummyGoTemplateWithText(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("temp." + GoTemplateFileType.INSTANCE.getDefaultExtension(), (FileType)GoTemplateFileType.INSTANCE, (CharSequence)text, LocalTimeCounter.currentTime(), true);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type com.goide.template.psi.GoTemplateFile");
        return (GoTemplateFile)psiFile;
    }

    @NotNull
    public static final PsiElement createGoTemplateIdentifier(@NotNull Project project, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        GoTemplateFile tempFile = GoTemplateUtilKt.createDummyGoTemplateWithText(project, "{{ ." + id + " }}");
        FilteredTraverserBase filteredTraverserBase = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)tempFile)).filter(arg_0 -> GoTemplateUtilKt.createGoTemplateIdentifier$lambda$1(GoTemplateUtilKt::createGoTemplateIdentifier$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"filter(...)");
        Object object = CollectionsKt.first((Iterable)((Iterable)filteredTraverserBase));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return (PsiElement)object;
    }

    @NotNull
    public static final PsiElement createGoTemplateStringLiteral(@NotNull Project project, @NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        GoTemplateFile tempFile = GoTemplateUtilKt.createDummyGoTemplateWithText(project, "{{ \"" + varName + "\" }}");
        Object object = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)tempFile)).filter(GoTemplateStringLiteral.class).first();
        Intrinsics.checkNotNull((Object)object);
        return (PsiElement)object;
    }

    @NotNull
    public static final PsiElement createGoTemplatePipelineStatement(@NotNull Project project, @NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        String stmtText = "{{ " + body + " }}";
        GoTemplateFile $this$createGoTemplatePipelineStatement_u24lambda_u242 = GoTemplateElementFactory.createFileFromText((Project)project, (String)stmtText);
        boolean bl = false;
        Class[] classArray = new Class[]{GoTemplatePipelineStatement.class};
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)$this$createGoTemplatePipelineStatement_u24lambda_u242), (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
        GoTemplatePipelineStatement goTemplatePipelineStatement = (GoTemplatePipelineStatement)CollectionsKt.first((Iterable)collection);
        Intrinsics.checkNotNullExpressionValue((Object)goTemplatePipelineStatement, (String)"run(...)");
        return (PsiElement)goTemplatePipelineStatement;
    }

    @NotNull
    public static final String getStringFromStringLiteral(@NotNull GoTemplateStringLiteral literal) {
        Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
        String string = StringUtil.unquoteString((String)literal.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unquoteString(...)");
        return string;
    }

    @NotNull
    public static final PsiElement createLDoubleBrace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement stmt = GoTemplateUtilKt.createGoTemplatePipelineStatement(project, "dummy");
        ASTNode aSTNode = stmt.getNode().findChildByType(GoTemplateTypes.LDOUBLE_BRACE);
        Object object = aSTNode != null ? aSTNode.getPsi() : null;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public static final PsiElement createRDoubleBrace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiElement stmt = GoTemplateUtilKt.createGoTemplatePipelineStatement(project, "dummy");
        ASTNode aSTNode = stmt.getNode().findChildByType(GoTemplateTypes.RDOUBLE_BRACE);
        Object object = aSTNode != null ? aSTNode.getPsi() : null;
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public static final String getUnquotedString(@NotNull GoTemplateStringLiteral $this$unquotedString) {
        Intrinsics.checkNotNullParameter((Object)$this$unquotedString, (String)"<this>");
        return GoTemplateUtilKt.getStringFromStringLiteral($this$unquotedString);
    }

    public static final boolean isTemplateReference(@NotNull GoTemplateStringLiteral str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        GoTemplateTemplateStatement templateStatement = (GoTemplateTemplateStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)str), GoTemplateTemplateStatement.class);
        if (templateStatement != null) {
            return Intrinsics.areEqual((Object)templateStatement.getStringLiteral(), (Object)str);
        }
        GoTemplatePipeline pipeline = (GoTemplatePipeline)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)str), GoTemplatePipeline.class);
        if (pipeline != null) {
            List list2 = pipeline.getExpressionList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getExpressionList(...)");
            GoTemplateExpression firstExpression = (GoTemplateExpression)CollectionsKt.firstOrNull((List)list2);
            if (firstExpression instanceof GoTemplateLiteralExpr) {
                PsiElement psiElement = ((GoTemplateLiteralExpr)firstExpression).getLiteral().getIdentifier();
                if (Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)"include")) {
                    List list3 = pipeline.getExpressionList();
                    Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getExpressionList(...)");
                    GoTemplateExpression secondExpression = (GoTemplateExpression)CollectionsKt.getOrNull((List)list3, (int)1);
                    if (secondExpression instanceof GoTemplateLiteralExpr && Intrinsics.areEqual((Object)((GoTemplateLiteralExpr)secondExpression).getLiteral().getStringLiteral(), (Object)str)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Nullable
    public static final GoTemplateDefineStatement getTemplateDefinition(@NotNull GoTemplateStringLiteral str) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        GoTemplateDefineStatement goTemplateDefineStatement = (GoTemplateDefineStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)str), GoTemplateDefineStatement.class);
        if (goTemplateDefineStatement != null) {
            GoTemplateDefineStatement goTemplateDefineStatement2;
            GoTemplateDefineStatement it = goTemplateDefineStatement2 = goTemplateDefineStatement;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getStringLiteral(), (Object)str) ? goTemplateDefineStatement2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public static final boolean isStandardGoTemplateFunction(@Nullable String name) {
        return GoTemplateCompletionContributor.BUILTIN_FUNCTIONS.contains(name);
    }

    public static final boolean isFunctionReference(@NotNull PsiElement refElement) {
        Intrinsics.checkNotNullParameter((Object)refElement, (String)"refElement");
        return refElement instanceof GoTemplateLiteral || GoTemplateUtilKt.isIdentifier(refElement) && refElement.getParent() instanceof GoTemplateLiteral;
    }

    @Nullable
    public static final GoTemplateFieldChainExpr getOwnerFieldChain(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof GoTemplateFieldChainExpr) {
            return (GoTemplateFieldChainExpr)element;
        }
        if (GoTemplateUtilKt.isIdentifier(element)) {
            PsiElement psiElement = element.getParent();
            return psiElement instanceof GoTemplateFieldChainExpr ? (GoTemplateFieldChainExpr)psiElement : null;
        }
        return null;
    }

    public static final boolean isIdentifier(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)element.getNode().getElementType(), (Object)GoTemplateTypes.IDENTIFIER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean match(@Nullable GoTemplateFieldChainExpr fieldChain, @NotNull List<String> nameChain) {
        Intrinsics.checkNotNullParameter(nameChain, (String)"nameChain");
        if (fieldChain == null) {
            if (nameChain.isEmpty()) return true;
        }
        if (fieldChain == null) return false;
        if (nameChain.isEmpty()) return false;
        String string = fieldChain.getIdentifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.compareTo((String)string, (String)((String)CollectionsKt.last(nameChain)), (boolean)true) != 0) return false;
        GoTemplateExpression goTemplateExpression = fieldChain.getQualifier();
        if (!GoTemplateUtilKt.match(goTemplateExpression instanceof GoTemplateFieldChainExpr ? (GoTemplateFieldChainExpr)goTemplateExpression : null, nameChain.subList(0, nameChain.size() - 1))) return false;
        return true;
    }

    private static final boolean createGoTemplateIdentifier$lambda$0(PsiElement it) {
        return Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)GoTemplateTypes.IDENTIFIER);
    }

    private static final boolean createGoTemplateIdentifier$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

