/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.dependencies.dto;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import com.intellij.kubernetes.helm.dependencies.dto.RepoChartDto;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0002\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0002H\u0002\u001a&\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"readChartNames", "", "", "file", "Ljava/nio/file/Path;", "input", "Ljava/io/InputStream;", "skipToEntriesStart", "", "parser", "Lcom/fasterxml/jackson/dataformat/yaml/YAMLParser;", "readRepoCharts", "Lcom/intellij/kubernetes/helm/dependencies/dto/RepoChartDto;", "chartName", "readEntries", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "readChartEntriesFromSequence", "skipToEndOfSequence", "skipToEndOfObject", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmRepoDto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmRepoDto.kt\ncom/intellij/kubernetes/helm/dependencies/dto/HelmRepoDtoKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class HelmRepoDtoKt {
    @NotNull
    public static final List<String> readChartNames(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return HelmRepoDtoKt.readChartNames(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<String> readChartNames(InputStream input) {
        YAMLFactory factory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        mapper.registerModule((Module)new SimpleModule());
        Closeable closeable = new InputStreamReader(input);
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl = false;
            YAMLParser parser = factory.createParser((Reader)it);
            Intrinsics.checkNotNull((Object)parser);
            HelmRepoDtoKt.skipToEntriesStart(parser);
            List<String> list2 = HelmRepoDtoKt.readChartNames(parser);
            return list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final void skipToEntriesStart(YAMLParser parser) {
        JsonToken token;
        while (!(parser.isClosed() || JsonToken.FIELD_NAME == (token = parser.nextToken()) && Intrinsics.areEqual((Object)"entries", (Object)parser.getCurrentName()))) {
        }
    }

    private static final List<String> readChartNames(YAMLParser parser) {
        JsonToken token = parser.nextToken();
        if (token != JsonToken.START_OBJECT) {
            return CollectionsKt.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        while (!parser.isClosed()) {
            token = parser.nextToken();
            if (token == JsonToken.FIELD_NAME) {
                if (parser.getCurrentName() != null) {
                    String p0;
                    boolean bl = false;
                    result2.add(p0);
                }
                continue;
            }
            if (token == JsonToken.START_OBJECT) {
                HelmRepoDtoKt.skipToEndOfObject(parser);
                continue;
            }
            if (token != JsonToken.END_OBJECT) continue;
            break;
        }
        return result2;
    }

    @NotNull
    public static final List<RepoChartDto> readRepoCharts(@NotNull Path file, @NotNull String chartName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)chartName, (String)"chartName");
        InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return HelmRepoDtoKt.readRepoCharts(inputStream, chartName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<RepoChartDto> readRepoCharts(InputStream input, String chartName) {
        YAMLFactory factory = new YAMLFactory();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        mapper.registerModule((Module)new SimpleModule());
        Closeable closeable = new InputStreamReader(input);
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl = false;
            YAMLParser parser = factory.createParser((Reader)it);
            Intrinsics.checkNotNull((Object)parser);
            HelmRepoDtoKt.skipToEntriesStart(parser);
            List<RepoChartDto> list2 = HelmRepoDtoKt.readEntries(mapper, parser, chartName);
            return list2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final List<RepoChartDto> readEntries(ObjectMapper mapper, YAMLParser parser, String chartName) {
        JsonToken token = parser.nextToken();
        if (token != JsonToken.START_OBJECT) {
            return CollectionsKt.emptyList();
        }
        while (!parser.isClosed() && (token = parser.nextToken()) == JsonToken.FIELD_NAME) {
            String currentEntryName = parser.getCurrentName();
            if (!Intrinsics.areEqual((Object)currentEntryName, (Object)chartName)) {
                token = parser.nextToken();
                if (token != JsonToken.START_ARRAY) {
                    return CollectionsKt.emptyList();
                }
                HelmRepoDtoKt.skipToEndOfSequence(parser);
                continue;
            }
            return HelmRepoDtoKt.readChartEntriesFromSequence(mapper, parser);
        }
        return CollectionsKt.emptyList();
    }

    private static final List<RepoChartDto> readChartEntriesFromSequence(ObjectMapper mapper, YAMLParser parser) {
        if (parser.nextToken() != JsonToken.START_ARRAY) {
            return CollectionsKt.emptyList();
        }
        ArrayList<RepoChartDto> result2 = new ArrayList<RepoChartDto>();
        try {
            while (parser.nextToken() == JsonToken.START_OBJECT) {
                RepoChartDto repoChartDto;
                RepoChartDto repoChartDto2 = repoChartDto = (RepoChartDto)mapper.readValue((JsonParser)parser, RepoChartDto.class);
                if (repoChartDto2 != null) {
                    result2.add(repoChartDto2);
                    continue;
                }
                break;
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        return result2;
    }

    private static final void skipToEndOfSequence(YAMLParser parser) {
        block4: while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    break block4;
                }
                case 2: {
                    HelmRepoDtoKt.skipToEndOfSequence(parser);
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    private static final void skipToEndOfObject(YAMLParser parser) {
        block4: while (!parser.isClosed()) {
            JsonToken jsonToken = parser.nextToken();
            switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 3: {
                    break block4;
                }
                case 4: {
                    HelmRepoDtoKt.skipToEndOfObject(parser);
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.END_ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.START_ARRAY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.END_OBJECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.START_OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

