/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.chart;

import com.intellij.codeWithMe.ClientId;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartPresence;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0001\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/helm/chart/ChartLocator;", "", "<init>", "()V", "locateChartByTemplateFileOrDir", "Lcom/intellij/kubernetes/helm/chart/ChartPresence;", "templateFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "locateChartByChartDir", "chartDirCandidate", "locateChartByValuesFile", "file", "locateChartByNonSpecialSubDir", "dir", "findChartYamlByChartDir", "chartDir", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nChartLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartLocator.kt\ncom/intellij/kubernetes/helm/chart/ChartLocator\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n129#2:64\n1#3:65\n*S KotlinDebug\n*F\n+ 1 ChartLocator.kt\ncom/intellij/kubernetes/helm/chart/ChartLocator\n*L\n34#1:64\n*E\n"})
public final class ChartLocator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final ChartPresence locateChartByTemplateFileOrDir(@NotNull VirtualFile templateFile) {
        Intrinsics.checkNotNullParameter((Object)templateFile, (String)"templateFile");
        VirtualFile virtualFile = VfsUtilCore.findContainingDirectory((VirtualFile)templateFile, (CharSequence)"templates");
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            return null;
        }
        VirtualFile chartDirCandidate = virtualFile;
        ChartPresence chartPresence = this.locateChartByChartDir(chartDirCandidate);
        if (chartPresence == null) {
            chartPresence = this.locateChartByTemplateFileOrDir(chartDirCandidate);
        }
        return chartPresence;
    }

    @Nullable
    public final ChartPresence locateChartByChartDir(@NotNull VirtualFile chartDirCandidate) {
        ChartPresence chartPresence;
        Intrinsics.checkNotNullParameter((Object)chartDirCandidate, (String)"chartDirCandidate");
        VirtualFile chartYaml = this.findChartYamlByChartDir(chartDirCandidate);
        CustomChartSupport.CustomChartInfo customChartInfo = (CustomChartSupport.CustomChartInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes()), arg_0 -> ChartLocator.locateChartByChartDir$lambda$0(chartDirCandidate, arg_0)));
        boolean condition$iv = chartYaml != null || customChartInfo != null;
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            CustomChartSupport.CustomChartInfo customChartInfo2 = customChartInfo;
            CustomChartSupport.CustomChartInfo customChartInfo3 = customChartInfo;
            chartPresence = new ChartPresence(customChartInfo2 != null ? customChartInfo2.getChartType() : null, customChartInfo3 != null ? customChartInfo3.getChartInfoSupplier() : null, chartDirCandidate, chartYaml);
        } else {
            chartPresence = null;
        }
        return chartPresence;
    }

    @Nullable
    public final ChartPresence locateChartByValuesFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Chart.Companion.isValuesYamlName(file.getNameSequence())) {
            return null;
        }
        VirtualFile virtualFile = file.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parentDir = virtualFile;
        ChartPresence chartPresence = this.locateChartByChartDir(parentDir);
        if (chartPresence == null) {
            chartPresence = this.locateChartByNonSpecialSubDir(parentDir);
        }
        return chartPresence;
    }

    @Nullable
    public final ChartPresence locateChartByNonSpecialSubDir(@NotNull VirtualFile dir) {
        ChartPresence chartPresence;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        VirtualFile virtualFile = dir.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parentDir = virtualFile;
        ChartPresence thisChartYaml = this.locateChartByChartDir(parentDir);
        if (thisChartYaml != null) {
            ChartPresence chartPresence2;
            ChartPresence it = chartPresence2 = thisChartYaml;
            boolean bl = false;
            chartPresence = !Chart.Companion.isSpecialDirName(dir.getNameSequence()) ? chartPresence2 : null;
        } else {
            chartPresence = this.locateChartByNonSpecialSubDir(parentDir);
        }
        return chartPresence;
    }

    private final VirtualFile findChartYamlByChartDir(VirtualFile chartDir) {
        return YamlUtilKt.findYamlWithName(chartDir, "Chart");
    }

    private static final CustomChartSupport.CustomChartInfo locateChartByChartDir$lambda$0(VirtualFile $chartDirCandidate, CustomChartSupport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCustomChartInfo($chartDirCandidate);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/helm/chart/ChartLocator$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/kubernetes/helm/chart/ChartLocator;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nChartLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartLocator.kt\ncom/intellij/kubernetes/helm/chart/ChartLocator$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,63:1\n40#2,3:64\n*S KotlinDebug\n*F\n+ 1 ChartLocator.kt\ncom/intellij/kubernetes/helm/chart/ChartLocator$Companion\n*L\n23#1:64,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChartLocator instance() {
            boolean $i$f$service = false;
            Class<ChartLocator> serviceClass$iv = ChartLocator.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ChartLocator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

