/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.db;

import com.intellij.clouds.kubernetes.db.KubernetesDBPortForwardingConfig;
import com.intellij.clouds.kubernetes.db.KubernetesPortForwardingPanel;
import com.intellij.clouds.kubernetes.db.UtilsKt;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.ClientProperty;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0012\u0010\f\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider;", "Lcom/intellij/database/dataSource/DbOptionProvider$LocalDataSourceOptionProvider;", "Lcom/intellij/clouds/kubernetes/db/KubernetesDBPortForwardingConfig;", "<init>", "()V", "isApplicable", "", "target", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDisplayName", "", "getDescription", "load", "store", "", "value", "getEditor", "Lcom/intellij/database/dataSource/DbOptionProvider$EditorDesc;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLocation", "Lcom/intellij/database/dataSource/DbOptionProvider$UiLocation;", "Companion", "MyService", "intellij.clouds.kubernetes.db"})
@SourceDebugExtension(value={"SMAP\nKubernetesPortForwardingDataSourceOptionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPortForwardingDataSourceOptionProvider.kt\ncom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n1755#2,3:139\n31#3,2:142\n*S KotlinDebug\n*F\n+ 1 KubernetesPortForwardingDataSourceOptionProvider.kt\ncom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider\n*L\n71#1:139,3\n106#1:142,2\n*E\n"})
public final class KubernetesPortForwardingDataSourceOptionProvider
extends DbOptionProvider.LocalDataSourceOptionProvider<KubernetesDBPortForwardingConfig> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull LocalDataSource target) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!RegistryManager.Companion.getInstance().get("kubernetes.db.integration.enabled").asBoolean()) {
                return false;
            }
            Object object = target.getDatabaseDriver();
            if (object != null && (object = object.getJDBCUrlParsers()) != null) {
                Iterable $this$any$iv = (Iterable)object;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StatelessJdbcUrlParser it = (StatelessJdbcUrlParser)element$iv;
                        boolean bl2 = false;
                        if (!(it.getParameterNames().contains("port") && it.getParameterNames().contains("host"))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String getDisplayName() {
        String string = KubernetesBundle.message("Kubernetes.db.panel.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = KubernetesBundle.message("Kubernetes.db.panel.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public KubernetesDBPortForwardingConfig load(@Nullable LocalDataSource target) {
        return Companion.loadConfig(target);
    }

    public void store(@NotNull LocalDataSource target, @Nullable KubernetesDBPortForwardingConfig value2) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (value2 == null) {
            return;
        }
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.enabled", String.valueOf(value2.isEnabled()));
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.context", value2.getContextName());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.namespace", value2.getNamespace());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.resource.type", value2.getResourceType());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.resource", value2.getResource());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.host.port", value2.getHostPort());
        target.setAdditionalProperty("com.intellij.clouds.kubernetes.db.container.port", value2.getContainerPort());
    }

    @NotNull
    public DbOptionProvider.EditorDesc<KubernetesDBPortForwardingConfig> getEditor(@NotNull LocalDataSource target, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = dataContext.getData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNull((Object)object);
        Project project = (Project)object;
        Object object2 = dataContext.getData(AbstractDatabaseConfigurable.CONFIGURABLE);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.database.dataSource.DataSourceConfigurable");
        DataSourceConfigurable configurable = (DataSourceConfigurable)object2;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<MyService> serviceClass$iv = MyService.class;
        Object object3 = $this$service$iv.getService(serviceClass$iv);
        if (object3 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        String string = target.getUrl();
        KubernetesPortForwardingPanel panel2 = new KubernetesPortForwardingPanel(project, ((MyService)object3).getCoroutineScope(), string != null ? UtilsKt.getPortFromUrl(string) : null, configurable);
        Disposer.register((Disposable)panel2, (Disposable)((Disposable)configurable));
        JPanel component2 = panel2.getComponent();
        ClientProperty.put((JComponent)component2, (Key)DbOptionsEditor.CUSTOM_LAYOUT, (Object)true);
        return new DbOptionProvider.EditorDesc((JComponent)component2, panel2::updateSettings, panel2::getSettings);
    }

    @NotNull
    public DbOptionProvider.UiLocation getLocation() {
        return DbOptionProvider.UiLocation.NEW_TAB;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider$Companion;", "", "<init>", "()V", "loadConfig", "Lcom/intellij/clouds/kubernetes/db/KubernetesDBPortForwardingConfig;", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "intellij.clouds.kubernetes.db"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesDBPortForwardingConfig loadConfig(@Nullable LocalDataSource dataSource) {
            if (dataSource == null) {
                return new KubernetesDBPortForwardingConfig(false, null, null, null, null, null, null, 127, null);
            }
            boolean enabled = Boolean.parseBoolean(dataSource.getAdditionalProperty("com.intellij.clouds.kubernetes.db.enabled"));
            return new KubernetesDBPortForwardingConfig(enabled, dataSource.getAdditionalProperty("com.intellij.clouds.kubernetes.db.context"), dataSource.getAdditionalProperty("com.intellij.clouds.kubernetes.db.namespace"), dataSource.getAdditionalProperty("com.intellij.clouds.kubernetes.db.resource.type"), dataSource.getAdditionalProperty("com.intellij.clouds.kubernetes.db.resource"), dataSource.getAdditionalProperty("com.intellij.clouds.kubernetes.db.host.port"), dataSource.getAdditionalProperty("com.intellij.clouds.kubernetes.db.container.port"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesPortForwardingDataSourceOptionProvider$MyService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.clouds.kubernetes.db"})
    private static final class MyService {
        @NotNull
        private final CoroutineScope coroutineScope;

        public MyService(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

