/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Futures;
import com.intellij.util.io.DigestUtil;
import com.jetbrains.gateway.ssh.DeployTargetOS;
import com.jetbrains.gateway.ssh.HighLevelHostAccessor;
import com.jetbrains.gateway.ssh.LocalFileRemoteHostDownloader;
import com.jetbrains.gateway.ssh.RemoteCredentialsEx;
import com.jetbrains.gateway.ssh.RemoteHostBackendDownloader;
import com.jetbrains.gateway.ssh.RemoteHostBackendDownloaderKt;
import com.jetbrains.gateway.ssh.TransferProgressAdapter;
import com.jetbrains.gateway.ssh.deploy.ShellArgument;
import com.jetbrains.gateway.ssh.deploy.TransferProgressTracker;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/gateway/ssh/LocalFileRemoteHostDownloader;", "Lcom/jetbrains/gateway/ssh/RemoteHostBackendDownloader;", "localArchivePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getArchiveExtension", "", "getDownloadHash", "os", "Lcom/jetbrains/gateway/ssh/DeployTargetOS;", "downloadArchiveOnRemote", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "hostAccessor", "Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;", "remoteArchiveLocation", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;", "availableSpace", "", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/jetbrains/gateway/ssh/HighLevelHostAccessor;Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nRemoteHostBackendDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteHostBackendDownloader.kt\ncom/jetbrains/gateway/ssh/LocalFileRemoteHostDownloader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,231:1\n25#2:232\n*S KotlinDebug\n*F\n+ 1 RemoteHostBackendDownloader.kt\ncom/jetbrains/gateway/ssh/LocalFileRemoteHostDownloader\n*L\n124#1:232\n*E\n"})
public final class LocalFileRemoteHostDownloader
implements RemoteHostBackendDownloader {
    @NotNull
    private final Path localArchivePath;

    public LocalFileRemoteHostDownloader(@NotNull Path localArchivePath) {
        Intrinsics.checkNotNullParameter((Object)localArchivePath, (String)"localArchivePath");
        this.localArchivePath = localArchivePath;
    }

    @Override
    @NotNull
    public String getArchiveExtension() {
        return RemoteHostBackendDownloaderKt.access$getArchiveExtension(((Object)this.localArchivePath.getFileName()).toString());
    }

    @Override
    @NotNull
    public String getDownloadHash(@NotNull DeployTargetOS os) {
        String string;
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        MessageDigest digestMethod = MessageDigest.getInstance("SHA-256");
        Intrinsics.checkNotNull((Object)digestMethod);
        DigestUtil.updateContentHash$default((MessageDigest)digestMethod, (Path)this.localArchivePath, null, (int)4, null);
        byte[] digest = digestMethod.digest();
        String name = PathsKt.getName((Path)this.localArchivePath);
        Intrinsics.checkNotNull((Object)digest);
        String hash = string = RemoteHostBackendDownloaderKt.access$combineHumanReadableHash(os, name, digest);
        boolean bl = false;
        LocalFileRemoteHostDownloader $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(LocalFileRemoteHostDownloader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("download hash for name: " + name + " is " + hash);
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object downloadArchiveOnRemote(@NotNull ProgressIndicator var1_1, @NotNull HighLevelHostAccessor var2_2, @NotNull ShellArgument.RemotePath var3_3, long var4_4, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof downloadArchiveOnRemote.1)) ** GOTO lbl-1000
        var14_6 = $completion;
        if ((var14_6.label & -2147483648) != 0) {
            var14_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                long J$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ LocalFileRemoteHostDownloader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadArchiveOnRemote(null, null, null, 0L, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var15_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!remoteArchiveLocation.isRooted()) {
                    throw new IllegalStateException(("Download location must be rooted. Download location: '" + remoteArchiveLocation + "'").toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = progressIndicator;
                $continuation.L$2 = hostAccessor;
                $continuation.L$3 = remoteArchiveLocation;
                $continuation.J$0 = availableSpace;
                $continuation.label = 1;
                v0 = hostAccessor.canUnarchive(remoteArchiveLocation, (Continuation<? super HighLevelHostAccessor.DependencyCheckResult>)$continuation);
                if (v0 == var15_8) {
                    return var15_8;
                }
                ** GOTO lbl32
            }
            case 1: {
                availableSpace = $continuation.J$0;
                remoteArchiveLocation = (ShellArgument.RemotePath)$continuation.L$3;
                hostAccessor = (HighLevelHostAccessor)$continuation.L$2;
                progressIndicator = (ProgressIndicator)$continuation.L$1;
                this = (LocalFileRemoteHostDownloader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                it = (HighLevelHostAccessor.DependencyCheckResult)v0;
                $i$a$-let-LocalFileRemoteHostDownloader$downloadArchiveOnRemote$2 = false;
                if (!it.isDependencyPresent()) {
                    throw new IllegalStateException(("Cannot unarchive IDE on the remote host: " + it.getErrorMessage()).toString());
                }
                localArchiveSize = Files.size(this.localArchivePath);
                if (availableSpace <= (long)4 * localArchiveSize) {
                    throw new IllegalStateException("Not enough space to upload IDE backend".toString());
                }
                uploadProgressIndicator = new TransferProgressAdapter(progressIndicator, localArchiveSize);
                retryCount = 3;
                i = 1;
                while (true) {
                    progressIndicator.checkCanceled();
                    $continuation.L$0 = this;
                    $continuation.L$1 = progressIndicator;
                    $continuation.L$2 = hostAccessor;
                    $continuation.L$3 = remoteArchiveLocation;
                    $continuation.L$4 = uploadProgressIndicator;
                    $continuation.I$0 = retryCount;
                    $continuation.I$1 = ++i;
                    $continuation.label = 2;
                    v1 = LocalFileRemoteHostDownloader.downloadArchiveOnRemote$downloadOrException(hostAccessor, this, remoteArchiveLocation, uploadProgressIndicator, (Continuation<? super Throwable>)$continuation);
                    if (v1 == var15_8) {
                        return var15_8;
                    }
                    ** GOTO lbl66
                    break;
                }
            }
            case 2: {
                i = $continuation.I$1;
                retryCount = $continuation.I$0;
                uploadProgressIndicator = (TransferProgressAdapter)$continuation.L$4;
                remoteArchiveLocation = (ShellArgument.RemotePath)$continuation.L$3;
                hostAccessor = (HighLevelHostAccessor)$continuation.L$2;
                progressIndicator = (ProgressIndicator)$continuation.L$1;
                this = (LocalFileRemoteHostDownloader)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl66:
                // 2 sources

                downloadException = (Throwable)v1;
                if (downloadException != null) {
                    if (downloadException instanceof ControlFlowException || Futures.isCancellation((Throwable)downloadException) || i == retryCount) {
                        throw downloadException;
                    }
                    RemoteCredentialsEx.INSTANCE.getLogger().info("Uploading IDE Backend on remote host failed. Attempt " + i + " of " + retryCount, downloadException);
                    if (i != retryCount) ** continue;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public String toString() {
        return "UploadDownloader(" + this.localArchivePath + ")";
    }

    /*
     * Unable to fully structure code
     */
    private static final Object downloadArchiveOnRemote$downloadOrException(HighLevelHostAccessor var0, LocalFileRemoteHostDownloader var1_1, ShellArgument.RemotePath var2_2, TransferProgressAdapter var3_3, Continuation<? super Throwable> $completion) {
        if (!($completion instanceof downloadArchiveOnRemote.downloadOrException.1)) ** GOTO lbl-1000
        var8_5 = $completion;
        if ((var8_5.label & -2147483648) != 0) {
            var8_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LocalFileRemoteHostDownloader.access$downloadArchiveOnRemote$downloadOrException(null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = $hostAccessor.getFileAccessor().uploadFile(this$0.localArchivePath, $remoteArchiveLocation.getRawValue$intellij_gateway_core(), (TransferProgressTracker)uploadProgressIndicator, (Continuation<? super Unit>)$continuation);
                ** if (v0 != var9_7) goto lbl18
lbl17:
                // 1 sources

                return var9_7;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    var5_8 = null;
                }
                catch (Throwable e) {
                    var5_8 = e;
                }
                return var5_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$downloadArchiveOnRemote$downloadOrException(HighLevelHostAccessor $hostAccessor, LocalFileRemoteHostDownloader this$0, ShellArgument.RemotePath $remoteArchiveLocation, TransferProgressAdapter uploadProgressIndicator, Continuation $completion) {
        return LocalFileRemoteHostDownloader.downloadArchiveOnRemote$downloadOrException($hostAccessor, this$0, $remoteArchiveLocation, uploadProgressIndicator, (Continuation<? super Throwable>)$completion);
    }
}

