/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.features.shared.services;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "deserializeNode", "Lcom/fasterxml/jackson/databind/JsonNode;", "jsonString", "", "jsonFile", "Ljava/io/File;", "Companion", "intellij.rider.plugins.efCore"})
@SourceDebugExtension(value={"SMAP\nJsonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,49:1\n15#2:50\n*S KotlinDebug\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer\n*L\n26#1:50\n*E\n"})
public final class JsonSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    private static final ObjectMapper json;

    public JsonSerializer() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JsonSerializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Nullable
    public final JsonNode deserializeNode(@NotNull String jsonString) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        try {
            jsonNode = json.readTree(jsonString);
        }
        catch (JacksonException e) {
            String message = "Input JSON is invalid";
            this.logger.error(message, (Throwable)e);
            jsonNode = null;
        }
        return jsonNode;
    }

    @Nullable
    public final JsonNode deserializeNode(@NotNull File jsonFile) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        try {
            jsonNode = json.readTree(jsonFile);
        }
        catch (JacksonException e) {
            String message = "Input JSON file '" + jsonFile.getAbsolutePath() + "' is invalid";
            this.logger.error(message, (Throwable)e);
            jsonNode = null;
        }
        return jsonNode;
    }

    static {
        JsonParser.Feature[] featureArray = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS};
        ObjectMapper objectMapper = ExtensionsKt.jacksonObjectMapper().enable(featureArray);
        featureArray = new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES};
        ObjectMapper objectMapper2 = objectMapper.enable(featureArray);
        featureArray = new JsonParser.Feature[]{JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature()};
        json = objectMapper2.enable(featureArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer$Companion;", "", "<init>", "()V", "json", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nJsonSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,49:1\n40#2,3:50\n*S KotlinDebug\n*F\n+ 1 JsonSerializer.kt\ncom/jetbrains/rider/plugins/efcore/features/shared/services/JsonSerializer$Companion\n*L\n23#1:50,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JsonSerializer getInstance() {
            boolean $i$f$service = false;
            Class<JsonSerializer> serviceClass$iv = JsonSerializer.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (JsonSerializer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

