/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.cli.execution;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.efcore.cli.execution.CliCommandExecutor;
import com.jetbrains.rider.plugins.efcore.cli.execution.SilentCommandExecutor;
import com.jetbrains.rider.plugins.efcore.cli.execution.TerminalCommandExecutor;
import com.jetbrains.rider.plugins.efcore.settings.EfCoreUiSettingsStateService;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/efcore/cli/execution/PreferredCommandExecutorProvider;", "", "intellijProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "settingsStateService", "Lcom/jetbrains/rider/plugins/efcore/settings/EfCoreUiSettingsStateService;", "getSettingsStateService", "()Lcom/jetbrains/rider/plugins/efcore/settings/EfCoreUiSettingsStateService;", "settingsStateService$delegate", "Lkotlin/Lazy;", "getExecutor", "Lcom/jetbrains/rider/plugins/efcore/cli/execution/CliCommandExecutor;", "Companion", "intellij.rider.plugins.efCore"})
public final class PreferredCommandExecutorProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project intellijProject;
    @NotNull
    private final Lazy settingsStateService$delegate;

    public PreferredCommandExecutorProvider(@NotNull Project intellijProject) {
        Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
        this.intellijProject = intellijProject;
        this.settingsStateService$delegate = LazyKt.lazy(PreferredCommandExecutorProvider::settingsStateService_delegate$lambda$0);
    }

    private final EfCoreUiSettingsStateService getSettingsStateService() {
        Lazy lazy = this.settingsStateService$delegate;
        return (EfCoreUiSettingsStateService)lazy.getValue();
    }

    @NotNull
    public final CliCommandExecutor getExecutor() {
        CliCommandExecutor cliCommandExecutor;
        boolean bl = this.getSettingsStateService().getUseTerminalExecution();
        if (bl) {
            cliCommandExecutor = new TerminalCommandExecutor(this.intellijProject);
        } else if (!bl) {
            cliCommandExecutor = new SilentCommandExecutor(this.intellijProject);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return cliCommandExecutor;
    }

    private static final EfCoreUiSettingsStateService settingsStateService_delegate$lambda$0() {
        return EfCoreUiSettingsStateService.Companion.getInstance();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/plugins/efcore/cli/execution/PreferredCommandExecutorProvider$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/efcore/cli/execution/PreferredCommandExecutorProvider;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.efCore"})
    @SourceDebugExtension(value={"SMAP\nPreferredCommandExecutorProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreferredCommandExecutorProvider.kt\ncom/jetbrains/rider/plugins/efcore/cli/execution/PreferredCommandExecutorProvider$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,21:1\n31#2,2:22\n*S KotlinDebug\n*F\n+ 1 PreferredCommandExecutorProvider.kt\ncom/jetbrains/rider/plugins/efcore/cli/execution/PreferredCommandExecutorProvider$Companion\n*L\n11#1:22,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PreferredCommandExecutorProvider getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PreferredCommandExecutorProvider> serviceClass$iv = PreferredCommandExecutorProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PreferredCommandExecutorProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

