/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.efcore.cli.api;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.efcore.cli.api.DotnetCliCommandBuilder;
import com.jetbrains.rider.plugins.efcore.cli.execution.CliCommand;
import com.jetbrains.rider.plugins.efcore.cli.execution.CliCommandPresentationInfo;
import com.jetbrains.rider.plugins.efcore.cli.execution.KnownEfCommands;
import com.jetbrains.rider.plugins.efcore.features.shared.dialog.DialogCommonOptions;
import com.jetbrains.rider.plugins.efcore.rd.DbContextInfo;
import com.jetbrains.rider.plugins.efcore.rd.TargetFrameworkId;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLineKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/efcore/cli/api/EfCoreCliCommandBuilder;", "Lcom/jetbrains/rider/plugins/efcore/cli/api/DotnetCliCommandBuilder;", "intellijProject", "Lcom/intellij/openapi/project/Project;", "baseCommand", "", "commonOptions", "Lcom/jetbrains/rider/plugins/efcore/features/shared/dialog/DialogCommonOptions;", "presentation", "Lcom/jetbrains/rider/plugins/efcore/cli/execution/CliCommandPresentationInfo;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/jetbrains/rider/plugins/efcore/features/shared/dialog/DialogCommonOptions;Lcom/jetbrains/rider/plugins/efcore/cli/execution/CliCommandPresentationInfo;)V", "build", "Lcom/jetbrains/rider/plugins/efcore/cli/execution/CliCommand;", "makeRelativeProjectPath", "projectDirectory", "intellij.rider.plugins.efCore"})
public final class EfCoreCliCommandBuilder
extends DotnetCliCommandBuilder {
    @NotNull
    private final DialogCommonOptions commonOptions;

    public EfCoreCliCommandBuilder(@NotNull Project intellijProject, @NotNull String baseCommand, @NotNull DialogCommonOptions commonOptions, @NotNull CliCommandPresentationInfo presentation) {
        Intrinsics.checkNotNullParameter((Object)intellijProject, (String)"intellijProject");
        Intrinsics.checkNotNullParameter((Object)baseCommand, (String)"baseCommand");
        Intrinsics.checkNotNullParameter((Object)commonOptions, (String)"commonOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        String[] stringArray = new String[]{KnownEfCommands.INSTANCE.getEf(), baseCommand};
        super(presentation, intellijProject, stringArray);
        this.commonOptions = commonOptions;
        this.addNamed("--project", this.makeRelativeProjectPath(this.commonOptions.getMigrationsProject().getFullPath()));
        this.addNamed("--startup-project", this.makeRelativeProjectPath(this.commonOptions.getStartupProject().getFullPath()));
        DbContextInfo dbContextInfo = this.commonOptions.getDbContext();
        this.addNamedNullable("--context", dbContextInfo != null ? dbContextInfo.getFullName() : null);
        this.addNamed("--configuration", this.commonOptions.getBuildConfiguration());
        TargetFrameworkId targetFrameworkId = this.commonOptions.getTargetFramework();
        this.addNamedNullable("--framework", targetFrameworkId != null ? targetFrameworkId.getPresentableName() : null);
        this.addIf("--no-build", this.commonOptions.getNoBuild());
        this.addIf("--verbose", this.commonOptions.getEnableDiagnosticLogging());
    }

    @Override
    @NotNull
    public CliCommand build() {
        CliCommand command = super.build();
        GeneralCommandLine commandLine = command.getCommandLine();
        if (((CharSequence)this.commonOptions.getAdditionalArguments()).length() > 0) {
            this.add("--");
            commandLine = FormatPreservingCommandLineKt.withRawParameters((GeneralCommandLine)commandLine, (String)this.commonOptions.getAdditionalArguments());
        }
        return new CliCommand(command.getDotnetPath(), commandLine, command.getPresentationInfo());
    }

    private final String makeRelativeProjectPath(String projectDirectory) {
        Path base = Paths.get(this.getSolutionDirectory(), new String[0]);
        Path absolute = Paths.get(projectDirectory, new String[0]);
        Path relative = base.relativize(absolute);
        return ((Object)relative).toString();
    }
}

