/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.views;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.jetbrains.dpa.views.CustomEditorHighlighter;
import com.jetbrains.dpa.views.IssueDetailsViewControl;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rider.model.BeSqlIssueDetails;
import com.jetbrains.rider.model.SqlIssueDetailsData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/dpa/views/SqlIssueDetailsViewControl;", "Lcom/jetbrains/dpa/views/IssueDetailsViewControl;", "Lcom/jetbrains/rider/model/BeSqlIssueDetails;", "Lcom/jetbrains/rider/model/SqlIssueDetailsData;", "<init>", "()V", "getCustomIssueParagraph", "", "data", "sqlFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "addCustomIssueHighlightings", "", "highlighter", "Lcom/jetbrains/dpa/views/CustomEditorHighlighter;", "offset", "", "intellij.rider.plugins.dpa"})
public final class SqlIssueDetailsViewControl
extends IssueDetailsViewControl<BeSqlIssueDetails, SqlIssueDetailsData> {
    @NotNull
    private final FileType sqlFileType;

    public SqlIssueDetailsViewControl() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension("sql");
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        this.sqlFileType = fileType;
    }

    @Override
    @NotNull
    public String getCustomIssueParagraph(@NotNull SqlIssueDetailsData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return data.getCommandText() + data.getConnectionString() + "\n\n";
    }

    @Override
    public void addCustomIssueHighlightings(@NotNull SqlIssueDetailsData data, @NotNull CustomEditorHighlighter highlighter, int offset) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (!StringsKt.isBlank((CharSequence)data.getCommandText()) && this.sqlFileType != UnknownFileType.INSTANCE) {
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((FileType)this.sqlFileType, (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)ProjectUtilKt.toProject((RdProjectId)data.getProjectId()));
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
            EditorHighlighter editorHighlighter2 = editorHighlighter;
            editorHighlighter2.setText((CharSequence)data.getCommandText());
            highlighter.append(editorHighlighter2.createIterator(0), offset);
        }
    }
}

