/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view.overlays;

import com.intellij.ui.JBColor;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.Overlay;
import com.jetbrains.dpa.monitoring.sessions.BaseChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.rider.model.MessageCheckDelay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00020\u0001:\u0001\u000eB\u0017\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/dpa/monitoring/view/overlays/UiFreezeOverlay;", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "", "", "sessionGetter", "Lkotlin/Function0;", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "Companion", "intellij.rider.plugins.dpa"})
public final class UiFreezeOverlay
extends Overlay<LineChart<Long, Double, ?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<ChartSession> sessionGetter;

    public UiFreezeOverlay(@NotNull Function0<ChartSession> sessionGetter) {
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        this.sessionGetter = sessionGetter;
    }

    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ChartSession chartSession = (ChartSession)this.sessionGetter.invoke();
        if (chartSession == null) {
            return;
        }
        ChartSession session = chartSession;
        if (session.getCachedData().isEmpty()) {
            return;
        }
        if (session.getMessageCheckDelayData().isEmpty()) {
            return;
        }
        long qpcDuration = ULong.constructor-impl((long)(((BaseChartData)CollectionsKt.last(session.getCachedData())).getQpcTimeStamp-s-VKNKU() - ((BaseChartData)CollectionsKt.first(session.getCachedData())).getQpcTimeStamp-s-VKNKU()));
        if (qpcDuration == 0L) {
            return;
        }
        long startQpcTimestamp = ((BaseChartData)CollectionsKt.first(session.getCachedData())).getQpcTimeStamp-s-VKNKU();
        MinMax minMax = ((LineChart)this.getChart()).findMinMax();
        if (!minMax.isInitialized()) {
            return;
        }
        int offsetX = (int)((LineChart)this.getChart()).findLocation((MinMax)minMax, (Coordinates)new Coordinates((Number)((Number)Long.valueOf((long)((BaseChartData)CollectionsKt.first(session.getCachedData())).getTimeStamp())), (Number)((Number)Double.valueOf((double)0.0)))).x;
        int width = ((LineChart)this.getChart()).getWidth() - offsetX - ((LineChart)this.getChart()).getMargins().right;
        double qpcMultiplier = (double)width / UnsignedKt.ulongToDouble((long)qpcDuration);
        double msMultiplier = (double)width / 60000.0;
        g.setPaint(Companion.getUiFreezeColor());
        Iterator iterator = session.getMessageCheckDelayData().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            MessageCheckDelay messageCheckDelay = (MessageCheckDelay)e;
            int rightX = UiFreezeOverlay.paintComponent$qpcTimestampToX(startQpcTimestamp, qpcMultiplier, messageCheckDelay.getQpcTimestamp-s-VKNKU());
            int leftX = rightX - (int)((double)messageCheckDelay.getDelayTimeMs() * msMultiplier);
            if (rightX < 0 || leftX > width) continue;
            if (leftX < 0) {
                leftX = 0;
            }
            if (rightX > width) {
                rightX = width;
            }
            UiFreezeOverlay.paintComponent$drawBar(g, offsetX, this, leftX, rightX);
        }
    }

    private static final int paintComponent$qpcTimestampToX(long startQpcTimestamp, double qpcMultiplier, long qpcTimestamp) {
        return (int)(UnsignedKt.ulongToDouble((long)ULong.constructor-impl((long)(qpcTimestamp - startQpcTimestamp))) * qpcMultiplier);
    }

    private static final void paintComponent$drawBar(Graphics2D $g, int offsetX, UiFreezeOverlay this$0, int x1, int x2) {
        $g.fillRect(offsetX + x1, 1 + ((LineChart)this$0.getChart()).getHeight() - ((LineChart)this$0.getChart()).getMargins().bottom + 5, x2 - x1, 5);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/dpa/monitoring/view/overlays/UiFreezeOverlay$Companion;", "", "<init>", "()V", "uiFreezeColor", "Ljava/awt/Color;", "getUiFreezeColor", "()Ljava/awt/Color;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getUiFreezeColor() {
            JBColor jBColor = JBColor.BLUE;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLUE");
            return (Color)jBColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

