/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view.overlays;

import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.Overlay;
import com.intellij.ui.charts.XYLineDataset;
import com.jetbrains.dpa.monitoring.view.overlays.HelpersKt;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/dpa/monitoring/view/overlays/TitleOverlay;", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "title", "", "label", "xyLineDataset", "Lcom/intellij/ui/charts/XYLineDataset;", "", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/ui/charts/XYLineDataset;)V", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "intellij.rider.plugins.dpa"})
public final class TitleOverlay
extends Overlay<LineChart<?, ?, ?>> {
    @NotNull
    private final String title;
    @NotNull
    private final String label;
    @NotNull
    private final XYLineDataset<Long, Double> xyLineDataset;

    public TitleOverlay(@NotNull String title, @NotNull String label, @NotNull XYLineDataset<Long, Double> xyLineDataset) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter(xyLineDataset, (String)"xyLineDataset");
        this.title = title;
        this.label = label;
        this.xyLineDataset = xyLineDataset;
    }

    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(HelpersKt.getLabelColor());
        g.drawString(this.title, ((LineChart)this.getChart()).getMargins().left, 20);
        Coordinates coordinates = (Coordinates)CollectionsKt.lastOrNull((Iterable)this.xyLineDataset.getData());
        double value = coordinates != null ? coordinates.getY().doubleValue() : 0.0;
        String valueLabel = HelpersKt.createValueLabel(value, this.label);
        int valueLabelWidth = g.getFontMetrics().stringWidth(valueLabel);
        g.drawString(valueLabel, ((LineChart)this.getChart()).getWidth() - ((LineChart)this.getChart()).getMargins().left - valueLabelWidth, 20);
    }
}

