/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view.overlays;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.Overlay;
import com.jetbrains.dpa.monitoring.sessions.BaseChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.view.overlays.HelpersKt;
import com.jetbrains.dpa.monitoring.view.overlays.PanelValueData;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00020\u0001B\u0017\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/dpa/monitoring/view/overlays/PanelOverlay;", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "", "", "sessionGetter", "Lkotlin/Function0;", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getValues", "", "Lcom/jetbrains/dpa/monitoring/view/overlays/PanelValueData;", "g", "Ljava/awt/Graphics2D;", "value", "Lcom/jetbrains/dpa/monitoring/sessions/ChartData;", "(Ljava/awt/Graphics2D;Lcom/jetbrains/dpa/monitoring/sessions/ChartData;)[Lcom/jetbrains/dpa/monitoring/view/overlays/PanelValueData;", "paintComponent", "", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nPanelOverlay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PanelOverlay.kt\ncom/jetbrains/dpa/monitoring/view/overlays/PanelOverlay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n360#2,7:91\n1#3:98\n*S KotlinDebug\n*F\n+ 1 PanelOverlay.kt\ncom/jetbrains/dpa/monitoring/view/overlays/PanelOverlay\n*L\n45#1:91,7\n*E\n"})
public abstract class PanelOverlay
extends Overlay<LineChart<Long, Double, ?>> {
    @NotNull
    private final Function0<ChartSession> sessionGetter;

    public PanelOverlay(@NotNull Function0<ChartSession> sessionGetter) {
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        this.sessionGetter = sessionGetter;
    }

    @NotNull
    public abstract PanelValueData[] getValues(@NotNull Graphics2D var1, @NotNull ChartData var2);

    public void paintComponent(@NotNull Graphics2D g) {
        int it32;
        int valueIndex;
        Object[] it;
        Ref.IntRef panelX;
        int timestampX;
        Point location;
        ChartSession session;
        block21: {
            int n;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            ChartSession chartSession = (ChartSession)this.sessionGetter.invoke();
            if (chartSession == null) {
                return;
            }
            session = chartSession;
            if (session.getCachedData().isEmpty()) {
                return;
            }
            Point point = this.getMouseLocation();
            if (point == null) {
                return;
            }
            location = point;
            MinMax minMax = ((LineChart)this.getChart()).findMinMax();
            if (!minMax.isInitialized()) {
                return;
            }
            Long l = HelpersKt.getXByLocation(location, (GridChartWrapper<Long, Double>)((GridChartWrapper)this.getChart()));
            if (l == null) {
                return;
            }
            long timestamp = l;
            timestampX = (int)((LineChart)this.getChart()).findLocation((MinMax)minMax, (Coordinates)new Coordinates((Number)((Number)Long.valueOf((long)timestamp)), (Number)((Number)Double.valueOf((double)0.0)))).x;
            g.setColor((Color)JBColor.GRAY);
            g.drawLine(timestampX, ((LineChart)this.getChart()).getMargins().top, timestampX, ((LineChart)this.getChart()).getHeight() - ((LineChart)this.getChart()).getMargins().bottom);
            panelX = new Ref.IntRef();
            panelX.element = location.x + 20;
            List<BaseChartData> $this$indexOfFirst$iv = session.getCachedData();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<BaseChartData> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                Object[] item$iv;
                it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getTimeStamp() == timestamp) {
                    n = index$iv;
                    break block21;
                }
                ++index$iv;
            }
            n = valueIndex = -1;
        }
        if (valueIndex == -1) {
            return;
        }
        Object[] values = this.getValues(g, session.getChartData(valueIndex));
        int textHeight = g.getFontMetrics().getHeight();
        int textAscent = g.getFontMetrics().getAscent();
        int panelHeight = 4 + (textHeight + 4) * values.length;
        it = values;
        int n = 20;
        if (it.length == 0) {
            throw new NoSuchElementException();
        }
        PanelValueData it22 = it[0];
        int n2 = 0;
        int it22 = it22.getLabelTextWidth();
        n2 = 1;
        int n3 = ArraysKt.getLastIndex((Object[])it);
        if (n2 <= n3) {
            while (true) {
                Object it32 = it[n2];
                boolean bl = false;
                it32 = ((PanelValueData)it32).getLabelTextWidth();
                if (it22 < it32) {
                    it22 = it32;
                }
                if (n2 == n3) break;
                ++n2;
            }
        }
        int n4 = it22;
        it = values;
        n = n + n4 + 4;
        if (it.length == 0) {
            throw new NoSuchElementException();
        }
        Object it42 = it[0];
        boolean bl = false;
        int it42 = ((PanelValueData)it42).getValueTextWidth();
        int n5 = 1;
        n3 = ArraysKt.getLastIndex((Object[])it);
        if (n5 <= n3) {
            while (true) {
                Object it5 = it[n5];
                $i$a$-maxOf-PanelOverlay$paintComponent$panelWidth$2 = false;
                it32 = ((PanelValueData)it5).getValueTextWidth();
                if (it42 < it32) {
                    it42 = it32;
                }
                if (n5 == n3) break;
                ++n5;
            }
        }
        n4 = it42;
        int panelWidth = n + n4 + 10;
        int panelY = location.y;
        if (panelX.element + panelWidth > ((LineChart)this.getChart()).getWidth()) {
            panelX.element = timestampX - panelWidth - 4;
        }
        if (panelX.element < 0) {
            panelX.element = 0;
        }
        if (panelY + panelHeight > ((LineChart)this.getChart()).getHeight()) {
            panelY = ((LineChart)this.getChart()).getHeight() - panelHeight;
        }
        if (panelY < 0) {
            panelY = 0;
        }
        Ref.IntRef offsetY = new Ref.IntRef();
        offsetY.element = panelY + 4 + textAscent;
        g.setColor(ColorUtil.withAlpha((Color)JBColor.PanelBackground, (double)0.5));
        g.fillRect(panelX.element, panelY, panelWidth, panelHeight);
        for (Object v : values) {
            PanelOverlay.paintComponent$drawValue(g, panelX, offsetY, textAscent, textHeight, panelWidth, (PanelValueData)v);
            offsetY.element += textHeight + 4;
        }
    }

    private static final void paintComponent$drawValue(Graphics2D $g, Ref.IntRef panelX, Ref.IntRef offsetY, int textAscent, int textHeight, int panelWidth, PanelValueData data) {
        $g.setColor(data.getColor());
        $g.fillOval(panelX.element + 5, offsetY.element - 5 - textAscent + textHeight / 2, 10, 10);
        $g.setColor(HelpersKt.getLabelColor());
        $g.drawString(data.getLabelText(), panelX.element + 10 + 8, offsetY.element);
        $g.drawString(data.getValueText(), panelX.element + panelWidth - data.getValueTextWidth() - 10, offsetY.element);
    }
}

