/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view.overlays;

import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.Overlay;
import com.jetbrains.dpa.monitoring.sessions.BaseChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.view.overlays.ExceptionsOverlayKt;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00020\u0001B\u0017\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/view/overlays/ExceptionsOverlay;", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "", "", "sessionGetter", "Lkotlin/Function0;", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "intellij.rider.plugins.dpa"})
public final class ExceptionsOverlay
extends Overlay<LineChart<Long, Double, ?>> {
    @NotNull
    private final Function0<ChartSession> sessionGetter;

    public ExceptionsOverlay(@NotNull Function0<ChartSession> sessionGetter) {
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        this.sessionGetter = sessionGetter;
    }

    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ChartSession chartSession = (ChartSession)this.sessionGetter.invoke();
        if (chartSession == null) {
            return;
        }
        ChartSession session = chartSession;
        if (session.getCachedData().isEmpty()) {
            return;
        }
        long duration = ((BaseChartData)CollectionsKt.last(session.getCachedData())).getTimeStamp() - ((BaseChartData)CollectionsKt.first(session.getCachedData())).getTimeStamp();
        if (duration <= 0L) {
            return;
        }
        long startTimestamp = ((BaseChartData)CollectionsKt.first(session.getCachedData())).getTimeStamp();
        MinMax minMax = ((LineChart)this.getChart()).findMinMax();
        if (!minMax.isInitialized()) {
            return;
        }
        int offsetX = (int)((LineChart)this.getChart()).findLocation((MinMax)minMax, (Coordinates)new Coordinates((Number)((Number)Long.valueOf((long)((BaseChartData)CollectionsKt.first(session.getCachedData())).getTimeStamp())), (Number)((Number)Double.valueOf((double)0.0)))).x;
        int width = ((LineChart)this.getChart()).getWidth() - offsetX - ((LineChart)this.getChart()).getMargins().right;
        double multiplier = (double)width / (double)duration;
        g.setPaint(ExceptionsOverlayKt.getExceptionsColor());
        for (BaseChartData item : session.getCachedData()) {
            if (item.getExceptionCount-s-VKNKU() == 0L) continue;
            int x = ExceptionsOverlay.paintComponent$timestampToX(startTimestamp, multiplier, item.getTimeStamp());
            double percent = Math.min(MathKt.log((double)UnsignedKt.ulongToDouble((long)ULong.constructor-impl((long)(item.getExceptionCount-s-VKNKU() + 1L))), (double)2.0) / (double)10, 1.0);
            ExceptionsOverlay.paintComponent$drawBar(g, offsetX, this, x, x + (int)Math.max(percent * multiplier, 1.0));
        }
    }

    private static final int paintComponent$timestampToX(long startTimestamp, double multiplier, long timestamp) {
        return (int)((double)(timestamp - startTimestamp) * multiplier);
    }

    private static final void paintComponent$drawBar(Graphics2D $g, int offsetX, ExceptionsOverlay this$0, int x1, int x2) {
        $g.fillRect(offsetX + x1, 1 + ((LineChart)this$0.getChart()).getHeight() - ((LineChart)this$0.getChart()).getMargins().bottom, x2 - x1, 10);
    }
}

