/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.util.ui.JBUI;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.MonitoringUsagesCollector;
import com.jetbrains.dpa.monitoring.actions.DataKeysKt;
import com.jetbrains.dpa.monitoring.model.CommonModel;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.dpa.monitoring.view.ChartPanel;
import com.jetbrains.dpa.monitoring.view.CommonPanel;
import com.jetbrains.dpa.monitoring.view.CounterPanel;
import com.jetbrains.dpa.monitoring.view.MonitoringTabsImpl;
import com.jetbrains.dpa.monitoring.view.ProcessDashboardPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010 \u001a\u00020!2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "session", "Lcom/jetbrains/dpa/monitoring/sessions/Session;", "getSession", "()Lcom/jetbrains/dpa/monitoring/sessions/Session;", "setSession", "(Lcom/jetbrains/dpa/monitoring/sessions/Session;)V", "chartPanel", "Lcom/jetbrains/dpa/monitoring/view/ChartPanel;", "counterPanel", "Lcom/jetbrains/dpa/monitoring/view/CounterPanel;", "environmentPanel", "Lcom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel;", "chartCommonPanel", "Lcom/jetbrains/dpa/monitoring/view/CommonPanel;", "counterCommonPanel", "environmentCommonPanel", "tabs", "Lcom/jetbrains/dpa/monitoring/view/MonitoringTabsImpl;", "actions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "chartTab", "Lcom/intellij/ui/tabs/TabInfo;", "counterTab", "environmentTab", "bind", "", "commonModel", "Lcom/jetbrains/dpa/monitoring/model/CommonModel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "updateActions", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nSessionToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionToolWindowPanel.kt\ncom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n13#2:125\n15#3:126\n*S KotlinDebug\n*F\n+ 1 SessionToolWindowPanel.kt\ncom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel\n*L\n27#1:125\n27#1:126\n*E\n"})
public final class SessionToolWindowPanel
extends SimpleToolWindowPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Session session;
    @NotNull
    private final ChartPanel chartPanel;
    @NotNull
    private final CounterPanel counterPanel;
    @NotNull
    private final ProcessDashboardPanel environmentPanel;
    @NotNull
    private final CommonPanel chartCommonPanel;
    @NotNull
    private final CommonPanel counterCommonPanel;
    @NotNull
    private final CommonPanel environmentCommonPanel;
    @NotNull
    private final MonitoringTabsImpl tabs;
    @NotNull
    private final ActionGroup actions;
    @NotNull
    private final TabInfo chartTab;
    @NotNull
    private final TabInfo counterTab;
    @NotNull
    private final TabInfo environmentTab;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public SessionToolWindowPanel(@NotNull Project project, @NotNull Disposable parentDisposable) {
        void $this$_init__u24lambda_u242;
        TabInfo $this$_init__u24lambda_u241;
        TabInfo $this$_init__u24lambda_u240;
        TabInfo tabInfo;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(true);
        this.chartPanel = new ChartPanel();
        this.counterPanel = new CounterPanel();
        this.environmentPanel = new ProcessDashboardPanel();
        this.chartCommonPanel = new CommonPanel((JComponent)((Object)this.chartPanel));
        this.counterCommonPanel = new CommonPanel((JComponent)((Object)this.counterPanel));
        this.environmentCommonPanel = new CommonPanel((JComponent)((Object)this.environmentPanel));
        this.tabs = new MonitoringTabsImpl(project, parentDisposable);
        AnAction anAction = ActionManager.getInstance().getAction("MonitoringTool.ToolWindow.Actions");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        this.actions = (ActionGroup)anAction;
        this.setBorder((Border)JBUI.Borders.empty());
        TabInfo tabInfo2 = tabInfo = new TabInfo((JComponent)((Object)this.chartCommonPanel));
        MonitoringTabsImpl monitoringTabsImpl = this.tabs;
        SessionToolWindowPanel sessionToolWindowPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setText(MonitoringToolBundle.Companion.message("toolwindow.tab.chart", new Object[0]));
        $this$_init__u24lambda_u240.setActions(this.actions, null);
        $this$_init__u24lambda_u240.setActionsContextComponent((JComponent)((Object)this));
        Unit unit = Unit.INSTANCE;
        sessionToolWindowPanel.chartTab = monitoringTabsImpl.addTab(tabInfo);
        $this$_init__u24lambda_u240 = tabInfo = new TabInfo((JComponent)((Object)this.counterCommonPanel));
        monitoringTabsImpl = this.tabs;
        sessionToolWindowPanel = this;
        boolean bl2 = false;
        $this$_init__u24lambda_u241.setText(MonitoringToolBundle.Companion.message("toolwindow.tab.counters", new Object[0]));
        $this$_init__u24lambda_u241.setHidden(true);
        $this$_init__u24lambda_u241.setActions(this.actions, null);
        $this$_init__u24lambda_u241.setActionsContextComponent((JComponent)((Object)this));
        unit = Unit.INSTANCE;
        sessionToolWindowPanel.counterTab = monitoringTabsImpl.addTab(tabInfo);
        $this$_init__u24lambda_u241 = tabInfo = new TabInfo((JComponent)((Object)this.environmentCommonPanel));
        monitoringTabsImpl = this.tabs;
        sessionToolWindowPanel = this;
        boolean bl3 = false;
        $this$_init__u24lambda_u242.setText(MonitoringToolBundle.Companion.message("toolwindow.tab.environment", new Object[0]));
        $this$_init__u24lambda_u242.setActions(this.actions, null);
        $this$_init__u24lambda_u242.setActionsContextComponent((JComponent)((Object)this));
        unit = Unit.INSTANCE;
        sessionToolWindowPanel.environmentTab = monitoringTabsImpl.addTab(tabInfo);
        this.setContent((JComponent)((Object)this.tabs));
        this.tabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                MonitoringUsagesCollector.ContentType contentType;
                if (newSelection == null) {
                    return;
                }
                TabInfo tabInfo = newSelection;
                if (Intrinsics.areEqual((Object)tabInfo, (Object)chartTab)) {
                    contentType = MonitoringUsagesCollector.ContentType.Chart;
                } else if (Intrinsics.areEqual((Object)tabInfo, (Object)counterTab)) {
                    contentType = MonitoringUsagesCollector.ContentType.Counters;
                } else if (Intrinsics.areEqual((Object)tabInfo, (Object)environmentTab)) {
                    contentType = MonitoringUsagesCollector.ContentType.Environment;
                } else {
                    throw new Exception("Unknown monitoring tab");
                }
                MonitoringUsagesCollector.ContentType contentType2 = contentType;
                MonitoringUsagesCollector.TAB_ACTIVATED.log((Object)contentType2);
            }
        });
    }

    @Nullable
    public final Session getSession() {
        return this.session;
    }

    public final void setSession(@Nullable Session session) {
        this.session = session;
    }

    public final void bind(@NotNull CommonModel commonModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)commonModel, (String)"commonModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.chartCommonPanel.bind(commonModel, lifetime);
        this.counterCommonPanel.bind(commonModel, lifetime);
        this.environmentCommonPanel.bind(commonModel, lifetime);
    }

    public final void bind(@NotNull Session session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        logger.trace("bind pid:" + session.getPid());
        this.session = session;
        this.chartPanel.bind(session.getChartSession(), lifetime);
        this.counterPanel.bind(session.getCounterSession(), lifetime);
        session.getCounterSession().getHasData().advise(lifetime, arg_0 -> SessionToolWindowPanel.bind$lambda$3(this, arg_0));
        this.environmentPanel.bind(session, lifetime);
        session.getPerformanceProfilingSession().getOnStateChanged().advise(lifetime, arg_0 -> SessionToolWindowPanel.bind$lambda$4(this, arg_0));
        this.updateActions();
        lifetime.onTermination(() -> SessionToolWindowPanel.bind$lambda$5(session, this));
    }

    private final void updateActions() {
        block0: {
            TabInfo tabInfo;
            TabInfo tabInfo2 = this.tabs.getSelectedInfo();
            if (tabInfo2 == null) break block0;
            TabInfo $this$updateActions_u24lambda_u246 = tabInfo = tabInfo2;
            boolean bl = false;
            $this$updateActions_u24lambda_u246.setActions(this.actions, null);
            $this$updateActions_u24lambda_u246.setActionsContextComponent((JComponent)((Object)this));
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        Session session = this.session;
        sink.set(DataKeysKt.getSESSION_PROCESS_ID(), (Object)(session != null ? Integer.valueOf(session.getPid()) : null));
        Session session2 = this.session;
        sink.set(DataKeysKt.getSESSION_PERFORMANCE_PROFILING(), (Object)(session2 != null ? session2.getPerformanceProfilingSession() : null));
        Session session3 = this.session;
        sink.set(DataKeysKt.getSESSION_MEMORY_PROFILING(), (Object)(session3 != null ? session3.getMemoryProfilingSession() : null));
        Session session4 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_STACK_TRACE_COLLECTING_AVAILABLE(), (Object)(session4 != null ? Boolean.valueOf(session4.isStackTraceCollectingAvailable()) : null));
        Session session5 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_MEMORY_PROFILING_AVAILABLE(), (Object)(session5 != null ? Boolean.valueOf(session5.isMemoryProfilingAvailable()) : null));
        Session session6 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_SAMPLING_PROFILING_AVAILABLE(), (Object)(session6 != null ? Boolean.valueOf(session6.isSamplingProfilingAvailable()) : null));
        Session session7 = this.session;
        sink.set(DataKeysKt.getSESSION_IS_TIMELINE_PROFILING_AVAILABLE(), (Object)(session7 != null ? Boolean.valueOf(session7.isTimelineProfilingAvailable()) : null));
    }

    private static final Unit bind$lambda$3(SessionToolWindowPanel this$0, boolean hasData) {
        this$0.counterTab.setHidden(!hasData);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$4(SessionToolWindowPanel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateActions();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$5(Session $session, SessionToolWindowPanel this$0) {
        logger.trace("unbind pid:" + $session.getPid());
        this$0.session = null;
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionToolWindowPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SessionToolWindowPanel.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/view/SessionToolWindowPanel$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

