/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.InlineIconButton;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "<init>", "()V", "emptyPanel", "Ljavax/swing/JPanel;", "dataPanel", "Ljavax/swing/JComponent;", "setProcessInfo", "", "processInfo", "Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "bind", "session", "Lcom/jetbrains/dpa/monitoring/sessions/Session;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nProcessDashboardPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDashboardPanel.kt\ncom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n1#2:141\n13#3:142\n15#4:143\n*S KotlinDebug\n*F\n+ 1 ProcessDashboardPanel.kt\ncom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel\n*L\n35#1:142\n35#1:143\n*E\n"})
public final class ProcessDashboardPanel
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JPanel emptyPanel;
    @Nullable
    private JComponent dataPanel;
    @NotNull
    private static final Logger logger;

    public ProcessDashboardPanel() {
        JBPanelWithEmptyText jBPanelWithEmptyText = new JBPanelWithEmptyText().withEmptyText("No running process");
        Intrinsics.checkNotNullExpressionValue((Object)jBPanelWithEmptyText, (String)"withEmptyText(...)");
        this.emptyPanel = (JPanel)jBPanelWithEmptyText;
    }

    /*
     * WARNING - void declaration
     */
    private final void setProcessInfo(ProcessInfo processInfo) {
        TitledSeparator $this$setProcessInfo_u24lambda_u2423;
        Object architecture;
        Object[] $this$setProcessInfo_u24lambda_u2419_u24lambda_u2418;
        Object[] $this$setProcessInfo_u24lambda_u2419_u24lambda_u2416;
        JPanel $this$setProcessInfo_u24lambda_u2419;
        Container $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414;
        Object[] $this$setProcessInfo_u24lambda_u2415_u24lambda_u2412;
        JPanel $this$setProcessInfo_u24lambda_u2415;
        Object[] $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410;
        Object[] $this$setProcessInfo_u24lambda_u2411_u24lambda_u246;
        JPanel $this$setProcessInfo_u24lambda_u2411;
        Object[] $this$setProcessInfo_u24lambda_u245_u24lambda_u244;
        Object[] $this$setProcessInfo_u24lambda_u245_u24lambda_u242;
        JPanel $this$setProcessInfo_u24lambda_u245;
        JPanel jPanel;
        JPanel $this$setProcessInfo_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new VerticalLayout(4));
        boolean bl = false;
        $this$setProcessInfo_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        JPanel jPanel2 = jPanel;
        JPanel $this$setProcessInfo_u24lambda_u241 = $this$setProcessInfo_u24lambda_u240 = new JPanel((LayoutManager)new VerticalLayout(4));
        boolean bl2 = false;
        $this$setProcessInfo_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)10));
        JPanel topPanel = $this$setProcessInfo_u24lambda_u240;
        $this$setProcessInfo_u24lambda_u241 = $this$setProcessInfo_u24lambda_u240 = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        Container container = topPanel;
        boolean bl3 = false;
        $this$setProcessInfo_u24lambda_u245.setBorder((Border)JBUI.Borders.emptyTop((int)4));
        String processId = String.valueOf(processInfo.getProcessId());
        Object[] objectArray = new Object[]{processId};
        Object[] objectArray2 = objectArray = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.process.id", objectArray));
        Container container2 = $this$setProcessInfo_u24lambda_u245;
        boolean bl4 = false;
        $this$setProcessInfo_u24lambda_u245_u24lambda_u242.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        if (((CharSequence)processId).length() > 0) {
            Container container3 = $this$setProcessInfo_u24lambda_u245;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u245_u24lambda_u242 = objectArray = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            container2 = container3;
            boolean bl5 = false;
            $this$setProcessInfo_u24lambda_u245_u24lambda_u244.setFocusable(false);
            $this$setProcessInfo_u24lambda_u245_u24lambda_u244.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$5$lambda$4$lambda$3(processId, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)$this$setProcessInfo_u24lambda_u240, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u245 = $this$setProcessInfo_u24lambda_u240 = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = topPanel;
        boolean bl6 = false;
        String filename = processInfo.getFileName();
        objectArray = new Object[]{filename};
        $this$setProcessInfo_u24lambda_u245_u24lambda_u244 = objectArray = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.filename", objectArray));
        container2 = $this$setProcessInfo_u24lambda_u2411;
        boolean bl7 = false;
        $this$setProcessInfo_u24lambda_u2411_u24lambda_u246.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        if (((CharSequence)filename).length() > 0) {
            Object[] $this$setProcessInfo_u24lambda_u2411_u24lambda_u248;
            Container container4 = $this$setProcessInfo_u24lambda_u2411;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2411_u24lambda_u246 = objectArray = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            container2 = container4;
            boolean bl8 = false;
            $this$setProcessInfo_u24lambda_u2411_u24lambda_u248.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2411_u24lambda_u248.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$11$lambda$8$lambda$7(filename, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
            Container container5 = $this$setProcessInfo_u24lambda_u2411;
            Icon icon2 = AllIcons.General.OpenDisk;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"OpenDisk");
            $this$setProcessInfo_u24lambda_u2411_u24lambda_u248 = objectArray = new InlineIconButton(icon2, AllIcons.General.OpenDiskHover, null, null, null, 28, null);
            container2 = container5;
            boolean bl9 = false;
            $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$11$lambda$10$lambda$9(filename, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)container2, (Component)((Component)objectArray), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)$this$setProcessInfo_u24lambda_u240, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u2411 = $this$setProcessInfo_u24lambda_u240 = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = topPanel;
        boolean bl10 = false;
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        Object[] objectArray3 = processInfo.getStartTime().format(formatter);
        if (objectArray3 == null) {
            objectArray3 = "";
        }
        Object[] startTime = objectArray3;
        $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410 = new Object[]{startTime};
        $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410 = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.start.time", $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410));
        container2 = $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410;
        Container bl9 = $this$setProcessInfo_u24lambda_u2415;
        boolean bl11 = false;
        $this$setProcessInfo_u24lambda_u2415_u24lambda_u2412.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)bl9, (Component)((Component)$this$setProcessInfo_u24lambda_u2411_u24lambda_u2410), null, (int)2, null);
        if (((CharSequence)startTime).length() > 0) {
            Container container6 = $this$setProcessInfo_u24lambda_u2415;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2415_u24lambda_u2412 = $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410 = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            bl9 = container6;
            boolean bl12 = false;
            $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$15$lambda$14$lambda$13((String)startTime, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)bl9, (Component)((Component)$this$setProcessInfo_u24lambda_u2411_u24lambda_u2410), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)$this$setProcessInfo_u24lambda_u240, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u2415 = $this$setProcessInfo_u24lambda_u240 = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = topPanel;
        boolean bl13 = false;
        String commandLine = processInfo.getCommandLine();
        startTime = new Object[]{commandLine};
        $this$setProcessInfo_u24lambda_u2411_u24lambda_u2410 = startTime = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.command.line", startTime));
        $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414 = $this$setProcessInfo_u24lambda_u2419;
        boolean bl14 = false;
        $this$setProcessInfo_u24lambda_u2419_u24lambda_u2416.setCopyable(true);
        RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2415_u24lambda_u2414, (Component)((Component)startTime), null, (int)2, null);
        if (((CharSequence)commandLine).length() > 0) {
            Container container7 = $this$setProcessInfo_u24lambda_u2419;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2419_u24lambda_u2416 = startTime = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414 = container7;
            boolean bl15 = false;
            $this$setProcessInfo_u24lambda_u2419_u24lambda_u2418.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2419_u24lambda_u2418.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$19$lambda$18$lambda$17(commandLine, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2415_u24lambda_u2414, (Component)((Component)startTime), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)$this$setProcessInfo_u24lambda_u240, null, (int)2, null);
        $this$setProcessInfo_u24lambda_u2419 = $this$setProcessInfo_u24lambda_u240 = new JPanel((LayoutManager)new HorizontalLayout(10, 0, 2, null));
        container = topPanel;
        boolean bl162 = false;
        Object object = processInfo.getProcessArchitecture();
        if (object == null || (object = object.name()) == null) {
            object = "";
        }
        if (((CharSequence)(architecture = object)).length() > 0) {
            void $this$setProcessInfo_u24lambda_u2423_u24lambda_u2422;
            Object[] $this$setProcessInfo_u24lambda_u2423_u24lambda_u2420;
            startTime = new Object[]{architecture};
            $this$setProcessInfo_u24lambda_u2419_u24lambda_u2418 = startTime = new JBLabel(MonitoringToolBundle.Companion.message("dashboard.row.process.architecture", startTime));
            $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414 = (Container)$this$setProcessInfo_u24lambda_u2423;
            boolean bl17 = false;
            $this$setProcessInfo_u24lambda_u2423_u24lambda_u2420.setCopyable(true);
            RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2415_u24lambda_u2414, (Component)((Component)startTime), null, (int)2, null);
            Container container8 = (Container)$this$setProcessInfo_u24lambda_u2423;
            Icon icon = AllIcons.General.InlineCopyHover;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InlineCopyHover");
            $this$setProcessInfo_u24lambda_u2423_u24lambda_u2420 = startTime = new InlineIconButton(icon, AllIcons.General.InlineCopy, null, null, null, 28, null);
            $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414 = container8;
            boolean bl18 = false;
            $this$setProcessInfo_u24lambda_u2423_u24lambda_u2422.setFocusable(false);
            $this$setProcessInfo_u24lambda_u2423_u24lambda_u2422.setActionListener(arg_0 -> ProcessDashboardPanel.setProcessInfo$lambda$23$lambda$22$lambda$21((String)architecture, arg_0));
            RevertOnDisposeUtilKt.addComponent$default((Container)$this$setProcessInfo_u24lambda_u2415_u24lambda_u2414, (Component)((Component)startTime), null, (int)2, null);
        }
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)$this$setProcessInfo_u24lambda_u240, null, (int)2, null);
        RevertOnDisposeUtilKt.addComponent$default((Container)jPanel2, (Component)topPanel, null, (int)2, null);
        String[] environmentVariables = processInfo.getEnvironmentVariables();
        if (!(environmentVariables.length == 0)) {
            JPanel jPanel3;
            void $this$setProcessInfo_u24lambda_u2424;
            TitledSeparator bl162 = $this$setProcessInfo_u24lambda_u2423 = new TitledSeparator(MonitoringToolBundle.Companion.message("dashboard.row.environment.variables", new Object[0]));
            container = jPanel2;
            boolean bl19 = false;
            $this$setProcessInfo_u24lambda_u2424.setBorder((Border)JBUI.Borders.emptyTop((int)12));
            $this$setProcessInfo_u24lambda_u2424.setTitleFont($this$setProcessInfo_u24lambda_u2424.getTitleFont().deriveFont(1));
            RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)((Component)$this$setProcessInfo_u24lambda_u2423), null, (int)2, null);
            JPanel $this$setProcessInfo_u24lambda_u2425 = jPanel3 = new JPanel((LayoutManager)new VerticalLayout(4));
            boolean bl20 = false;
            $this$setProcessInfo_u24lambda_u2425.setBorder((Border)JBUI.Borders.empty((int)4, (int)2, (int)0, (int)10));
            JPanel environmentPanel = jPanel3;
            for (String envVar : environmentVariables) {
                void $this$setProcessInfo_u24lambda_u2426;
                objectArray2 = new JBLabel(envVar);
                $this$setProcessInfo_u24lambda_u2415_u24lambda_u2414 = objectArray2;
                container = environmentPanel;
                boolean bl21 = false;
                $this$setProcessInfo_u24lambda_u2426.setCopyable(true);
                RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)((Component)objectArray2), null, (int)2, null);
            }
            RevertOnDisposeUtilKt.addComponent$default((Container)jPanel2, (Component)environmentPanel, null, (int)2, null);
        }
        this.dataPanel = ScrollPaneFactory.createScrollPane((Component)jPanel2, (boolean)true);
        this.remove(this.emptyPanel);
        this.add(this.dataPanel);
    }

    public final void bind(@NotNull Session session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        int pid = ((ProcessInfo)session.getProcessInfoProperty().getValue()).getProcessId();
        logger.trace("bind pid:" + pid);
        JComponent jComponent = this.dataPanel;
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            this.remove(it);
        }
        this.add(this.emptyPanel);
        session.getProcessInfoProperty().advise(lifetime, (Function1)new Function1<ProcessInfo, Unit>((Object)this){

            public final void invoke(ProcessInfo p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ProcessDashboardPanel.access$setProcessInfo((ProcessDashboardPanel)((Object)this.receiver), p0);
            }
        });
        lifetime.onTermination(() -> ProcessDashboardPanel.bind$lambda$28(pid, this));
    }

    private static final void setProcessInfo$lambda$5$lambda$4$lambda$3(String $processId, ActionEvent it) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($processId));
    }

    private static final void setProcessInfo$lambda$11$lambda$8$lambda$7(String $filename, ActionEvent it) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($filename));
    }

    private static final void setProcessInfo$lambda$11$lambda$10$lambda$9(String $filename, ActionEvent it) {
        Path path = Paths.get($filename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        RevealFileAction.openFile((Path)path);
    }

    private static final void setProcessInfo$lambda$15$lambda$14$lambda$13(String $startTime, ActionEvent it) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($startTime));
    }

    private static final void setProcessInfo$lambda$19$lambda$18$lambda$17(String $commandLine, ActionEvent it) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($commandLine));
    }

    private static final void setProcessInfo$lambda$23$lambda$22$lambda$21(String $architecture, ActionEvent it) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection($architecture));
    }

    private static final Unit bind$lambda$28(int $pid, ProcessDashboardPanel this$0) {
        logger.trace("unbind pid:" + $pid);
        this$0.remove(this$0.dataPanel);
        this$0.add(this$0.emptyPanel);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setProcessInfo(ProcessDashboardPanel $this, ProcessInfo processInfo) {
        $this.setProcessInfo(processInfo);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProcessDashboardPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProcessDashboardPanel.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ProcessDashboardPanel$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

