/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.ui.charts.ChartUtils;
import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.Grid;
import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.GridLine;
import com.intellij.ui.charts.MinMax;
import com.intellij.ui.charts.XYChartComponent;
import com.intellij.util.ui.JBUI;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.view.MemoryChartKt;
import com.jetbrains.dpa.monitoring.view.MonitoringChart;
import com.jetbrains.dpa.monitoring.view.overlays.HelpersKt;
import java.awt.Graphics2D;
import java.awt.Insets;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/dpa/monitoring/view/MemoryXYLineChart;", "Lcom/jetbrains/dpa/monitoring/view/MonitoringChart;", "<init>", "()V", "findGridLabelOffset", "Lcom/intellij/ui/charts/Coordinates;", "", "line", "Lcom/intellij/ui/charts/GridLine;", "g", "Ljava/awt/Graphics2D;", "update", "", "aggregatedChartValue", "Lcom/jetbrains/dpa/monitoring/sessions/ChartData;", "isUpdate", "", "reset", "intellij.rider.plugins.dpa"})
public final class MemoryXYLineChart
extends MonitoringChart {
    public MemoryXYLineChart() {
        ChartUtils.ranges((XYChartComponent)((XYChartComponent)this), MemoryXYLineChart::_init_$lambda$0);
        ChartUtils.grid((GridChartWrapper)((GridChartWrapper)this), MemoryXYLineChart::_init_$lambda$2);
        this.setBorderPainted(true);
        this.setMargins((Insets)JBUI.insets((int)28, (int)10, (int)40, (int)10));
    }

    @NotNull
    protected Coordinates<Double, Double> findGridLabelOffset(@NotNull GridLine<?, ?, ?> line, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter(line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Coordinates base = super.findGridLabelOffset(line, g);
        return new Coordinates(base.getX(), (Number)(base.getY().doubleValue() + (double)15));
    }

    @Override
    public void update(@NotNull ChartData aggregatedChartValue, boolean isUpdate) {
        Intrinsics.checkNotNullParameter((Object)aggregatedChartValue, (String)"aggregatedChartValue");
        long timestamp = aggregatedChartValue.getTimeStamp();
        if (!isUpdate) {
            this.getRanges().setXMin((Number)(timestamp - (long)60));
            this.getRanges().setXMax((Number)timestamp);
        }
        this.getRanges().setYMax((Number)Math.max(this.getRanges().getYMax().doubleValue(), MemoryChartKt.access$toMb-VKZWuLQ(aggregatedChartValue.getTotalMemory-s-VKNKU())));
        this.applyEventHandlers(timestamp, aggregatedChartValue, isUpdate);
    }

    @Override
    public void reset() {
        super.reset();
        this.getRanges().setYMax((Number)100.0);
    }

    private static final Unit _init_$lambda$0(MinMax $this$ranges) {
        Intrinsics.checkNotNullParameter((Object)$this$ranges, (String)"$this$ranges");
        $this$ranges.setYMin((Number)0.0);
        $this$ranges.setYMax((Number)100.0);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$2$lambda$1(GridLine $this$xPainter) {
        Intrinsics.checkNotNullParameter((Object)$this$xPainter, (String)"$this$xPainter");
        $this$xPainter.setPaintLine($this$xPainter.getValue().longValue() % (long)60 == 0L);
        if ($this$xPainter.getPaintLine()) {
            $this$xPainter.setLabel(HelpersKt.createTimeLabel($this$xPainter.getValue().longValue()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Grid $this$grid) {
        Intrinsics.checkNotNullParameter((Object)$this$grid, (String)"$this$grid");
        $this$grid.setYLines(ChartUtils.generator((double)200.0));
        $this$grid.setXLines(ChartUtils.generator((long)1L));
        ChartUtils.xPainter((Grid)$this$grid, MemoryXYLineChart::lambda$2$lambda$1);
        return Unit.INSTANCE;
    }
}

