/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.ui.JBColor;
import com.intellij.ui.charts.ChartComponent;
import com.intellij.ui.charts.Overlay;
import com.intellij.ui.charts.XYLineDataset;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.view.CpuChartKt;
import com.jetbrains.dpa.monitoring.view.CpuXYLineChart;
import com.jetbrains.dpa.monitoring.view.MonitoringChartDatasetParams;
import com.jetbrains.dpa.monitoring.view.overlays.CpuPanelOverlay;
import com.jetbrains.dpa.monitoring.view.overlays.ExceptionsOverlay;
import com.jetbrains.dpa.monitoring.view.overlays.ExceptionsOverlayKt;
import com.jetbrains.dpa.monitoring.view.overlays.PanelValueData;
import com.jetbrains.dpa.monitoring.view.overlays.TitleOverlay;
import com.jetbrains.dpa.monitoring.view.overlays.ValueOverlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u001a\u001a\u0010\t\u001a\u00020\u0005*\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"cpuColor", "Ljava/awt/Color;", "getCpuColor", "()Ljava/awt/Color;", "applyDotNetDatasetsAndOverlays", "Lcom/jetbrains/dpa/monitoring/view/CpuXYLineChart;", "sessionGetter", "Lkotlin/Function0;", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "applyNativeDatasetsAndOverlays", "intellij.rider.plugins.dpa"})
public final class CpuChartKt {
    @NotNull
    public static final Color getCpuColor() {
        JBColor jBColor = JBColor.BLUE;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLUE");
        return (Color)jBColor;
    }

    @NotNull
    public static final CpuXYLineChart applyDotNetDatasetsAndOverlays(@NotNull CpuXYLineChart $this$applyDotNetDatasetsAndOverlays, @NotNull Function0<ChartSession> sessionGetter) {
        CpuXYLineChart cpuXYLineChart;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyDotNetDatasetsAndOverlays), (String)"<this>");
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        CpuXYLineChart $this$applyDotNetDatasetsAndOverlays_u24lambda_u243 = cpuXYLineChart = $this$applyDotNetDatasetsAndOverlays;
        boolean bl = false;
        $this$applyDotNetDatasetsAndOverlays_u24lambda_u243.applyDatasetGenerator(MapsKt.mapOf((Pair)TuplesKt.to((Object)"CPU", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)CpuChartKt::applyDotNetDatasetsAndOverlays$lambda$3$lambda$0), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)arg_0 -> CpuChartKt.applyDotNetDatasetsAndOverlays$lambda$3$lambda$2(sessionGetter, arg_0)), (Function1<? super ChartData, Double>)((Function1)applyDotNetDatasetsAndOverlays.1.3.INSTANCE)))));
        return cpuXYLineChart;
    }

    @NotNull
    public static final CpuXYLineChart applyNativeDatasetsAndOverlays(@NotNull CpuXYLineChart $this$applyNativeDatasetsAndOverlays, @NotNull Function0<ChartSession> sessionGetter) {
        CpuXYLineChart cpuXYLineChart;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyNativeDatasetsAndOverlays), (String)"<this>");
        Intrinsics.checkNotNullParameter(sessionGetter, (String)"sessionGetter");
        CpuXYLineChart $this$applyNativeDatasetsAndOverlays_u24lambda_u247 = cpuXYLineChart = $this$applyNativeDatasetsAndOverlays;
        boolean bl = false;
        $this$applyNativeDatasetsAndOverlays_u24lambda_u247.applyDatasetGenerator(MapsKt.mapOf((Pair)TuplesKt.to((Object)"CPU", (Object)new MonitoringChartDatasetParams((Function1<? super XYLineDataset<Long, Double>, Unit>)((Function1)CpuChartKt::applyNativeDatasetsAndOverlays$lambda$7$lambda$4), (Function1<? super XYLineDataset<Long, Double>, ? extends List<? extends ChartComponent>>)((Function1)arg_0 -> CpuChartKt.applyNativeDatasetsAndOverlays$lambda$7$lambda$6(sessionGetter, arg_0)), (Function1<? super ChartData, Double>)((Function1)applyNativeDatasetsAndOverlays.1.3.INSTANCE)))));
        return cpuXYLineChart;
    }

    private static final Unit applyDotNetDatasetsAndOverlays$lambda$3$lambda$0(XYLineDataset it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setLineColor((Paint)CpuChartKt.getCpuColor());
        it.setFillColor((Paint)CpuChartKt.getCpuColor());
        return Unit.INSTANCE;
    }

    private static final PanelValueData[] applyDotNetDatasetsAndOverlays$lambda$3$lambda$2$lambda$1(Graphics2D g, ChartData value) {
        PanelValueData[] panelValueDataArray;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value.getExceptionCount-s-VKNKU() == 0L) {
            PanelValueData[] panelValueDataArray2 = new PanelValueData[1];
            Color color = CpuChartKt.getCpuColor();
            String string = MonitoringToolBundle.Companion.message("chart.cpu.panel.usage", new Object[0]);
            String string2 = "%.1f";
            Object[] objectArray = new Object[]{value.getCpuUsage()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            panelValueDataArray2[0] = new PanelValueData(g, color, string, string3 + " %");
            panelValueDataArray = panelValueDataArray2;
        } else {
            PanelValueData[] panelValueDataArray3 = new PanelValueData[2];
            Color color = CpuChartKt.getCpuColor();
            String string = MonitoringToolBundle.Companion.message("chart.cpu.panel.usage", new Object[0]);
            String string4 = "%.1f";
            Object[] objectArray = new Object[]{value.getCpuUsage()};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            panelValueDataArray3[0] = new PanelValueData(g, color, string, string5 + " %");
            panelValueDataArray3[1] = new PanelValueData(g, ExceptionsOverlayKt.getExceptionsColor(), MonitoringToolBundle.Companion.message("chart.cpu.panel.exceptions", new Object[0]), Long.toUnsignedString(value.getExceptionCount-s-VKNKU()));
            panelValueDataArray = panelValueDataArray3;
        }
        return panelValueDataArray;
    }

    private static final List applyDotNetDatasetsAndOverlays$lambda$3$lambda$2(Function0 $sessionGetter, XYLineDataset it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Overlay[]{new TitleOverlay(MonitoringToolBundle.Companion.message("chart.cpu.title.overlay", new Object[0]), "%", (XYLineDataset<Long, Double>)it), new ValueOverlay((XYLineDataset<Long, Double>)it), new ExceptionsOverlay((Function0<ChartSession>)$sessionGetter), new CpuPanelOverlay((Function0<ChartSession>)$sessionGetter, (Function2<? super Graphics2D, ? super ChartData, PanelValueData[]>)((Function2)CpuChartKt::applyDotNetDatasetsAndOverlays$lambda$3$lambda$2$lambda$1))};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final Unit applyNativeDatasetsAndOverlays$lambda$7$lambda$4(XYLineDataset it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setLineColor((Paint)CpuChartKt.getCpuColor());
        it.setFillColor((Paint)CpuChartKt.getCpuColor());
        return Unit.INSTANCE;
    }

    private static final PanelValueData[] applyNativeDatasetsAndOverlays$lambda$7$lambda$6$lambda$5(Graphics2D g, ChartData value) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PanelValueData[] panelValueDataArray = new PanelValueData[1];
        Color color = CpuChartKt.getCpuColor();
        String string = MonitoringToolBundle.Companion.message("chart.cpu.panel.usage", new Object[0]);
        String string2 = "%.1f";
        Object[] objectArray = new Object[]{value.getCpuUsage()};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        panelValueDataArray[0] = new PanelValueData(g, color, string, string3 + " %");
        return panelValueDataArray;
    }

    private static final List applyNativeDatasetsAndOverlays$lambda$7$lambda$6(Function0 $sessionGetter, XYLineDataset it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Overlay[]{new TitleOverlay(MonitoringToolBundle.Companion.message("chart.cpu.title.overlay", new Object[0]), "%", (XYLineDataset<Long, Double>)it), new ValueOverlay((XYLineDataset<Long, Double>)it), new CpuPanelOverlay((Function0<ChartSession>)$sessionGetter, (Function2<? super Graphics2D, ? super ChartData, PanelValueData[]>)((Function2)CpuChartKt::applyNativeDatasetsAndOverlays$lambda$7$lambda$6$lambda$5))};
        return CollectionsKt.listOf((Object[])objectArray);
    }
}

