/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.model.CollectorHostModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/dpa/monitoring/view/CollectorHostView;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "<init>", "()V", "model", "Lcom/jetbrains/dpa/monitoring/model/CollectorHostModel;", "getModel", "()Lcom/jetbrains/dpa/monitoring/model/CollectorHostModel;", "setModel", "(Lcom/jetbrains/dpa/monitoring/model/CollectorHostModel;)V", "bind", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "addLink", "linksPanel", "Ljavax/swing/JPanel;", "text", "", "action", "Ljava/lang/Runnable;", "getBackground", "Ljava/awt/Color;", "intellij.rider.plugins.dpa"})
public final class CollectorHostView
extends BorderLayoutPanel {
    @Nullable
    private CollectorHostModel model;

    public CollectorHostView() {
        this.setVisible(false);
        this.setBorder(new EmptyBorder(4, 10, 4, 10));
        JLabel label = new JLabel(MonitoringToolBundle.Companion.message("etw.panel.text", new Object[0]));
        label.setForeground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultForeground());
        this.addToTop(label);
        NonOpaquePanel linksPanel = new NonOpaquePanel((LayoutManager)new HorizontalLayout(16, 0, 2, null));
        this.addLink((JPanel)linksPanel, MonitoringToolBundle.Companion.message("etw.panel.learn.more", new Object[0]), () -> CollectorHostView._init_$lambda$0(this));
        this.addLink((JPanel)linksPanel, MonitoringToolBundle.Companion.message("etw.panel.install", new Object[0]), () -> CollectorHostView._init_$lambda$1(this));
        this.addLink((JPanel)linksPanel, MonitoringToolBundle.Companion.message("etw.panel.run", new Object[0]), () -> CollectorHostView._init_$lambda$2(this));
        this.addToCenter((Component)linksPanel);
    }

    @Nullable
    public final CollectorHostModel getModel() {
        return this.model;
    }

    public final void setModel(@Nullable CollectorHostModel collectorHostModel) {
        this.model = collectorHostModel;
    }

    public final void bind(@NotNull CollectorHostModel model, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        model.getCollectorHostIsRunning().advise(lifetime, arg_0 -> CollectorHostView.bind$lambda$3(this, arg_0));
        this.model = model;
        lifetime.onTermination(() -> CollectorHostView.bind$lambda$4(this));
    }

    /*
     * WARNING - void declaration
     */
    private final void addLink(JPanel linksPanel, String text, Runnable action) {
        void $this$addLink_u24lambda_u245;
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel = new HyperlinkLabel(text);
        Container container = linksPanel;
        boolean bl = false;
        $this$addLink_u24lambda_u245.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(action){
            final /* synthetic */ Runnable $action;
            {
                this.$action = $action;
            }

            protected void hyperlinkActivated(HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$action.run();
            }
        });
        RevertOnDisposeUtilKt.addComponent$default((Container)container, (Component)((Component)hyperlinkLabel), null, (int)2, null);
    }

    @NotNull
    public Color getBackground() {
        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
        if (color == null) {
            Color color2 = UIUtil.getToolTipBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getToolTipBackground(...)");
        }
        return color;
    }

    private static final void _init_$lambda$0(CollectorHostView this$0) {
        block0: {
            CollectorHostModel collectorHostModel = this$0.model;
            if (collectorHostModel == null) break block0;
            collectorHostModel.showHelp();
        }
    }

    private static final void _init_$lambda$1(CollectorHostView this$0) {
        block0: {
            CollectorHostModel collectorHostModel = this$0.model;
            if (collectorHostModel == null) break block0;
            collectorHostModel.installEtwHost();
        }
    }

    private static final void _init_$lambda$2(CollectorHostView this$0) {
        block0: {
            CollectorHostModel collectorHostModel = this$0.model;
            if (collectorHostModel == null) break block0;
            collectorHostModel.runEtwHost();
        }
    }

    private static final Unit bind$lambda$3(CollectorHostView this$0, boolean isRunning) {
        this$0.setVisible(!isRunning);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$4(CollectorHostView this$0) {
        this$0.model = null;
        return Unit.INSTANCE;
    }
}

