/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.charts.XYLineChart;
import com.intellij.ui.charts.XYLineDataset;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.sessions.ChartData;
import com.jetbrains.dpa.monitoring.sessions.ChartSession;
import com.jetbrains.dpa.monitoring.view.CpuChartKt;
import com.jetbrains.dpa.monitoring.view.CpuXYLineChart;
import com.jetbrains.dpa.monitoring.view.MemoryChartKt;
import com.jetbrains.dpa.monitoring.view.MemoryXYLineChart;
import com.jetbrains.dpa.monitoring.view.MonitoringChart;
import com.jetbrains.dpa.views.NotificationPanelViewControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.model.CollectorSessionStopReason;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0002J\u001c\u0010\r\u001a\u00020\f*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JD\u0010\u001a\u001a\u00020\f\"\u0004\b\u0000\u0010\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u001b0\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\f0\u001fH\u0002J\u0016\u0010 \u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ChartPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "<init>", "()V", "charts", "", "Lcom/jetbrains/dpa/monitoring/view/MonitoringChart;", "profilerPanel", "Lcom/jetbrains/dpa/views/NotificationPanelViewControl$DpaNotificationPanel;", "getProfilerPanel", "()Lcom/jetbrains/dpa/views/NotificationPanelViewControl$DpaNotificationPanel;", "addChartRepaint", "", "addChartListeners", "Lcom/intellij/ui/charts/XYLineChart;", "adapter", "Lcom/jetbrains/dpa/monitoring/view/ChartPanel$ChartMouseAdapter;", "session", "Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "getSession", "()Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;", "setSession", "(Lcom/jetbrains/dpa/monitoring/sessions/ChartSession;)V", "areDotNetDatasetsAndOverlaysApplied", "", "applyNativeDatasetsAndOverlays", "applyDotNetDatasetsAndOverlays", "T", "preAction", "Lkotlin/Function1;", "postAction", "Lkotlin/Function2;", "bind", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "update", "aggregatedChartValue", "Lcom/jetbrains/dpa/monitoring/sessions/ChartData;", "isUpdate", "Companion", "ChartMouseAdapter", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nChartPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartPanel.kt\ncom/jetbrains/dpa/monitoring/view/ChartPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,153:1\n1#2:154\n1863#3,2:155\n1863#3,2:157\n1863#3,2:159\n1863#3,2:161\n1187#3,2:163\n1261#3,4:165\n1863#3,2:171\n216#4,2:169\n13#5:173\n15#6:174\n*S KotlinDebug\n*F\n+ 1 ChartPanel.kt\ncom/jetbrains/dpa/monitoring/view/ChartPanel\n*L\n68#1:155,2\n77#1:157,2\n97#1:159,2\n145#1:161,2\n115#1:163,2\n115#1:165,4\n140#1:171,2\n119#1:169,2\n25#1:173\n25#1:174\n*E\n"})
public final class ChartPanel
extends BorderLayoutPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MonitoringChart> charts;
    @NotNull
    private final NotificationPanelViewControl.DpaNotificationPanel profilerPanel;
    @Nullable
    private ChartSession session;
    private boolean areDotNetDatasetsAndOverlaysApplied;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public ChartPanel() {
        void $this$_init__u24lambda_u245;
        BorderLayoutPanel $this$_init__u24lambda_u244;
        void $this$profilerPanel_u24lambda_u242;
        Object object = new MonitoringChart[]{CpuChartKt.applyNativeDatasetsAndOverlays(new CpuXYLineChart(), (Function0<ChartSession>)((Function0)() -> ChartPanel.charts$lambda$0(this))), MemoryChartKt.applyNativeDatasetsAndOverlays(new MemoryXYLineChart(), (Function0<ChartSession>)((Function0)() -> ChartPanel.charts$lambda$1(this)))};
        this.charts = CollectionsKt.listOf((Object[])object);
        object = new NotificationPanelViewControl.DpaNotificationPanel();
        Object object2 = object;
        Object object3 = this;
        boolean bl = false;
        $this$profilerPanel_u24lambda_u242.setText(MonitoringToolBundle.Companion.message("notification.profiler", new Object[0]));
        $this$profilerPanel_u24lambda_u242.setVisible(false);
        object3.profilerPanel = object;
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        Object $this$_init__u24lambda_u243 = object2 = new JPanel((LayoutManager)new VerticalLayout(4));
        boolean $i$a$-apply-ChartPanel$panel$22 = false;
        ((JComponent)$this$_init__u24lambda_u243).setBorder(new EmptyBorder(0, 0, 0, 0));
        Object panel = object2;
        RevertOnDisposeUtilKt.addComponent$default((Container)((Container)panel), (Component)((Component)((Object)this.profilerPanel)), null, (int)2, null);
        JBPanel jBPanel = new BorderLayoutPanel().withPreferredHeight(100);
        BorderLayoutPanel $i$a$-apply-ChartPanel$panel$22 = (BorderLayoutPanel)jBPanel;
        object3 = (Container)panel;
        boolean bl2 = false;
        $this$_init__u24lambda_u244.addToCenter((Component)this.charts.get(0).getComponent());
        JBPanel jBPanel2 = jBPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel2, (String)"apply(...)");
        RevertOnDisposeUtilKt.addComponent$default((Container)object3, (Component)((Component)jBPanel2), null, (int)2, null);
        jBPanel = new BorderLayoutPanel().withPreferredHeight(200);
        $this$_init__u24lambda_u244 = (BorderLayoutPanel)jBPanel;
        object3 = (Container)panel;
        boolean bl3 = false;
        $this$_init__u24lambda_u245.addToCenter((Component)this.charts.get(1).getComponent());
        JBPanel jBPanel3 = jBPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel3, (String)"apply(...)");
        RevertOnDisposeUtilKt.addComponent$default((Container)object3, (Component)((Component)jBPanel3), null, (int)2, null);
        this.addToCenter(ScrollPaneFactory.createScrollPane((Component)((Component)panel), (boolean)true));
        this.addChartRepaint();
    }

    @NotNull
    public final NotificationPanelViewControl.DpaNotificationPanel getProfilerPanel() {
        return this.profilerPanel;
    }

    private final void addChartRepaint() {
        for (MonitoringChart chart : this.charts) {
            ChartMouseAdapter adapter = new ChartMouseAdapter((XYLineChart<Long, Double>)((XYLineChart)chart));
            for (MonitoringChart chartToListen : this.charts) {
                if (Intrinsics.areEqual((Object)((Object)chartToListen), (Object)((Object)chart))) continue;
                this.addChartListeners(chartToListen, adapter);
            }
        }
    }

    private final void addChartListeners(XYLineChart<?, ?> $this$addChartListeners, ChartMouseAdapter adapter) {
        $this$addChartListeners.getComponent().addMouseListener(adapter);
        $this$addChartListeners.getComponent().addMouseMotionListener(adapter);
    }

    @Nullable
    public final ChartSession getSession() {
        return this.session;
    }

    public final void setSession(@Nullable ChartSession chartSession) {
        this.session = chartSession;
    }

    private final void applyNativeDatasetsAndOverlays(ChartSession session) {
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart chart = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            MonitoringChart monitoringChart = chart;
            if (monitoringChart instanceof CpuXYLineChart) {
                CpuChartKt.applyNativeDatasetsAndOverlays((CpuXYLineChart)chart, (Function0<ChartSession>)((Function0)() -> ChartPanel.applyNativeDatasetsAndOverlays$lambda$8$lambda$6(session)));
                continue;
            }
            if (!(monitoringChart instanceof MemoryXYLineChart)) continue;
            MemoryChartKt.applyNativeDatasetsAndOverlays((MemoryXYLineChart)chart, (Function0<ChartSession>)((Function0)() -> ChartPanel.applyNativeDatasetsAndOverlays$lambda$8$lambda$7(session)));
        }
    }

    private final <T> void applyDotNetDatasetsAndOverlays(ChartSession session, Function1<? super MonitoringChart, ? extends T> preAction, Function2<? super MonitoringChart, ? super T, Unit> postAction) {
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart chart = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            Object data = preAction.invoke((Object)chart);
            MonitoringChart monitoringChart = chart;
            if (monitoringChart instanceof CpuXYLineChart) {
                CpuChartKt.applyDotNetDatasetsAndOverlays((CpuXYLineChart)chart, (Function0<ChartSession>)((Function0)() -> ChartPanel.applyDotNetDatasetsAndOverlays$lambda$11$lambda$9(session)));
            } else if (monitoringChart instanceof MemoryXYLineChart) {
                MemoryChartKt.applyDotNetDatasetsAndOverlays((MemoryXYLineChart)chart, (Function0<ChartSession>)((Function0)() -> ChartPanel.applyDotNetDatasetsAndOverlays$lambda$11$lambda$10(session)));
            }
            postAction.invoke((Object)chart, data);
        }
        this.areDotNetDatasetsAndOverlaysApplied = true;
    }

    public final void bind(@NotNull ChartSession session, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        logger.trace("bind pid:" + session.getPid());
        this.session = session;
        session.getSessionStopReason().advise(lifetime, arg_0 -> ChartPanel.bind$lambda$12(this, arg_0));
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart p0 = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            p0.reset();
        }
        this.applyNativeDatasetsAndOverlays(session);
        this.areDotNetDatasetsAndOverlaysApplied = false;
        if (((Boolean)session.getHasDotNetMemoryData().getValue()).booleanValue()) {
            this.applyDotNetDatasetsAndOverlays(session, ChartPanel::bind$lambda$13, ChartPanel::bind$lambda$14);
        }
        int n = session.getCachedData().size();
        for (int i = 0; i < n; ++i) {
            this.update(session.getChartData(i), false);
        }
        this.repaint();
        if (!this.areDotNetDatasetsAndOverlaysApplied) {
            SourceExKt.adviseUntil((ISource)((ISource)session.getHasDotNetMemoryData()), (Lifetime)lifetime, arg_0 -> ChartPanel.bind$lambda$19(this, session, arg_0));
        }
        session.getOnChartEvent().advise(lifetime, arg_0 -> ChartPanel.bind$lambda$20(this, arg_0));
        session.getOnMessageCheckDelayEvent().advise(lifetime, arg_0 -> ChartPanel.bind$lambda$21(this, arg_0));
        lifetime.onTermination(() -> ChartPanel.bind$lambda$23(session, this));
    }

    private final void update(ChartData aggregatedChartValue, boolean isUpdate) {
        Iterable $this$forEach$iv = this.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart it = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            it.update(aggregatedChartValue, isUpdate);
        }
    }

    private static final ChartSession charts$lambda$0(ChartPanel this$0) {
        return this$0.session;
    }

    private static final ChartSession charts$lambda$1(ChartPanel this$0) {
        return this$0.session;
    }

    private static final ChartSession applyNativeDatasetsAndOverlays$lambda$8$lambda$6(ChartSession $session) {
        return $session;
    }

    private static final ChartSession applyNativeDatasetsAndOverlays$lambda$8$lambda$7(ChartSession $session) {
        return $session;
    }

    private static final ChartSession applyDotNetDatasetsAndOverlays$lambda$11$lambda$9(ChartSession $session) {
        return $session;
    }

    private static final ChartSession applyDotNetDatasetsAndOverlays$lambda$11$lambda$10(ChartSession $session) {
        return $session;
    }

    private static final Unit bind$lambda$12(ChartPanel this$0, CollectorSessionStopReason stopReason) {
        this$0.profilerPanel.setVisible(stopReason == CollectorSessionStopReason.Profiler);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$13(MonitoringChart it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$14(MonitoringChart monitoringChart, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)monitoringChart), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map bind$lambda$19$lambda$16(MonitoringChart chart) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)chart), (String)"chart");
        Iterable $this$associate$iv = chart.getDatasets();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            XYLineDataset it = (XYLineDataset)element$iv$iv;
            boolean bl = false;
            String string = it.getLabel();
            Iterable iterable2 = it.getData();
            Intrinsics.checkNotNull((Object)iterable2, (String)"null cannot be cast to non-null type kotlin.collections.Collection<com.intellij.ui.charts.Coordinates<kotlin.Long, kotlin.Double>>");
            Pair pair = TuplesKt.to((Object)string, (Object)((Collection)iterable2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final Unit bind$lambda$19$lambda$18(MonitoringChart chart, Map oldData) {
        Intrinsics.checkNotNullParameter((Object)((Object)chart), (String)"chart");
        Intrinsics.checkNotNullParameter((Object)oldData, (String)"oldData");
        Map $this$forEach$iv = oldData;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k);
            chart.getDataset((String)k).addAll((Collection)it.getValue());
        }
        return Unit.INSTANCE;
    }

    private static final boolean bind$lambda$19(ChartPanel this$0, ChartSession $session, boolean isDpaEvent) {
        if (isDpaEvent) {
            this$0.applyDotNetDatasetsAndOverlays($session, ChartPanel::bind$lambda$19$lambda$16, ChartPanel::bind$lambda$19$lambda$18);
        }
        return isDpaEvent;
    }

    private static final Unit bind$lambda$20(ChartPanel this$0, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.update((ChartData)it.getFirst(), (Boolean)it.getSecond());
        this$0.repaint();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$21(ChartPanel this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.repaint();
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$23(ChartSession $session, ChartPanel this$0) {
        logger.trace("unbind pid:" + $session.getPid());
        this$0.session = null;
        Iterable $this$forEach$iv = this$0.charts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MonitoringChart p0 = (MonitoringChart)((Object)element$iv);
            boolean bl = false;
            p0.reset();
        }
        this$0.repaint();
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ChartPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ChartPanel.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ChartPanel$ChartMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "chartToRepaint", "Lcom/intellij/ui/charts/XYLineChart;", "", "", "<init>", "(Lcom/intellij/ui/charts/XYLineChart;)V", "mouseEntered", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mouseMoved", "intellij.rider.plugins.dpa"})
    private static final class ChartMouseAdapter
    extends MouseAdapter {
        @NotNull
        private final XYLineChart<Long, Double> chartToRepaint;

        public ChartMouseAdapter(@NotNull XYLineChart<Long, Double> chartToRepaint) {
            Intrinsics.checkNotNullParameter(chartToRepaint, (String)"chartToRepaint");
            this.chartToRepaint = chartToRepaint;
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.chartToRepaint.getComponent().repaint();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.chartToRepaint.getComponent().repaint();
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.chartToRepaint.getComponent().repaint();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/view/ChartPanel$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

