/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.listeners;

import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.jetbrains.dpa.monitoring.listeners.MonitoringToolWindowManagerListener;
import com.jetbrains.dpa.monitoring.services.SessionsController;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J \u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener;", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "activeProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "onExecutionFinished", "", "processHandler", "tryFinishPreviousExecution", "content", "Lcom/intellij/ui/content/Content;", "currentProcessHandler", "stateChanged", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "changeType", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener$ToolWindowManagerEventType;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringToolWindowManagerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringToolWindowManagerListener.kt\ncom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n13#2:121\n15#3:122\n*S KotlinDebug\n*F\n+ 1 MonitoringToolWindowManagerListener.kt\ncom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener\n*L\n21#1:121\n21#1:122\n*E\n"})
public final class MonitoringToolWindowManagerListener
implements ToolWindowManagerListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private ProcessHandler activeProcessHandler;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Key<ProcessHandler> PREVIOUS_PROCESS_HANDLER_KEY;
    @NotNull
    public static final String RUN_TOOLWINDOW_ID = "Run";
    @NotNull
    public static final String DEBUG_TOOLWINDOW_ID = "Debug";

    public MonitoringToolWindowManagerListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void onExecutionFinished(ProcessHandler processHandler) {
        logger.trace("onExecutionFinished processHandler:" + processHandler);
        SessionsController.Companion.getInstance(this.project).deleteSession(processHandler);
    }

    private final void tryFinishPreviousExecution(Content content, ProcessHandler currentProcessHandler) {
        ProcessHandler previousProcessHandler = (ProcessHandler)content.getUserData(PREVIOUS_PROCESS_HANDLER_KEY);
        if (previousProcessHandler != null && !Intrinsics.areEqual((Object)previousProcessHandler, (Object)currentProcessHandler)) {
            this.onExecutionFinished(previousProcessHandler);
        }
        if (!Intrinsics.areEqual((Object)previousProcessHandler, (Object)currentProcessHandler)) {
            logger.trace("checkExecutionIdFinished new processHandler:" + currentProcessHandler);
            content.putUserData(PREVIOUS_PROCESS_HANDLER_KEY, (Object)currentProcessHandler);
        }
    }

    public void stateChanged(@NotNull ToolWindowManager toolWindowManager, @NotNull ToolWindow toolWindow, @NotNull ToolWindowManagerListener.ToolWindowManagerEventType changeType) {
        Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
        if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)"Services")) {
            if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow) {
                logger.trace("Toolwindow activated " + toolWindow.getId());
                Content content = RunDashboardManager.getInstance((Project)this.project).getDashboardContentManager().getSelectedContent();
                if (content == null || (content = (RunContentDescriptor)content.getUserData(RunContentDescriptor.DESCRIPTOR_KEY)) == null || (content = content.getProcessHandler()) == null) {
                    return;
                }
                Content processHandler = content;
                this.activeProcessHandler = processHandler;
                logger.trace("processHandler:" + (ProcessHandler)processHandler);
                SessionsController.Companion.getInstance(this.project).activateSession((ProcessHandler)processHandler);
            } else if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.RegisterToolWindow) {
                logger.trace("service tool window RegisterToolWindow");
                RunDashboardManager.getInstance((Project)this.project).getDashboardContentManager().addContentManagerListener(new ContentManagerListener(this){
                    final /* synthetic */ MonitoringToolWindowManagerListener this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void contentRemoved(ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("RunDashboardManager contentRemoved event:" + event.getOperation());
                        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                            return;
                        }
                        RunContentDescriptor processHandler = runContentDescriptor;
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("processHandler:" + (ProcessHandler)processHandler);
                        MonitoringToolWindowManagerListener.access$onExecutionFinished(this.this$0, (ProcessHandler)processHandler);
                    }

                    public void selectionChanged(ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("RunDashboardManager selectionChanged event:" + event.getOperation());
                        ContentManagerEvent.ContentOperation contentOperation = event.getOperation();
                        switch (contentOperation == null ? -1 : stateChanged.WhenMappings.$EnumSwitchMapping$0[contentOperation.ordinal()]) {
                            case 1: {
                                RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                                if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                                    return;
                                }
                                RunContentDescriptor processHandler = runContentDescriptor;
                                MonitoringToolWindowManagerListener.access$getLogger$cp().trace("processHandler:" + (ProcessHandler)processHandler);
                                SessionsController.Companion.getInstance(this.this$0.getProject()).activateSession((ProcessHandler)processHandler);
                                Content content = event.getContent();
                                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                                MonitoringToolWindowManagerListener.access$tryFinishPreviousExecution(this.this$0, content, (ProcessHandler)processHandler);
                                break;
                            }
                            case 2: {
                                RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                                if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                                    return;
                                }
                                RunContentDescriptor processHandler = runContentDescriptor;
                                MonitoringToolWindowManagerListener.access$getLogger$cp().trace("processHandler:" + (ProcessHandler)processHandler);
                                SessionsController.Companion.getInstance(this.this$0.getProject()).activateSession(null);
                                break;
                            }
                            case 3: {
                                throw new Error("unknown operation: " + event.getOperation());
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                    }
                });
            }
        } else if (Intrinsics.areEqual((Object)toolWindow.getId(), (Object)RUN_TOOLWINDOW_ID) || Intrinsics.areEqual((Object)toolWindow.getId(), (Object)DEBUG_TOOLWINDOW_ID)) {
            if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow) {
                Content content = toolWindow.getContentManager().getSelectedContent();
                if (content == null || (content = (RunContentDescriptor)content.getUserData(RunContentDescriptor.DESCRIPTOR_KEY)) == null || (content = content.getProcessHandler()) == null) {
                    return;
                }
                Content processHandler = content;
                this.activeProcessHandler = processHandler;
                logger.trace("Toolwindow activated " + toolWindow + ".id processHandler:" + (ProcessHandler)processHandler);
                SessionsController.Companion.getInstance(this.project).activateSession((ProcessHandler)processHandler);
            } else if (changeType == ToolWindowManagerListener.ToolWindowManagerEventType.RegisterToolWindow) {
                toolWindow.getContentManager().addContentManagerListener(new ContentManagerListener(this){
                    final /* synthetic */ MonitoringToolWindowManagerListener this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void contentRemoved(ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                            return;
                        }
                        RunContentDescriptor processHandler = runContentDescriptor;
                        MonitoringToolWindowManagerListener.access$getLogger$cp().trace("debug contentRemoved processHandler:" + (ProcessHandler)processHandler);
                        MonitoringToolWindowManagerListener.access$onExecutionFinished(this.this$0, (ProcessHandler)processHandler);
                    }

                    public void selectionChanged(ContentManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (event.getOperation() != ContentManagerEvent.ContentOperation.add) {
                            return;
                        }
                        RunContentDescriptor runContentDescriptor = (RunContentDescriptor)event.getContent().getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
                        if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                            return;
                        }
                        RunContentDescriptor processHandler = runContentDescriptor;
                        SessionsController.Companion.getInstance(this.this$0.getProject()).activateSession((ProcessHandler)processHandler);
                        Content content = event.getContent();
                        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                        MonitoringToolWindowManagerListener.access$tryFinishPreviousExecution(this.this$0, content, (ProcessHandler)processHandler);
                    }
                });
            }
        }
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$onExecutionFinished(MonitoringToolWindowManagerListener $this, ProcessHandler processHandler) {
        $this.onExecutionFinished(processHandler);
    }

    public static final /* synthetic */ void access$tryFinishPreviousExecution(MonitoringToolWindowManagerListener $this, Content content, ProcessHandler currentProcessHandler) {
        $this.tryFinishPreviousExecution(content, currentProcessHandler);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringToolWindowManagerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MonitoringToolWindowManagerListener.logger = logger;
        Key key = Key.create((String)"PreviousProcessHandler");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PREVIOUS_PROCESS_HANDLER_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/MonitoringToolWindowManagerListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "PREVIOUS_PROCESS_HANDLER_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/process/ProcessHandler;", "getPREVIOUS_PROCESS_HANDLER_KEY", "()Lcom/intellij/openapi/util/Key;", "RUN_TOOLWINDOW_ID", "", "DEBUG_TOOLWINDOW_ID", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ProcessHandler> getPREVIOUS_PROCESS_HANDLER_KEY() {
            return PREVIOUS_PROCESS_HANDLER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

