/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.listeners;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.dpa.DpaExtension;
import com.jetbrains.dpa.monitoring.listeners.MonitoringProcessTerminationListener;
import com.jetbrains.dpa.monitoring.services.SessionsController;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.dpa.utils.ProcessHandlerUtilKt;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.model.AttachProcessArgs;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.MonitoringToolModel_PregeneratedKt;
import com.jetbrains.rider.model.ProcessResult;
import com.jetbrains.rider.model.ProtocolDotNetSession;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.projectView.SolutionConfigurationManager;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.run.ExternalConsoleProcessHandler;
import com.jetbrains.rider.run.configurations.unity.UnityAttachRunConfiguration;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH$J\f\u0010\f\u001a\u00020\t*\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0002J.\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\rH\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isRunnerAllowed", "", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "isRunViaDpaRunner", "Lcom/intellij/execution/process/ProcessHandler;", "handleStartViaDpaRunner", "", "protocolSession", "Lcom/jetbrains/rider/model/ProtocolDotNetSession;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "processHandler", "startDotNetSession", "Lorg/jetbrains/concurrency/AsyncPromise;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "debug", "pid", "", "processStarted", "executorId", "", "Companion", "ProcessListenerAdapter", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nBasicMonitoringExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicMonitoringExecutionListener.kt\ncom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n1#2:183\n13#3:184\n15#4:185\n*S KotlinDebug\n*F\n+ 1 BasicMonitoringExecutionListener.kt\ncom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener\n*L\n35#1:184\n35#1:185\n*E\n"})
public abstract class BasicMonitoringExecutionListener
implements ExecutionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String DEBUG_EXECUTOR_ID = "Debug";
    @NotNull
    private static final String RUN_EXECUTOR_ID = "Run";

    public BasicMonitoringExecutionListener(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    protected abstract boolean isRunnerAllowed(@NotNull ProgramRunner<?> var1);

    private final boolean isRunViaDpaRunner(ProcessHandler $this$isRunViaDpaRunner) {
        String string;
        ProcessHandler processHandler = $this$isRunViaDpaRunner;
        if (processHandler instanceof BaseOSProcessHandler) {
            string = ((BaseOSProcessHandler)$this$isRunViaDpaRunner).getCommandLine();
        } else if (processHandler instanceof ExternalConsoleProcessHandler) {
            string = ((ExternalConsoleProcessHandler)$this$isRunViaDpaRunner).getCommandLineString();
        } else {
            throw new IllegalArgumentException("Unsupported process handler type: " + $this$isRunViaDpaRunner.getClass().getName());
        }
        String commandLine = string;
        Intrinsics.checkNotNull((Object)commandLine);
        return StringsKt.contains$default((CharSequence)commandLine, (CharSequence)"JetBrains.DPA.Runner.exe", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleStartViaDpaRunner(ProtocolDotNetSession protocolSession, ExecutionEnvironment env, ProcessHandler processHandler) {
        Session.Mode mode = protocolSession.getDebug() ? Session.Mode.Debug : Session.Mode.Run;
        Integer pid = (Integer)protocolSession.getPid().getValue();
        if (pid != null) {
            void $this$handleStartViaDpaRunner_u24lambda_u240;
            AsyncPromise asyncPromise;
            logger.trace("pid:" + pid + " mapped for processHandler:" + processHandler);
            AsyncPromise asyncPromise2 = asyncPromise = new AsyncPromise();
            ProcessHandler processHandler2 = processHandler;
            SessionsController sessionsController = SessionsController.Companion.getInstance(this.project);
            boolean bl = false;
            $this$handleStartViaDpaRunner_u24lambda_u240.setResult((Object)protocolSession);
            Unit unit = Unit.INSTANCE;
            sessionsController.startSession(processHandler2, (AsyncPromise<ProtocolDotNetSession>)asyncPromise, pid, mode);
        } else {
            SourceExKt.adviseUntil((ISource)((ISource)protocolSession.getPid()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), arg_0 -> BasicMonitoringExecutionListener.handleStartViaDpaRunner$lambda$1(this, processHandler, mode, protocolSession, arg_0));
        }
    }

    private final AsyncPromise<ProtocolDotNetSession> startDotNetSession(Lifetime lifetime, boolean debug, int pid, ProcessHandler processHandler) {
        AsyncPromise promise = new AsyncPromise();
        if (Intrinsics.areEqual((Object)processHandler.getUserData(DpaExtension.Companion.getIS_PROCESSED_KEY()), (Object)true)) {
            promise.cancel();
            return promise;
        }
        SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(this.project);
        RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
        AttachProcessArgs request = new AttachProcessArgs(buildConfigurationId, debug, true, pid, null);
        IOptPropertyView result = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getProcessAttach().start(lifetime, (Object)request).getResult();
        SourceExKt.adviseOnce((ISource)((ISource)result), (Lifetime)lifetime, arg_0 -> BasicMonitoringExecutionListener.startDotNetSession$lambda$2(debug, pid, processHandler, this, promise, arg_0));
        return promise;
    }

    /*
     * WARNING - void declaration
     */
    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        if (processHandler.isProcessTerminating() || processHandler.isProcessTerminated()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)executorId, (Object)DEBUG_EXECUTOR_ID) && !Intrinsics.areEqual((Object)executorId, (Object)RUN_EXECUTOR_ID)) {
            return;
        }
        ProgramRunner programRunner = env.getRunner();
        Intrinsics.checkNotNullExpressionValue((Object)programRunner, (String)"getRunner(...)");
        if (!this.isRunnerAllowed(programRunner)) {
            return;
        }
        logger.trace("processStarted with executorId:" + executorId);
        processHandler.addProcessListener((ProcessListener)new MonitoringProcessTerminationListener(this.project, this.coroutineScope), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), null, (int)1, null));
        ProtocolDotNetSession dpaSession = (ProtocolDotNetSession)processHandler.getUserData(DpaExtension.Companion.getMONITORING_MODEL_KEY());
        if (dpaSession != null) {
            logger.trace("dpa session found");
            this.handleStartViaDpaRunner(dpaSession, env, processHandler);
            return;
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 instanceof BaseOSProcessHandler || processHandler2 instanceof ExternalConsoleProcessHandler) {
            logger.trace("normal run");
            Integer n = ProcessHandlerUtilKt.getProcessId(processHandler);
            Intrinsics.checkNotNull((Object)n);
            int pid = n;
            v2 = SessionsController.Companion.getInstance(this.project).startSession(processHandler, this.startDotNetSession(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), false, pid, processHandler), pid, Session.Mode.Run);
        } else if (processHandler2 instanceof DebuggerWorkerProcessHandler) {
            Integer unityEditorPid;
            RunProfile runProfile = env.getRunProfile();
            UnityAttachRunConfiguration unityAttachRunConfiguration = runProfile instanceof UnityAttachRunConfiguration ? (UnityAttachRunConfiguration)runProfile : null;
            Integer n = unityEditorPid = unityAttachRunConfiguration != null ? unityAttachRunConfiguration.getUnityEditorPid() : null;
            if (unityEditorPid != null) {
                void $this$processStarted_u24lambda_u243;
                AsyncPromise asyncPromise = new AsyncPromise();
                runProfile = asyncPromise;
                ProcessHandler processHandler3 = processHandler;
                SessionsController sessionsController = SessionsController.Companion.getInstance(this.project);
                boolean bl = false;
                $this$processStarted_u24lambda_u243.cancel();
                Unit unit = Unit.INSTANCE;
                v2 = sessionsController.startSession(processHandler3, (AsyncPromise<ProtocolDotNetSession>)asyncPromise, unityEditorPid, Session.Mode.Debug);
            } else {
                ((DebuggerWorkerProcessHandler)processHandler).getWorkerModel().getActiveSession().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), arg_0 -> BasicMonitoringExecutionListener.processStarted$lambda$5(env, processHandler, this, arg_0));
                v2 = Unit.INSTANCE;
            }
        } else {
            return;
        }
    }

    private static final boolean handleStartViaDpaRunner$lambda$1(BasicMonitoringExecutionListener this$0, ProcessHandler $processHandler, Session.Mode $mode, ProtocolDotNetSession $protocolSession, Integer pid) {
        if (pid != null) {
            BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pid, $processHandler, this$0, $mode, $protocolSession, null){
                int label;
                final /* synthetic */ Integer $pid;
                final /* synthetic */ ProcessHandler $processHandler;
                final /* synthetic */ BasicMonitoringExecutionListener this$0;
                final /* synthetic */ Session.Mode $mode;
                final /* synthetic */ ProtocolDotNetSession $protocolSession;
                {
                    this.$pid = $pid;
                    this.$processHandler = $processHandler;
                    this.this$0 = $receiver;
                    this.$mode = $mode;
                    this.$protocolSession = $protocolSession;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            BasicMonitoringExecutionListener.access$getLogger$cp().trace("pid:" + this.$pid + " mapped for processHandler:" + this.$processHandler);
                            AsyncPromise asyncPromise = new AsyncPromise();
                            ProtocolDotNetSession protocolDotNetSession = this.$protocolSession;
                            AsyncPromise $this$invokeSuspend_u24lambda_u240 = asyncPromise;
                            ProcessHandler processHandler = this.$processHandler;
                            SessionsController sessionsController = SessionsController.Companion.getInstance(BasicMonitoringExecutionListener.access$getProject$p(this.this$0));
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240.setResult((Object)protocolDotNetSession);
                            Unit unit = Unit.INSTANCE;
                            sessionsController.startSession(processHandler, (AsyncPromise<ProtocolDotNetSession>)asyncPromise, this.$pid, this.$mode);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return pid != null;
    }

    private static final Unit startDotNetSession$lambda$2(boolean $debug, int $pid, ProcessHandler $processHandler, BasicMonitoringExecutionListener this$0, AsyncPromise $promise, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RdTaskResult rdTaskResult = it;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            if (!$debug) {
                ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener().getStartNotified().fire((Object)$pid);
            }
            $processHandler.addProcessListener((ProcessListener)new ProcessListenerAdapter($pid, ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener()));
            long sessionId = ((ProcessResult)((RdTaskResult.Success)it).getValue()).getSessionId();
            ProtocolDotNetSession dpaSession = (ProtocolDotNetSession)MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this$0.project)).getDotNetSessions().get((Object)sessionId);
            if (dpaSession != null) {
                $promise.setResult((Object)dpaSession);
            } else {
                $promise.cancel();
            }
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            logger.warn((Throwable)((RdTaskResult.Fault)it).getError());
            $promise.setError((Throwable)((RdTaskResult.Fault)it).getError());
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            logger.info("DPA prepare for montioring was cancelled");
            $promise.cancel();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit processStarted$lambda$5$lambda$4(ProcessHandler $processHandler, BasicMonitoringExecutionListener this$0, ExecutionEnvironment $env, DebuggerSessionInfo debuggerSessionInfo) {
        Intrinsics.checkNotNullParameter((Object)debuggerSessionInfo, (String)"debuggerSessionInfo");
        logger.trace("debug workerModel targetReady");
        if (debuggerSessionInfo.getProcessId() == -1) {
            logger.trace("Debug session does not provide target process pid");
            Integer pidFromUserData = (Integer)$processHandler.getUserData(DebuggerWorkerProcessHandler.Companion.getPID_KEY());
            if (pidFromUserData != null) {
                logger.trace("Find pid in user data: " + pidFromUserData);
                SessionsController.Companion.getInstance(this$0.project).startSession($processHandler, this$0.startDotNetSession(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$env)), true, pidFromUserData, $processHandler), pidFromUserData, Session.Mode.Debug);
                return Unit.INSTANCE;
            }
            logger.trace("invalid pid=" + debuggerSessionInfo.getProcessId() + " received from debug workerModel, can't run monitoring");
            return Unit.INSTANCE;
        }
        SessionsController.Companion.getInstance(this$0.project).startSession($processHandler, this$0.startDotNetSession(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$env)), true, debuggerSessionInfo.getProcessId(), $processHandler), debuggerSessionInfo.getProcessId(), Session.Mode.Debug);
        return Unit.INSTANCE;
    }

    private static final Unit processStarted$lambda$5(ExecutionEnvironment $env, ProcessHandler $processHandler, BasicMonitoringExecutionListener this$0, DotNetDebuggerSessionModel it) {
        if (it == null) {
            return Unit.INSTANCE;
        }
        logger.trace("debug workerModel has active session");
        SourceExKt.adviseOnce((ISource)it.getTargetReady(), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$env)), arg_0 -> BasicMonitoringExecutionListener.processStarted$lambda$5$lambda$4($processHandler, this$0, $env, arg_0));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Project access$getProject$p(BasicMonitoringExecutionListener $this) {
        return $this.project;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BasicMonitoringExecutionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BasicMonitoringExecutionListener.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DEBUG_EXECUTOR_ID", "", "RUN_EXECUTOR_ID", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener$ProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "pid", "", "processListener", "Lcom/jetbrains/rider/model/ProcessListener;", "<init>", "(ILcom/jetbrains/rider/model/ProcessListener;)V", "getPid", "()I", "getProcessListener", "()Lcom/jetbrains/rider/model/ProcessListener;", "processWillTerminate", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class ProcessListenerAdapter
    extends ProcessAdapter {
        private final int pid;
        @NotNull
        private final com.jetbrains.rider.model.ProcessListener processListener;

        public ProcessListenerAdapter(int pid, @NotNull com.jetbrains.rider.model.ProcessListener processListener) {
            Intrinsics.checkNotNullParameter((Object)processListener, (String)"processListener");
            this.pid = pid;
            this.processListener = processListener;
        }

        public final int getPid() {
            return this.pid;
        }

        @NotNull
        public final com.jetbrains.rider.model.ProcessListener getProcessListener() {
            return this.processListener;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessWillTerminate().fire((Object)willBeDestroyed);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessTerminated().fire((Object)event.getExitCode());
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getStartNotified().fire((Object)this.pid);
        }

        public void processNotStarted() {
            this.processListener.getProcessNotStarted().fire((Object)Unit.INSTANCE);
        }
    }
}

