/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001dB\u0017\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/dpa/monitoring/actions/ProcessNameAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "defaultProcessInfo", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "<init>", "(Lcom/jetbrains/rd/util/reactive/IProperty;)V", "()V", "getDefaultProcessInfo", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Panel", "intellij.rider.plugins.dpa"})
public final class ProcessNameAction
extends AnAction
implements CustomComponentAction {
    @NotNull
    private final IProperty<ProcessInfo> defaultProcessInfo;
    @Nullable
    private String text;

    public ProcessNameAction(@NotNull IProperty<ProcessInfo> defaultProcessInfo) {
        Intrinsics.checkNotNullParameter(defaultProcessInfo, (String)"defaultProcessInfo");
        this.defaultProcessInfo = defaultProcessInfo;
    }

    @NotNull
    public final IProperty<ProcessInfo> getDefaultProcessInfo() {
        return this.defaultProcessInfo;
    }

    public ProcessNameAction() {
        this((IProperty<ProcessInfo>)((IProperty)new Property(null)));
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String string) {
        this.text = string;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProcessInfo processInfo = (ProcessInfo)this.defaultProcessInfo.getValue();
        if (processInfo == null) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(true);
        this.text = processInfo.getProcessName();
        JComponent panel = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (panel instanceof Panel) {
            ((Panel)panel).update(processInfo);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return new Panel(this.text);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/actions/ProcessNameAction$Panel;", "Ljavax/swing/JPanel;", "text", "", "<init>", "(Ljava/lang/String;)V", "label", "Ljavax/swing/JLabel;", "getLabel", "()Ljavax/swing/JLabel;", "update", "", "processInfo", "Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "intellij.rider.plugins.dpa"})
    public static final class Panel
    extends JPanel {
        @NotNull
        private final JLabel label = new JLabel();

        public Panel(@Nullable String text) {
            super((LayoutManager)new HorizontalLayout(4, 0, 2, null));
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.add(new JLabel(MonitoringToolBundle.Companion.message("action.MonitoringTool.ProcessName.ProcessLabel.text", new Object[0])));
            this.label.setText(text);
            this.add(this.label);
            JLabel iconLabel = new JLabel(AllIcons.General.ContextHelp);
            iconLabel.setToolTipText(MonitoringToolBundle.Companion.message("action.MonitoringTool.ProcessName.InfoIcon.text", new Object[0]));
            this.add(iconLabel);
        }

        @NotNull
        public final JLabel getLabel() {
            return this.label;
        }

        public final void update(@NotNull ProcessInfo processInfo) {
            Intrinsics.checkNotNullParameter((Object)processInfo, (String)"processInfo");
            this.label.setText(processInfo.getProcessName());
            this.label.setToolTipText(processInfo.getCommandLine());
        }
    }
}

