/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring;

import com.jetbrains.dotCommon.Architecture;
import com.jetbrains.dotCommon.ProcessInfoApi;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 +2\u00020\u0001:\u0001+BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001bJ^\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rH\u00c6\u0001\u00a2\u0006\u0002\u0010%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\n\n\u0002\u0010\u001c\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "", "processId", "", "processName", "", "fileName", "commandLine", "startTime", "Ljava/time/LocalDateTime;", "processArchitecture", "Lcom/jetbrains/dotCommon/Architecture;", "environmentVariables", "", "<init>", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalDateTime;Lcom/jetbrains/dotCommon/Architecture;[Ljava/lang/String;)V", "getProcessId", "()I", "getProcessName", "()Ljava/lang/String;", "getFileName", "getCommandLine", "getStartTime", "()Ljava/time/LocalDateTime;", "getProcessArchitecture", "()Lcom/jetbrains/dotCommon/Architecture;", "getEnvironmentVariables", "()[Ljava/lang/String;", "[Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/LocalDateTime;Lcom/jetbrains/dotCommon/Architecture;[Ljava/lang/String;)Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "equals", "", "other", "hashCode", "toString", "Companion", "intellij.rider.plugins.dpa"})
public final class ProcessInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int processId;
    @Nullable
    private final String processName;
    @NotNull
    private final String fileName;
    @NotNull
    private final String commandLine;
    @NotNull
    private final LocalDateTime startTime;
    @Nullable
    private final Architecture processArchitecture;
    @NotNull
    private final String[] environmentVariables;

    public ProcessInfo(int processId, @Nullable String processName, @NotNull String fileName, @NotNull String commandLine, @NotNull LocalDateTime startTime, @Nullable Architecture processArchitecture, @NotNull String[] environmentVariables) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        this.processId = processId;
        this.processName = processName;
        this.fileName = fileName;
        this.commandLine = commandLine;
        this.startTime = startTime;
        this.processArchitecture = processArchitecture;
        this.environmentVariables = environmentVariables;
    }

    public final int getProcessId() {
        return this.processId;
    }

    @Nullable
    public final String getProcessName() {
        return this.processName;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final String getCommandLine() {
        return this.commandLine;
    }

    @NotNull
    public final LocalDateTime getStartTime() {
        return this.startTime;
    }

    @Nullable
    public final Architecture getProcessArchitecture() {
        return this.processArchitecture;
    }

    @NotNull
    public final String[] getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public final int component1() {
        return this.processId;
    }

    @Nullable
    public final String component2() {
        return this.processName;
    }

    @NotNull
    public final String component3() {
        return this.fileName;
    }

    @NotNull
    public final String component4() {
        return this.commandLine;
    }

    @NotNull
    public final LocalDateTime component5() {
        return this.startTime;
    }

    @Nullable
    public final Architecture component6() {
        return this.processArchitecture;
    }

    @NotNull
    public final String[] component7() {
        return this.environmentVariables;
    }

    @NotNull
    public final ProcessInfo copy(int processId, @Nullable String processName, @NotNull String fileName, @NotNull String commandLine, @NotNull LocalDateTime startTime, @Nullable Architecture processArchitecture, @NotNull String[] environmentVariables) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        return new ProcessInfo(processId, processName, fileName, commandLine, startTime, processArchitecture, environmentVariables);
    }

    public static /* synthetic */ ProcessInfo copy$default(ProcessInfo processInfo, int n, String string, String string2, String string3, LocalDateTime localDateTime, Architecture architecture, String[] stringArray, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = processInfo.processId;
        }
        if ((n2 & 2) != 0) {
            string = processInfo.processName;
        }
        if ((n2 & 4) != 0) {
            string2 = processInfo.fileName;
        }
        if ((n2 & 8) != 0) {
            string3 = processInfo.commandLine;
        }
        if ((n2 & 0x10) != 0) {
            localDateTime = processInfo.startTime;
        }
        if ((n2 & 0x20) != 0) {
            architecture = processInfo.processArchitecture;
        }
        if ((n2 & 0x40) != 0) {
            stringArray = processInfo.environmentVariables;
        }
        return processInfo.copy(n, string, string2, string3, localDateTime, architecture, stringArray);
    }

    @NotNull
    public String toString() {
        return "ProcessInfo(processId=" + this.processId + ", processName=" + this.processName + ", fileName=" + this.fileName + ", commandLine=" + this.commandLine + ", startTime=" + this.startTime + ", processArchitecture=" + this.processArchitecture + ", environmentVariables=" + Arrays.toString(this.environmentVariables) + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.processId);
        result = result * 31 + (this.processName == null ? 0 : this.processName.hashCode());
        result = result * 31 + this.fileName.hashCode();
        result = result * 31 + this.commandLine.hashCode();
        result = result * 31 + this.startTime.hashCode();
        result = result * 31 + (this.processArchitecture == null ? 0 : this.processArchitecture.hashCode());
        result = result * 31 + Arrays.hashCode(this.environmentVariables);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProcessInfo)) {
            return false;
        }
        ProcessInfo processInfo = (ProcessInfo)other;
        if (this.processId != processInfo.processId) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.processName, (Object)processInfo.processName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fileName, (Object)processInfo.fileName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.commandLine, (Object)processInfo.commandLine)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)processInfo.startTime)) {
            return false;
        }
        if (this.processArchitecture != processInfo.processArchitecture) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.environmentVariables, (Object)processInfo.environmentVariables);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/dpa/monitoring/ProcessInfo$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "processId", "", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ProcessInfo create(int processId) {
            try {
                String fileName = ProcessInfoApi.INSTANCE.getProcessExecutable(processId);
                String processName = ((Object)Paths.get(fileName, new String[0]).getFileName()).toString();
                String commandLine = ProcessInfoApi.INSTANCE.getProcessCommandLine(processId);
                LocalDateTime startTime = ProcessInfoApi.INSTANCE.getProcessStartTime(processId);
                Architecture processArchitecture = ProcessInfoApi.INSTANCE.getProcessArchitecture(processId);
                String[] environmentVariables = ProcessInfoApi.INSTANCE.getProcessEnvironmentVariables(processId);
                return new ProcessInfo(processId, processName, fileName, commandLine, startTime, processArchitecture, environmentVariables);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

