/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring;

import com.intellij.ide.actions.ToolWindowEmptyStateAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.dpa.monitoring.actions.DataKeysKt;
import com.jetbrains.dpa.monitoring.actions.ProcessNameAction;
import com.jetbrains.dpa.monitoring.model.EmptyModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.ui.RiderToolWindowFactory;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory;", "Lcom/jetbrains/rider/ui/RiderToolWindowFactory;", "<init>", "()V", "shouldBeAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "init", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createToolWindowContent", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringToolWindowFactory.kt\ncom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,140:1\n13#2:141\n15#3:142\n*S KotlinDebug\n*F\n+ 1 MonitoringToolWindowFactory.kt\ncom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory\n*L\n34#1:141\n34#1:142\n*E\n"})
public final class MonitoringToolWindowFactory
extends RiderToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String MONITORING_TOOL_WINDOW_ID = "Monitoring";

    public boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setStripeTitle(MonitoringToolBundle.Companion.message("toolwindow.title", new Object[0]));
        super.init(toolWindow);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        toolWindow.getComponent().putClientProperty(ToolWindowContentUi.DONT_HIDE_TOOLBAR_IN_HEADER, true);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        JComponent jComponent = contentManager2.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.util.ui.ComponentWithEmptyText");
        StatusText statusText = ((ComponentWithEmptyText)jComponent).getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        StatusText emptyText = statusText;
        emptyText.setCenterAlignText(false);
        EmptyModel emptyModel = new EmptyModel(project, lifetime);
        emptyModel.isDisabled().advise(lifetime, arg_0 -> MonitoringToolWindowFactory.createToolWindowContent$lambda$1(emptyText, toolWindow, emptyModel, arg_0));
        Property processInfoProperty = new Property(null);
        JComponent jComponent2 = toolWindow.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getComponent(...)");
        UiUtils.putUserData((JComponent)jComponent2, DataKeysKt.getSESSION_PROCESS_INFO_USER_DATA(), (Object)processInfoProperty);
        ProcessNameAction processNameAction = new ProcessNameAction((IProperty<ProcessInfo>)((IProperty)processInfoProperty));
        AnAction[] anActionArray = new AnAction[]{processNameAction};
        ((ToolWindowEx)toolWindow).setTabActions(anActionArray);
    }

    private static final void createToolWindowContent$lambda$1$lambda$0(EmptyModel $emptyModel, ActionEvent it) {
        $emptyModel.enable();
    }

    private static final Unit createToolWindowContent$lambda$1(StatusText $emptyText, ToolWindow $toolWindow, EmptyModel $emptyModel, boolean isDisabled) {
        if (isDisabled) {
            $emptyText.setText(MonitoringToolBundle.Companion.message("empty.disabled.text", new Object[0]));
            v0 = $emptyText.appendSecondaryText(MonitoringToolBundle.Companion.message("empty.disabled.enable.text", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> MonitoringToolWindowFactory.createToolWindowContent$lambda$1$lambda$0($emptyModel, arg_0));
        } else {
            v0 = $emptyText.setText(MonitoringToolBundle.Companion.message("empty.no.process.text", new Object[0]));
        }
        ToolWindowEmptyStateAction.rebuildContentUi((ToolWindow)$toolWindow);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringToolWindowFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MonitoringToolWindowFactory.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "MONITORING_TOOL_WINDOW_ID", "", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

