/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.dotCommon.ui.PanelHelpersKt;
import com.jetbrains.dpa.DpaAvailabilityService;
import com.jetbrains.dpa.DpaBundle;
import com.jetbrains.dpa.IntegrationLevel;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ui.bindable.views.utils.PassFocusThroughTo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rdclient.ui.bindableUi.DisablableBeControlHost;
import com.jetbrains.rider.model.DpaModel;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.StatusBarInfo;
import com.jetbrains.rider.model.ToolWindowTab;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.ui.RiderToolWindowFactory;
import icons.ReSharperIcons;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.util.NoSuchElementException;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JB\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/dpa/ToolWindowFactory;", "Lcom/jetbrains/rider/ui/RiderToolWindowFactory;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "init", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "createToolWindowContent", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "createDisabledStateComponent", "Ljavax/swing/JComponent;", "dpaModel", "Lcom/jetbrains/rider/model/DpaModel;", "createTab", "Lcom/intellij/ui/content/Content;", "title", "", "property", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "icon", "Ljavax/swing/Icon;", "tabId", "Lcom/jetbrains/rider/model/ToolWindowTab;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowFactory.kt\ncom/jetbrains/dpa/ToolWindowFactory\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,169:1\n13402#2,2:170\n*S KotlinDebug\n*F\n+ 1 ToolWindowFactory.kt\ncom/jetbrains/dpa/ToolWindowFactory\n*L\n118#1:170,2\n*E\n"})
public final class ToolWindowFactory
extends RiderToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TOOLWINDOW_ID = "Dynamic Program Analysis";
    @NotNull
    private static final Key<ToolWindowTab> TAB_ID_KEY;
    @NotNull
    private static final String MemoryAllocation;
    @NotNull
    private static final String Sql;
    @NotNull
    private static final String Asp;
    @NotNull
    private static final String Thresholds;
    @NotNull
    public static final String HelpKeyword = "Dynamic_Program_Analysis";

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DpaAvailabilityService.Companion.getAvailability().compareTo((Enum)IntegrationLevel.Disabled) > 0;
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setStripeTitle(DpaBundle.INSTANCE.message("dpa.toolwindow.stripe", new Object[0]));
        super.init(toolWindow);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        contentManager2.addContent(this.createTab(project, lifetime, MemoryAllocation, (IProperty<BeControl>)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getMemoryTab(), ReSharperIcons.DpaCore.MemoryAllocation, ToolWindowTab.MemoryAllocations));
        contentManager2.addContent(this.createTab(project, lifetime, Sql, (IProperty<BeControl>)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getSqlTab(), ReSharperIcons.DpaCore.Sql, ToolWindowTab.Sql));
        contentManager2.addContent(this.createTab(project, lifetime, Asp, (IProperty<BeControl>)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getAspTab(), ReSharperIcons.DpaCore.Asp, ToolWindowTab.Asp));
        contentManager2.addContent(this.createTab(project, lifetime, Thresholds, (IProperty<BeControl>)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getThresholdsTab(), ReSharperIcons.DpaCore.Thresholds, ToolWindowTab.Thresholds));
        DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getStatusBarInfo().advise(lifetime, arg_0 -> ToolWindowFactory.createToolWindowContent$lambda$1(contentManager2, arg_0));
        toolWindow.setHelpId(HelpKeyword);
    }

    private final JComponent createDisabledStateComponent(DpaModel dpaModel) {
        return PanelHelpersKt.createEmptyStateComponent(arg_0 -> ToolWindowFactory.createDisabledStateComponent$lambda$3(dpaModel, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final Content createTab(Project project, Lifetime lifetime, String title, IProperty<BeControl> property, Icon icon, ToolWindowTab tabId) {
        void $this$createTab_u24lambda_u247_u24lambda_u246;
        DisablableBeControlHost disablableBeControlHost;
        SimpleToolWindowPanel simpleToolWindowPanel;
        Content content;
        Content content2 = ContentFactory.getInstance().createContent(null, title, false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content $this$createTab_u24lambda_u247 = content = content2;
        boolean bl = false;
        SimpleToolWindowPanel simpleToolWindowPanel2 = simpleToolWindowPanel = new SimpleToolWindowPanel(false).setProvideQuickActions(true);
        Content content3 = $this$createTab_u24lambda_u247;
        boolean bl2 = false;
        DisablableBeControlHost $this$createTab_u24lambda_u247_u24lambda_u246_u24lambda_u245 = disablableBeControlHost = new DisablableBeControlHost();
        boolean bl3 = false;
        $this$createTab_u24lambda_u247_u24lambda_u246_u24lambda_u245.bind(lifetime, (IPropertyView)property, (IOptPropertyView)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getEnabled(), () -> ToolWindowFactory.createTab$lambda$7$lambda$6$lambda$5$lambda$4(this, project));
        DisablableBeControlHost content4 = disablableBeControlHost;
        $this$createTab_u24lambda_u247_u24lambda_u246.setContent((JComponent)content4);
        $this$createTab_u24lambda_u247_u24lambda_u246.addFocusListener((FocusListener)new PassFocusThroughTo((JComponent)content4));
        content3.setComponent((JComponent)simpleToolWindowPanel);
        $this$createTab_u24lambda_u247.setCloseable(false);
        if (icon != null) {
            $this$createTab_u24lambda_u247.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
            $this$createTab_u24lambda_u247.setIcon(icon);
        }
        $this$createTab_u24lambda_u247.putUserData(TAB_ID_KEY, (Object)tabId);
        return content;
    }

    private static final Unit createToolWindowContent$lambda$1(ContentManager $contentManager, StatusBarInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Content[] contentArray = $contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$forEach$iv = contentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            ToolWindowTab toolWindowTab = (ToolWindowTab)it.getUserData(TAB_ID_KEY);
            switch (toolWindowTab == null ? -1 : WhenMappings.$EnumSwitchMapping$0[toolWindowTab.ordinal()]) {
                case 1: {
                    it.setDisplayName(ToolWindowFactory.Companion.getName(ToolWindowFactory.MemoryAllocation, info.getAllocationIssuesCount()));
                    break;
                }
                case 2: {
                    it.setDisplayName(ToolWindowFactory.Companion.getName(ToolWindowFactory.Sql, info.getSqlIssuesCount()));
                    break;
                }
                case 3: {
                    it.setDisplayName(ToolWindowFactory.Companion.getName(ToolWindowFactory.Asp, info.getAspIssuesCount()));
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final void createDisabledStateComponent$lambda$3$lambda$2(DpaModel $dpaModel, ActionEvent it) {
        $dpaModel.getSetEnabled().fire((Object)true);
    }

    private static final Unit createDisabledStateComponent$lambda$3(DpaModel $dpaModel, StatusText it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.appendText(DpaBundle.INSTANCE.message("dpa.toolwindow.dpa.is.disabled", new Object[0]));
        it.appendSecondaryText(DpaBundle.INSTANCE.message("dpa.toolwindow.enable.dpa", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> ToolWindowFactory.createDisabledStateComponent$lambda$3$lambda$2($dpaModel, arg_0));
        return Unit.INSTANCE;
    }

    private static final JComponent createTab$lambda$7$lambda$6$lambda$5$lambda$4(ToolWindowFactory this$0, Project $project) {
        return this$0.createDisabledStateComponent(DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)));
    }

    static {
        Key key = Key.create((String)"tabId");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TAB_ID_KEY = key;
        MemoryAllocation = DpaBundle.INSTANCE.message("dpa.toolwindow.memory.allocation", new Object[0]);
        Sql = DpaBundle.INSTANCE.message("dpa.toolwindow.sql", new Object[0]);
        Asp = DpaBundle.INSTANCE.message("dpa.toolwindow.asp", new Object[0]);
        Thresholds = DpaBundle.INSTANCE.message("dpa.toolwindow.threshold", new Object[0]);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\bJ6\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/dpa/ToolWindowFactory$Companion;", "", "<init>", "()V", "TOOLWINDOW_ID", "", "TAB_ID_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rider/model/ToolWindowTab;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "MemoryAllocation", "Sql", "Asp", "Thresholds", "HelpKeyword", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "showTab", "", "tabId", "content", "Lkotlin/Function1;", "Lcom/intellij/ui/content/ContentManager;", "Lcom/intellij/ui/content/Content;", "runnable", "Lkotlin/Function0;", "getName", "name", "count", "", "intellij.rider.plugins.dpa"})
    @SourceDebugExtension(value={"SMAP\nToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolWindowFactory.kt\ncom/jetbrains/dpa/ToolWindowFactory$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,169:1\n1137#2,2:170\n*S KotlinDebug\n*F\n+ 1 ToolWindowFactory.kt\ncom/jetbrains/dpa/ToolWindowFactory$Companion\n*L\n47#1:170,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final ToolWindow getToolWindow(Project project) {
            return ToolWindowManager.Companion.getInstance(project).getToolWindow(ToolWindowFactory.TOOLWINDOW_ID);
        }

        public final void showTab(@NotNull Project project, @NotNull ToolWindowTab tabId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)tabId, (String)"tabId");
            com.jetbrains.dpa.ToolWindowFactory$Companion.showTab$default(this, project, arg_0 -> Companion.showTab$lambda$1(tabId, arg_0), null, 4, null);
        }

        private final void showTab(Project project, Function1<? super ContentManager, ? extends Content> content, Function0<Unit> runnable) {
            block2: {
                block0: {
                    block1: {
                        ToolWindow toolWindow = this.getToolWindow(project);
                        if (toolWindow == null) break block0;
                        ContentManager contentManager = toolWindow.getContentManager();
                        ContentManager contentManager2 = toolWindow.getContentManager();
                        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getContentManager(...)");
                        contentManager.setSelectedContent((Content)content.invoke((Object)contentManager2));
                        if (toolWindow.isVisible()) break block1;
                        Function0<Unit> function0 = runnable;
                        toolWindow.show(function0 != null ? () -> Companion.showTab$lambda$2(function0) : null);
                        break block2;
                    }
                    Function0<Unit> function0 = runnable;
                    if (function0 == null) break block2;
                    function0.invoke();
                    break block2;
                }
                Function0<Unit> function0 = runnable;
                if (function0 == null) break block2;
                function0.invoke();
            }
        }

        static /* synthetic */ void showTab$default(Companion companion, Project project, Function1 function1, Function0 function0, int n, Object object) {
            if ((n & 4) != 0) {
                function0 = null;
            }
            companion.showTab(project, (Function1<? super ContentManager, ? extends Content>)function1, (Function0<Unit>)function0);
        }

        private final String getName(String name, int count) {
            String string;
            if (count == 0) {
                string = name;
            } else {
                String string2 = new HtmlBuilder().append(name).append(" ").append((HtmlChunk)HtmlChunk.tag((String)"font").attr("color", ColorUtil.toHtmlColor((Color)UIUtil.getInactiveTextColor())).addText(String.valueOf(count))).wrapWithHtmlBody().toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            return string;
        }

        private static final Content showTab$lambda$1(ToolWindowTab $tabId, ContentManager manager) {
            Object element$iv2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
                Content[] contentArray = manager.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                Object[] $this$first$iv = contentArray;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    Content it = (Content)element$iv2;
                    boolean bl = false;
                    if (!(it.getUserData(TAB_ID_KEY) == $tabId)) {
                        continue;
                    }
                    break block2;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Object object = element$iv2;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            return (Content)object;
        }

        private static final void showTab$lambda$2(Function0 $tmp0) {
            $tmp0.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ToolWindowTab.values().length];
            try {
                nArray[ToolWindowTab.MemoryAllocations.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowTab.Sql.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowTab.Asp.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

