/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.dpa.DpaAvailabilityService;
import com.jetbrains.dpa.DpaBundle;
import com.jetbrains.dpa.DpaHost;
import com.jetbrains.dpa.DpaStatistics;
import com.jetbrains.dpa.IntegrationLevel;
import com.jetbrains.dpa.utils.ProcessHandlerUtilKt;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rd.util.threading.SynchronousScheduler;
import com.jetbrains.rider.RiderEnvironment;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.debugger.RiderDebugRunner;
import com.jetbrains.rider.model.AttachProcessArgs;
import com.jetbrains.rider.model.CollectorSessionArgs;
import com.jetbrains.rider.model.DpaCancelReason;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.MonitoringToolModel_PregeneratedKt;
import com.jetbrains.rider.model.ProcessResult;
import com.jetbrains.rider.model.ProtocolDotNetSession;
import com.jetbrains.rider.model.RunType;
import com.jetbrains.rider.model.SessionResult;
import com.jetbrains.rider.model.StartingEnvironmentVars;
import com.jetbrains.rider.model.StartingProcessArgs;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.plugins.RiderBundledPluginHelpers;
import com.jetbrains.rider.projectView.SolutionConfigurationManager;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.run.PatchCommandLineExtension;
import com.jetbrains.rider.run.WorkerRunInfo;
import com.jetbrains.rider.runtime.DotNetRuntime;
import com.jetbrains.rider.runtime.mono.MonoRuntimeType;
import com.jetbrains.rider.shared.run.RawCommandLine;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 42\u00020\u0001:\u0006456789B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0014\b\u0001\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J0\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016JW\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010+\"\u0004\b\u0001\u0010*2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u0002H*0-2\u0006\u0010.\u001a\u0002H+2\u0006\u0010/\u001a\u00020\t2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u00020201\u00a2\u0006\u0002\u00103R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/jetbrains/dpa/DpaExtension;", "Lcom/jetbrains/rider/run/PatchCommandLineExtension;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "dpaIsNotPreparedPrefix", "", "prepareCommandTimeouts", "Lcom/jetbrains/rd/framework/impl/RpcTimeouts;", "pathToRunner", "Lkotlin/Lazy;", "Ljava/io/File;", "pathToDpaDebugInjector", "pathToDebuggerDebugInjector", "probingPathsEnvVar", "Lcom/jetbrains/dpa/DpaExtension$ProbingPathsEnvVar;", "project", "Lcom/intellij/openapi/project/Project;", "getDpaEnvVars", "Lcom/jetbrains/dpa/DpaExtension$DpaEnvVars;", "environment", "", "disabledByUser", "", "patchDebugCommandLine", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/rider/run/WorkerRunInfo;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "workerRunInfo", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "patchRunCommandLine", "Lcom/intellij/execution/process/ProcessListener;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dotNetRuntime", "Lcom/jetbrains/rider/runtime/DotNetRuntime;", "sync", "TRes", "TReq", "call", "Lcom/jetbrains/rd/framework/impl/RdCall;", "request", "timeouts", "onSuccessAfterTimeout", "Lkotlin/Function1;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/framework/impl/RdCall;Ljava/lang/Object;Lcom/jetbrains/rd/framework/impl/RpcTimeouts;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "ProbingPathsEnvVar", "DpaEnvVars", "RunProcessListenerAdapter", "DebuggerAttachProcessListenerAdapter", "DebuggerStartProcessListenerAdapter", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nDpaExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DpaExtension.kt\ncom/jetbrains/dpa/DpaExtension\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 StructuredLogging.kt\ncom/jetbrains/rd/platform/diagnostics/StructuredLoggingKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 TaskInterfaces.kt\ncom/jetbrains/rd/framework/TaskInterfacesKt\n+ 7 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 8 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,403:1\n13#2:404\n15#3:405\n84#3,3:406\n84#3,2:409\n86#3:427\n84#3,3:449\n84#3,3:452\n84#3,3:455\n144#4,5:411\n161#4,2:416\n150#4,9:418\n1863#5,2:428\n295#5,2:458\n295#5,2:460\n95#6:430\n96#6:438\n23#7,7:431\n30#7,9:440\n1#8:439\n*S KotlinDebug\n*F\n+ 1 DpaExtension.kt\ncom/jetbrains/dpa/DpaExtension\n*L\n297#1:404\n297#1:405\n78#1:406,3\n314#1:409,2\n314#1:427\n55#1:449,3\n62#1:452,3\n69#1:455,3\n315#1:411,5\n315#1:416,2\n315#1:418,9\n365#1:428,2\n213#1:458,2\n221#1:460,2\n391#1:430\n391#1:438\n391#1:431,7\n391#1:440,9\n391#1:439\n*E\n"})
public final class DpaExtension
implements PatchCommandLineExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final String dpaIsNotPreparedPrefix;
    @NotNull
    private final RpcTimeouts prepareCommandTimeouts;
    @NotNull
    private final Lazy<File> pathToRunner;
    @NotNull
    private final Lazy<File> pathToDpaDebugInjector;
    @NotNull
    private final Lazy<File> pathToDebuggerDebugInjector;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final Key<Boolean> IS_PROCESSED_KEY = new Key("DpaExtension_IS_PROCESSED_KEY");
    @NotNull
    private static final Key<ProtocolDotNetSession> MONITORING_MODEL_KEY = new Key("DpaExtension_MONITORING_MODEL_KEY");

    public DpaExtension(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.dpaIsNotPreparedPrefix = DpaBundle.INSTANCE.message("dpa.extentions.dpa.is.not.prepared.prefix", new Object[0]);
        this.prepareCommandTimeouts = new RpcTimeouts(3000L, 3000L);
        this.pathToRunner = LazyKt.lazy(() -> DpaExtension.pathToRunner$lambda$1(this));
        this.pathToDpaDebugInjector = LazyKt.lazy(() -> DpaExtension.pathToDpaDebugInjector$lambda$3(this));
        this.pathToDebuggerDebugInjector = LazyKt.lazy(() -> DpaExtension.pathToDebuggerDebugInjector$lambda$5(this));
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DpaExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    private final ProbingPathsEnvVar probingPathsEnvVar(Project project) {
        Logger $this$runAndLogException$iv = this.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            IProtocolHost iProtocolHost = ApplicationProtocolKt.getProtocolHost((Project)project);
            Object object = iProtocolHost instanceof IProtocolHostWithBackend ? (IProtocolHostWithBackend)iProtocolHost : null;
            if (object == null || (object = object.getResharperProcess()) == null || (object = object.getDotNetPluginsExtraDirs()) == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.get.plugin.extra.directories", new Object[0]));
            }
            Object paths = object;
            ProbingPathsEnvVar envVar = new ProbingPathsEnvVar("RIDER_PLUGIN_ADDITIONAL_PROBING_PATHS", (String)paths);
            this.logger.trace(envVar.getKey() + ":" + envVar.getValue());
            return envVar;
        }
        catch (Throwable throwable) {
            return (ProbingPathsEnvVar)LoggerKt.getOrLogException((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)), (Logger)$this$runAndLogException$iv);
        }
    }

    private final DpaEnvVars getDpaEnvVars(@NotNull Map<String, String> environment) {
        return new DpaEnvVars(environment.getOrDefault("JETBRAINS_DPA_MODE", ""), environment.getOrDefault("JETBRAINS_DPA_AGENT_ENABLE", ""), environment.getOrDefault("CORECLR_ENABLE_PROFILING", ""), environment.getOrDefault("COR_ENABLE_PROFILING", ""));
    }

    private final boolean disabledByUser(Project project) {
        return !DpaHost.Companion.getInstance(project).getEnabled();
    }

    @NotNull
    public Promise<WorkerRunInfo> patchDebugCommandLine(@NotNull Lifetime lifetime, @NotNull WorkerRunInfo workerRunInfo, @Nullable ProcessInfo processInfo, @NotNull Project project) {
        IOptPropertyView iOptPropertyView;
        Integer pid;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)workerRunInfo, (String)"workerRunInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DpaAvailabilityService.Companion.getAvailability() == IntegrationLevel.Disabled || this.disabledByUser(project)) {
            DpaStatistics.Companion.getInstance(project).dpaCancelled(RunType.Debug, DpaCancelReason.DpaDisabled);
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File file = (File)this.pathToDpaDebugInjector.getValue();
        if (file == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File dpaDebugInjector = file;
        File file2 = (File)this.pathToDebuggerDebugInjector.getValue();
        if (file2 == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File debuggerDebugInjector = file2;
        ProbingPathsEnvVar probingPathsEnvVar = this.probingPathsEnvVar(project);
        if (probingPathsEnvVar == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        ProbingPathsEnvVar probingPaths = probingPathsEnvVar;
        AsyncPromise promise = new AsyncPromise();
        SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(project);
        RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
        Map map = workerRunInfo.getCommandLine().getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        DpaEnvVars dpaEnvVars = this.getDpaEnvVars(map);
        LifetimeDefinition sessionLifetimeDefinition = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        ProcessInfo processInfo2 = processInfo;
        Integer n = pid = processInfo2 != null ? Integer.valueOf(processInfo2.getPid()) : null;
        if (pid == null) {
            String string = workerRunInfo.getCommandLine().getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
            request = new StartingProcessArgs(buildConfigurationId, true, string, new StartingEnvironmentVars(dpaEnvVars.getDpaMode(), dpaEnvVars.getDpaAgentEnable(), dpaEnvVars.getClrEnableProfiling(), dpaEnvVars.getEnableProfiling()));
            iOptPropertyView = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getProcessStarting().start(sessionLifetimeDefinition.getLifetime(), (Object)request).getResult();
        } else {
            request = new AttachProcessArgs(buildConfigurationId, true, false, pid.intValue(), workerRunInfo.getCommandLine().getExePath());
            iOptPropertyView = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getProcessAttach().start(sessionLifetimeDefinition.getLifetime(), (Object)request).getResult();
        }
        IOptPropertyView result = iOptPropertyView;
        SourceExKt.adviseOnce((ISource)((ISource)result), (Lifetime)lifetime, arg_0 -> DpaExtension.patchDebugCommandLine$lambda$14(workerRunInfo, pid, sessionLifetimeDefinition, promise, this, dpaDebugInjector, debuggerDebugInjector, project, probingPaths, arg_0));
        return (Promise)promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public ProcessListener patchRunCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull DotNetRuntime dotNetRuntime, @NotNull Project project) {
        CollectorSessionArgs collectorSessionArgs;
        Object $this$runAndLogException_u24lambda_u240$iv;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)dotNetRuntime, (String)"dotNetRuntime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DpaAvailabilityService.Companion.getAvailability() == IntegrationLevel.Disabled || this.disabledByUser(project)) {
            DpaStatistics.Companion.getInstance(project).dpaCancelled(RunType.Run, DpaCancelReason.DpaDisabled);
            return null;
        }
        if (Intrinsics.areEqual((Object)dotNetRuntime.getType(), (Object)MonoRuntimeType.INSTANCE)) {
            DpaStatistics.Companion.getInstance(project).dpaCancelled(RunType.Run, DpaCancelReason.Mono);
            return null;
        }
        SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(project);
        RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
        String string = commandLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        String exePath = string;
        LifetimeDefinition sessionLifetimeDefinition = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        Logger $this$runAndLogException$iv = this.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            void $this$doCalculation_u24default$iv;
            ProcessResult processResult;
            $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            Logger logger2 = this.logger;
            String key$iv = "getHandleFromBackend";
            Object message$iv = null;
            boolean $i$f$doCalculation = false;
            boolean hadException$iv = false;
            long startTime$iv = System.nanoTime();
            try {
                boolean bl3 = false;
                Map map = commandLine.getEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
                DpaEnvVars dpaEnvVars = this.getDpaEnvVars(map);
                StartingProcessArgs request = new StartingProcessArgs(buildConfigurationId, false, exePath, new StartingEnvironmentVars(dpaEnvVars.getDpaMode(), dpaEnvVars.getDpaAgentEnable(), dpaEnvVars.getClrEnableProfiling(), dpaEnvVars.getEnableProfiling()));
                processResult = (ProcessResult)this.sync(sessionLifetimeDefinition.getLifetime(), DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getProcessStarting(), request, this.prepareCommandTimeouts, arg_0 -> DpaExtension.patchRunCommandLine$lambda$17$lambda$16$lambda$15(sessionLifetimeDefinition, arg_0));
            }
            catch (Throwable t$iv) {
                try {
                    String eventKind$iv = t$iv instanceof ProcessCanceledException || t$iv instanceof CancellationException ? "Cancelled" : "Exception";
                    hadException$iv = true;
                    StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<" + eventKind$iv + "> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                    throw t$iv;
                }
                catch (Throwable throwable) {
                    if (!hadException$iv) {
                        StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                    }
                    throw throwable;
                }
            }
            StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)processResult);
        }
        catch (Throwable bl) {
            $this$runAndLogException_u24lambda_u240$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        ProcessResult prepareForRunResult = (ProcessResult)LoggerKt.getOrLogException((Object)$this$runAndLogException_u24lambda_u240$iv, (Logger)$this$runAndLogException$iv);
        if (prepareForRunResult == null) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
            return null;
        }
        if (prepareForRunResult.getSessionResult() == SessionResult.Success && (collectorSessionArgs = prepareForRunResult.getCollectorSessionArgs()) != null) {
            CharSequence bl2;
            File file = (File)this.pathToRunner.getValue();
            if (file == null) {
                return null;
            }
            File runner = file;
            ProbingPathsEnvVar probingPathsEnvVar = this.probingPathsEnvVar(project);
            if (probingPathsEnvVar == null) {
                return null;
            }
            ProbingPathsEnvVar probingPaths = probingPathsEnvVar;
            File workerLogDir = RiderDebugRunner.Companion.createLogSubDir(project, "DpaRunner", "JetBrains.DPA.Runner");
            ParametersList parametersList = new ParametersList();
            parametersList.add("--handle=" + prepareForRunResult.getHandle());
            parametersList.add("--backend-pid=" + prepareForRunResult.getPid());
            parametersList.add("--etw-collect-flags=" + UInt.toString-impl((int)collectorSessionArgs.getFlags-pVg5ArA()));
            parametersList.add("--detach-event-name=" + prepareForRunResult.getDetachEventName());
            if (collectorSessionArgs.getRefreshInterval() != null) {
                parametersList.add("--refresh-interval=" + collectorSessionArgs.getRefreshInterval());
            }
            if (!((bl2 = (CharSequence)collectorSessionArgs.getCounterProviders()) == null || bl2.length() == 0)) {
                parametersList.add("--counters=" + collectorSessionArgs.getCounterProviders());
            }
            if (!((bl2 = (CharSequence)collectorSessionArgs.getMetrics()) == null || bl2.length() == 0)) {
                parametersList.add("--metrics=" + collectorSessionArgs.getMetrics());
                if (collectorSessionArgs.getMaxTimeSeries() != null) {
                    parametersList.add("--max-time-series=" + collectorSessionArgs.getMaxTimeSeries());
                }
                if (collectorSessionArgs.getMaxHistograms() != null) {
                    parametersList.add("--max-histograms=" + collectorSessionArgs.getMaxHistograms());
                }
            }
            parametersList.add("--");
            parametersList.add(exePath);
            parametersList.addAll(commandLine.getParametersList().getParameters());
            GeneralCommandLine $this$patchRunCommandLine_u24lambda_u2419 = commandLine;
            boolean bl = false;
            $this$patchRunCommandLine_u24lambda_u2419.getParametersList().clearAll();
            $this$patchRunCommandLine_u24lambda_u2419.withExePath(runner.getAbsolutePath());
            List list = parametersList.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl4 = false;
                if ($this$patchRunCommandLine_u24lambda_u2419 instanceof RawCommandLine) {
                    RawCommandLine rawCommandLine = (RawCommandLine)$this$patchRunCommandLine_u24lambda_u2419;
                    Intrinsics.checkNotNull((Object)it);
                    rawCommandLine.addRawParameter(it);
                    continue;
                }
                $this$patchRunCommandLine_u24lambda_u2419.addParameter(it);
            }
            $this$patchRunCommandLine_u24lambda_u2419.withEnvironment("RESHARPER_HOST_LOG_DIR", workerLogDir.getAbsolutePath());
            $this$patchRunCommandLine_u24lambda_u2419.withEnvironment("RESHARPER_LOG_CONF", RiderEnvironment.INSTANCE.getLogBackendConf());
            $this$patchRunCommandLine_u24lambda_u2419.withEnvironment(probingPaths.getKey(), probingPaths.getValue());
        }
        return (ProcessListener)new RunProcessListenerAdapter(prepareForRunResult.getProcessListener(), (Function1<? super ProcessHandler, Unit>)((Function1)arg_0 -> DpaExtension.patchRunCommandLine$lambda$20(project, prepareForRunResult, arg_0)), (Function0<Unit>)((Function0)() -> DpaExtension.patchRunCommandLine$lambda$21(sessionLifetimeDefinition)));
    }

    /*
     * WARNING - void declaration
     */
    public final <TReq, TRes> TRes sync(@NotNull Lifetime lifetime, @NotNull RdCall<TReq, TRes> call, TReq request, @NotNull RpcTimeouts timeouts, @NotNull Function1<? super TRes, Unit> onSuccessAfterTimeout) {
        boolean bl;
        IRdTask task;
        block5: {
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)timeouts, (String)"timeouts");
            Intrinsics.checkNotNullParameter(onSuccessAfterTimeout, (String)"onSuccessAfterTimeout");
            IRdTask iRdTask = task = call.start(lifetime, request, (IScheduler)SynchronousScheduler.INSTANCE);
            long timeoutMs$iv = this.prepareCommandTimeouts.getErrorAwaitTimeMs();
            boolean $i$f$wait = false;
            SpinWait.Companion companion = SpinWait.Companion;
            Lifetime lifetime$iv$iv = Lifetime.Companion.getEternal();
            boolean $i$f$spinUntil = false;
            void var14_13 = this_$iv$iv;
            Duration duration = Duration.ofMillis(timeoutMs$iv);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(timeoutMs)");
            Duration duration$iv$iv$iv = duration;
            boolean $i$f$spinUntil2 = false;
            long start$iv$iv$iv = System.nanoTime();
            long spins$iv$iv$iv = 0L;
            while (true) {
                void $this$wait$iv;
                boolean bl2;
                boolean bl3 = false;
                boolean $this$wait_u24lambda_u241_u24lambda_u240$iv = bl2 = InterfacesKt.getHasValue((IOptPropertyView)$this$wait$iv.getResult());
                boolean bl4 = false;
                if (!$this$wait_u24lambda_u241_u24lambda_u240$iv) {
                    boolean bl5 = false;
                }
                if (bl2) break;
                if (!RLifetimeKt.isAlive((Lifetime)lifetime$iv$iv) || System.nanoTime() - start$iv$iv$iv > duration$iv$iv$iv.toNanos()) {
                    bl = false;
                    break block5;
                }
                long l = spins$iv$iv$iv;
                spins$iv$iv$iv = l + 1L;
                if (l < 100L) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(spins$iv$iv$iv / (long)100);
            }
            bl = true;
        }
        if (!bl) {
            SourceExKt.adviseOnce((ISource)((ISource)task.getResult()), (Lifetime)lifetime, arg_0 -> DpaExtension.sync$lambda$23(onSuccessAfterTimeout, arg_0));
            throw new TimeoutException("Sync execution of rpc `" + call + ".location` is timed out in " + timeouts.getErrorAwaitTimeMs() + " ms");
        }
        return (TRes)((RdTaskResult)InterfacesKt.getValueOrThrow((IOptPropertyView)task.getResult())).unwrap();
    }

    private static final File pathToRunner$lambda$1(DpaExtension this$0) {
        Object object;
        Logger $this$runAndLogException$iv = this$0.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(this$0.getClass(), "JetBrains.DPA.Runner.exe", this$0.logger);
            if (file == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.dpa.runner", new Object[0]));
            }
            object = Result.constructor-impl((Object)file);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private static final File pathToDpaDebugInjector$lambda$3(DpaExtension this$0) {
        Object object;
        Logger $this$runAndLogException$iv = this$0.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(this$0.getClass(), "JetBrains.DPA.DebugInjector.dll", this$0.logger);
            if (file == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.dpa.debug.injector", new Object[0]));
            }
            object = Result.constructor-impl((Object)file);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private static final File pathToDebuggerDebugInjector$lambda$5(DpaExtension this$0) {
        Object object;
        Logger $this$runAndLogException$iv = this$0.logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(this$0.getClass(), "JetBrains.Debugger.DebugInjector.dll", this$0.logger);
            if (file == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.debugger.debug.injector", new Object[0]));
            }
            object = Result.constructor-impl((Object)file);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private static final Unit patchDebugCommandLine$lambda$14$lambda$10(Project $project, RdTaskResult<ProcessResult> $it, ProcessHandler ph) {
        ph.putUserData(IS_PROCESSED_KEY, (Object)true);
        ph.putUserData(MONITORING_MODEL_KEY, MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)).getDotNetSessions().get((Object)((ProcessResult)((RdTaskResult.Success)$it).getValue()).getSessionId()));
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$14$lambda$11(LifetimeDefinition sessionLifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$14$lambda$12(Project $project, RdTaskResult<ProcessResult> $it, ProcessHandler ph) {
        ph.putUserData(IS_PROCESSED_KEY, (Object)true);
        ph.putUserData(MONITORING_MODEL_KEY, MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)).getDotNetSessions().get((Object)((ProcessResult)((RdTaskResult.Success)$it).getValue()).getSessionId()));
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$14$lambda$13(LifetimeDefinition sessionLifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$14(WorkerRunInfo $workerRunInfo, Integer $pid, LifetimeDefinition $sessionLifetimeDefinition, AsyncPromise $promise, DpaExtension this$0, File $dpaDebugInjector, File $debuggerDebugInjector, Project $project, ProbingPathsEnvVar $probingPaths, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RdTaskResult rdTaskResult = it;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            if (((ProcessResult)((RdTaskResult.Success)it).getValue()).getSessionResult() == SessionResult.Success) {
                String detachEventName;
                Object v3;
                String plugins;
                GeneralCommandLine $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249;
                block23: {
                    Object v1;
                    String param;
                    boolean $i$f$firstOrNull;
                    Iterable $this$firstOrNull$iv;
                    block22: {
                        GeneralCommandLine generalCommandLine;
                        $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249 = generalCommandLine = $workerRunInfo.getCommandLine();
                        boolean bl = false;
                        List list = $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
                        $this$firstOrNull$iv = list;
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            param = (String)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNull((Object)param);
                            if (!StringsKt.startsWith$default((String)param, (String)"--plugins", (boolean)false, (int)2, null)) continue;
                            v1 = element$iv;
                            break block22;
                        }
                        v1 = null;
                    }
                    plugins = v1;
                    if (plugins != null) {
                        $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().replaceOrAppend(plugins, plugins + ";" + $dpaDebugInjector.getAbsolutePath());
                    } else {
                        $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--plugins=" + $dpaDebugInjector.getAbsolutePath());
                    }
                    List list = $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
                    $this$firstOrNull$iv = list;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        param = (String)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)param);
                        if (!StringsKt.startsWith$default((String)param, (String)"--plugins", (boolean)false, (int)2, null)) continue;
                        v3 = element$iv;
                        break block23;
                    }
                    v3 = null;
                }
                plugins = v3;
                if (plugins != null) {
                    $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().replaceOrAppend(plugins, plugins + ";" + $debuggerDebugInjector.getAbsolutePath());
                } else {
                    $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--plugins=" + $debuggerDebugInjector.getAbsolutePath());
                }
                CollectorSessionArgs collectorSessionArgs = ((ProcessResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs();
                if (collectorSessionArgs != null) {
                    CharSequence $i$f$firstOrNull;
                    $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-flags=" + UInt.toString-impl((int)collectorSessionArgs.getFlags-pVg5ArA()));
                    if (collectorSessionArgs.getRefreshInterval() != null) {
                        $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-refresh-interval=" + collectorSessionArgs.getRefreshInterval());
                    }
                    if (!(($i$f$firstOrNull = (CharSequence)collectorSessionArgs.getCounterProviders()) == null || $i$f$firstOrNull.length() == 0)) {
                        $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-counters=" + collectorSessionArgs.getCounterProviders());
                    }
                    if (!(($i$f$firstOrNull = (CharSequence)collectorSessionArgs.getMetrics()) == null || $i$f$firstOrNull.length() == 0)) {
                        $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-metrics=" + collectorSessionArgs.getMetrics());
                        if (collectorSessionArgs.getMaxTimeSeries() != null) {
                            $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-max-time-series=" + collectorSessionArgs.getMaxTimeSeries());
                        }
                        if (collectorSessionArgs.getMaxHistograms() != null) {
                            $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-max-histograms=" + collectorSessionArgs.getMaxHistograms());
                        }
                    }
                }
                if (((ProcessResult)((RdTaskResult.Success)it).getValue()).getIgnoreProfiler()) {
                    $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-ignore-profiling");
                }
                if ((detachEventName = ((ProcessResult)((RdTaskResult.Success)it).getValue()).getDetachEventName()) != null) {
                    $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-detach-event-name=" + detachEventName);
                }
                if (((ProcessResult)((RdTaskResult.Success)it).getValue()).getHandle() != 0L) {
                    $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-backend-pid=" + ((ProcessResult)((RdTaskResult.Success)it).getValue()).getPid());
                    $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-handle=" + ((ProcessResult)((RdTaskResult.Success)it).getValue()).getHandle());
                }
                $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.getParametersList().add("--dpa-collector-mode=" + DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)).getCollectorMode().getValueOrNull());
                $this$patchDebugCommandLine_u24lambda_u2414_u24lambda_u249.withEnvironment($probingPaths.getKey(), $probingPaths.getValue());
            }
            ProcessAdapter listener = $pid == null ? (ProcessAdapter)new DebuggerStartProcessListenerAdapter($sessionLifetimeDefinition.getLifetime(), ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener(), (Function1<? super ProcessHandler, Unit>)((Function1)arg_0 -> DpaExtension.patchDebugCommandLine$lambda$14$lambda$10($project, it, arg_0)), (Function0<Unit>)((Function0)() -> DpaExtension.patchDebugCommandLine$lambda$14$lambda$11($sessionLifetimeDefinition))) : (ProcessAdapter)new DebuggerAttachProcessListenerAdapter($pid, ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener(), (Function1<? super ProcessHandler, Unit>)((Function1)arg_0 -> DpaExtension.patchDebugCommandLine$lambda$14$lambda$12($project, it, arg_0)), (Function0<Unit>)((Function0)() -> DpaExtension.patchDebugCommandLine$lambda$14$lambda$13($sessionLifetimeDefinition)));
            $workerRunInfo.addProcessListener((ProcessListener)listener);
            $promise.setResult((Object)$workerRunInfo);
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            this$0.logger.warn((Throwable)((RdTaskResult.Fault)it).getError());
            LifetimeDefinition.terminate$default((LifetimeDefinition)$sessionLifetimeDefinition, (boolean)false, (int)1, null);
            $promise.setResult((Object)$workerRunInfo);
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            this$0.logger.info("DPA prepare for debug was cancelled");
            LifetimeDefinition.terminate$default((LifetimeDefinition)$sessionLifetimeDefinition, (boolean)false, (int)1, null);
            $promise.setResult((Object)$workerRunInfo);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit patchRunCommandLine$lambda$17$lambda$16$lambda$15(LifetimeDefinition $sessionLifetimeDefinition, ProcessResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        com.jetbrains.rider.model.ProcessListener processListener = it.getProcessListener();
        if (processListener != null && (processListener = processListener.getProcessNotStarted()) != null) {
            processListener.fire((Object)Unit.INSTANCE);
        }
        LifetimeDefinition.terminate$default((LifetimeDefinition)$sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit patchRunCommandLine$lambda$20(Project $project, ProcessResult prepareForRunResult, ProcessHandler ph) {
        ph.putUserData(IS_PROCESSED_KEY, (Object)true);
        ph.putUserData(MONITORING_MODEL_KEY, MonitoringToolModel_PregeneratedKt.getMonitoringToolModel((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)).getDotNetSessions().get((Object)prepareForRunResult.getSessionId()));
        return Unit.INSTANCE;
    }

    private static final Unit patchRunCommandLine$lambda$21(LifetimeDefinition sessionLifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit sync$lambda$23(Function1 $onSuccessAfterTimeout, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof RdTaskResult.Success) {
            $onSuccessAfterTimeout.invoke(((RdTaskResult.Success)it).getValue());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/dpa/DpaExtension$Companion;", "", "<init>", "()V", "IS_PROCESSED_KEY", "Lcom/intellij/openapi/util/Key;", "", "getIS_PROCESSED_KEY", "()Lcom/intellij/openapi/util/Key;", "MONITORING_MODEL_KEY", "Lcom/jetbrains/rider/model/ProtocolDotNetSession;", "getMONITORING_MODEL_KEY", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getIS_PROCESSED_KEY() {
            return IS_PROCESSED_KEY;
        }

        @NotNull
        public final Key<ProtocolDotNetSession> getMONITORING_MODEL_KEY() {
            return MONITORING_MODEL_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DebuggerAttachProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "pid", "", "processListener", "Lcom/jetbrains/rider/model/ProcessListener;", "onStarted", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "", "onFinished", "Lkotlin/Function0;", "<init>", "(ILcom/jetbrains/rider/model/ProcessListener;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getPid", "()I", "getProcessListener", "()Lcom/jetbrains/rider/model/ProcessListener;", "getOnStarted", "()Lkotlin/jvm/functions/Function1;", "getOnFinished", "()Lkotlin/jvm/functions/Function0;", "processWillTerminate", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class DebuggerAttachProcessListenerAdapter
    extends ProcessAdapter {
        private final int pid;
        @NotNull
        private final com.jetbrains.rider.model.ProcessListener processListener;
        @NotNull
        private final Function1<ProcessHandler, Unit> onStarted;
        @NotNull
        private final Function0<Unit> onFinished;

        public DebuggerAttachProcessListenerAdapter(int pid, @NotNull com.jetbrains.rider.model.ProcessListener processListener, @NotNull Function1<? super ProcessHandler, Unit> onStarted, @NotNull Function0<Unit> onFinished) {
            Intrinsics.checkNotNullParameter((Object)processListener, (String)"processListener");
            Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
            Intrinsics.checkNotNullParameter(onFinished, (String)"onFinished");
            this.pid = pid;
            this.processListener = processListener;
            this.onStarted = onStarted;
            this.onFinished = onFinished;
        }

        public final int getPid() {
            return this.pid;
        }

        @NotNull
        public final com.jetbrains.rider.model.ProcessListener getProcessListener() {
            return this.processListener;
        }

        @NotNull
        public final Function1<ProcessHandler, Unit> getOnStarted() {
            return this.onStarted;
        }

        @NotNull
        public final Function0<Unit> getOnFinished() {
            return this.onFinished;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!willBeDestroyed) {
                this.onFinished.invoke();
            }
            this.processListener.getProcessWillTerminate().fire((Object)willBeDestroyed);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.onFinished.invoke();
            this.processListener.getProcessTerminated().fire((Object)event.getExitCode());
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getStartNotified().fire((Object)this.pid);
            ProcessHandler processHandler = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
            this.onStarted.invoke((Object)processHandler);
        }

        public void processNotStarted() {
            this.processListener.getProcessNotStarted().fire((Object)Unit.INSTANCE);
            this.onFinished.invoke();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DebuggerStartProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "processListener", "Lcom/jetbrains/rider/model/ProcessListener;", "onStarted", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "", "onFinished", "Lkotlin/Function0;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/ProcessListener;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProcessListener", "()Lcom/jetbrains/rider/model/ProcessListener;", "getOnStarted", "()Lkotlin/jvm/functions/Function1;", "getOnFinished", "()Lkotlin/jvm/functions/Function0;", "processWillTerminate", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class DebuggerStartProcessListenerAdapter
    extends ProcessAdapter {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final com.jetbrains.rider.model.ProcessListener processListener;
        @NotNull
        private final Function1<ProcessHandler, Unit> onStarted;
        @NotNull
        private final Function0<Unit> onFinished;

        public DebuggerStartProcessListenerAdapter(@NotNull Lifetime lifetime, @NotNull com.jetbrains.rider.model.ProcessListener processListener, @NotNull Function1<? super ProcessHandler, Unit> onStarted, @NotNull Function0<Unit> onFinished) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)processListener, (String)"processListener");
            Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
            Intrinsics.checkNotNullParameter(onFinished, (String)"onFinished");
            this.lifetime = lifetime;
            this.processListener = processListener;
            this.onStarted = onStarted;
            this.onFinished = onFinished;
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final com.jetbrains.rider.model.ProcessListener getProcessListener() {
            return this.processListener;
        }

        @NotNull
        public final Function1<ProcessHandler, Unit> getOnStarted() {
            return this.onStarted;
        }

        @NotNull
        public final Function0<Unit> getOnFinished() {
            return this.onFinished;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!willBeDestroyed) {
                this.onFinished.invoke();
            }
            this.processListener.getProcessWillTerminate().fire((Object)willBeDestroyed);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.onFinished.invoke();
            this.processListener.getProcessTerminated().fire((Object)event.getExitCode());
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ProcessHandler debuggerWorkerProcessHandler = event.getProcessHandler();
            if (debuggerWorkerProcessHandler instanceof DebuggerWorkerProcessHandler) {
                ((DebuggerWorkerProcessHandler)debuggerWorkerProcessHandler).getWorkerModel().getActiveSession().advise(this.lifetime, arg_0 -> DebuggerStartProcessListenerAdapter.startNotified$lambda$1(this, arg_0));
            }
            ProcessHandler processHandler = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
            this.onStarted.invoke((Object)processHandler);
        }

        public void processNotStarted() {
            this.processListener.getProcessNotStarted().fire((Object)Unit.INSTANCE);
            this.onFinished.invoke();
        }

        private static final Unit startNotified$lambda$1$lambda$0(DebuggerStartProcessListenerAdapter this$0, DebuggerSessionInfo debuggerSessionInfo) {
            Intrinsics.checkNotNullParameter((Object)debuggerSessionInfo, (String)"debuggerSessionInfo");
            if (debuggerSessionInfo.getProcessId() == -1) {
                return Unit.INSTANCE;
            }
            this$0.processListener.getStartNotified().fire((Object)debuggerSessionInfo.getProcessId());
            return Unit.INSTANCE;
        }

        private static final Unit startNotified$lambda$1(DebuggerStartProcessListenerAdapter this$0, DotNetDebuggerSessionModel it) {
            if (it == null) {
                return Unit.INSTANCE;
            }
            SourceExKt.adviseOnce((ISource)it.getTargetReady(), (Lifetime)this$0.lifetime, arg_0 -> DebuggerStartProcessListenerAdapter.startNotified$lambda$1$lambda$0(this$0, arg_0));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DpaEnvVars;", "", "dpaMode", "", "dpaAgentEnable", "clrEnableProfiling", "enableProfiling", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDpaMode", "()Ljava/lang/String;", "getDpaAgentEnable", "getClrEnableProfiling", "getEnableProfiling", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.dpa"})
    public static final class DpaEnvVars {
        @NotNull
        private final String dpaMode;
        @NotNull
        private final String dpaAgentEnable;
        @NotNull
        private final String clrEnableProfiling;
        @NotNull
        private final String enableProfiling;

        public DpaEnvVars(@NotNull String dpaMode, @NotNull String dpaAgentEnable, @NotNull String clrEnableProfiling, @NotNull String enableProfiling) {
            Intrinsics.checkNotNullParameter((Object)dpaMode, (String)"dpaMode");
            Intrinsics.checkNotNullParameter((Object)dpaAgentEnable, (String)"dpaAgentEnable");
            Intrinsics.checkNotNullParameter((Object)clrEnableProfiling, (String)"clrEnableProfiling");
            Intrinsics.checkNotNullParameter((Object)enableProfiling, (String)"enableProfiling");
            this.dpaMode = dpaMode;
            this.dpaAgentEnable = dpaAgentEnable;
            this.clrEnableProfiling = clrEnableProfiling;
            this.enableProfiling = enableProfiling;
        }

        @NotNull
        public final String getDpaMode() {
            return this.dpaMode;
        }

        @NotNull
        public final String getDpaAgentEnable() {
            return this.dpaAgentEnable;
        }

        @NotNull
        public final String getClrEnableProfiling() {
            return this.clrEnableProfiling;
        }

        @NotNull
        public final String getEnableProfiling() {
            return this.enableProfiling;
        }

        @NotNull
        public final String component1() {
            return this.dpaMode;
        }

        @NotNull
        public final String component2() {
            return this.dpaAgentEnable;
        }

        @NotNull
        public final String component3() {
            return this.clrEnableProfiling;
        }

        @NotNull
        public final String component4() {
            return this.enableProfiling;
        }

        @NotNull
        public final DpaEnvVars copy(@NotNull String dpaMode, @NotNull String dpaAgentEnable, @NotNull String clrEnableProfiling, @NotNull String enableProfiling) {
            Intrinsics.checkNotNullParameter((Object)dpaMode, (String)"dpaMode");
            Intrinsics.checkNotNullParameter((Object)dpaAgentEnable, (String)"dpaAgentEnable");
            Intrinsics.checkNotNullParameter((Object)clrEnableProfiling, (String)"clrEnableProfiling");
            Intrinsics.checkNotNullParameter((Object)enableProfiling, (String)"enableProfiling");
            return new DpaEnvVars(dpaMode, dpaAgentEnable, clrEnableProfiling, enableProfiling);
        }

        public static /* synthetic */ DpaEnvVars copy$default(DpaEnvVars dpaEnvVars, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = dpaEnvVars.dpaMode;
            }
            if ((n & 2) != 0) {
                string2 = dpaEnvVars.dpaAgentEnable;
            }
            if ((n & 4) != 0) {
                string3 = dpaEnvVars.clrEnableProfiling;
            }
            if ((n & 8) != 0) {
                string4 = dpaEnvVars.enableProfiling;
            }
            return dpaEnvVars.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "DpaEnvVars(dpaMode=" + this.dpaMode + ", dpaAgentEnable=" + this.dpaAgentEnable + ", clrEnableProfiling=" + this.clrEnableProfiling + ", enableProfiling=" + this.enableProfiling + ")";
        }

        public int hashCode() {
            int result = this.dpaMode.hashCode();
            result = result * 31 + this.dpaAgentEnable.hashCode();
            result = result * 31 + this.clrEnableProfiling.hashCode();
            result = result * 31 + this.enableProfiling.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DpaEnvVars)) {
                return false;
            }
            DpaEnvVars dpaEnvVars = (DpaEnvVars)other;
            if (!Intrinsics.areEqual((Object)this.dpaMode, (Object)dpaEnvVars.dpaMode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dpaAgentEnable, (Object)dpaEnvVars.dpaAgentEnable)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clrEnableProfiling, (Object)dpaEnvVars.clrEnableProfiling)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enableProfiling, (Object)dpaEnvVars.enableProfiling);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/dpa/DpaExtension$ProbingPathsEnvVar;", "", "key", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.dpa"})
    public static final class ProbingPathsEnvVar {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public ProbingPathsEnvVar(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final ProbingPathsEnvVar copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ProbingPathsEnvVar(key, value);
        }

        public static /* synthetic */ ProbingPathsEnvVar copy$default(ProbingPathsEnvVar probingPathsEnvVar, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = probingPathsEnvVar.key;
            }
            if ((n & 2) != 0) {
                string2 = probingPathsEnvVar.value;
            }
            return probingPathsEnvVar.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ProbingPathsEnvVar(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProbingPathsEnvVar)) {
                return false;
            }
            ProbingPathsEnvVar probingPathsEnvVar = (ProbingPathsEnvVar)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)probingPathsEnvVar.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)probingPathsEnvVar.value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/dpa/DpaExtension$RunProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessAdapter;", "processListener", "Lcom/jetbrains/rider/model/ProcessListener;", "onStarted", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "", "onFinished", "Lkotlin/Function0;", "<init>", "(Lcom/jetbrains/rider/model/ProcessListener;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getProcessListener", "()Lcom/jetbrains/rider/model/ProcessListener;", "getOnStarted", "()Lkotlin/jvm/functions/Function1;", "getOnFinished", "()Lkotlin/jvm/functions/Function0;", "processWillTerminate", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class RunProcessListenerAdapter
    extends ProcessAdapter {
        @NotNull
        private final com.jetbrains.rider.model.ProcessListener processListener;
        @NotNull
        private final Function1<ProcessHandler, Unit> onStarted;
        @NotNull
        private final Function0<Unit> onFinished;

        public RunProcessListenerAdapter(@NotNull com.jetbrains.rider.model.ProcessListener processListener, @NotNull Function1<? super ProcessHandler, Unit> onStarted, @NotNull Function0<Unit> onFinished) {
            Intrinsics.checkNotNullParameter((Object)processListener, (String)"processListener");
            Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
            Intrinsics.checkNotNullParameter(onFinished, (String)"onFinished");
            this.processListener = processListener;
            this.onStarted = onStarted;
            this.onFinished = onFinished;
        }

        @NotNull
        public final com.jetbrains.rider.model.ProcessListener getProcessListener() {
            return this.processListener;
        }

        @NotNull
        public final Function1<ProcessHandler, Unit> getOnStarted() {
            return this.onStarted;
        }

        @NotNull
        public final Function0<Unit> getOnFinished() {
            return this.onFinished;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!willBeDestroyed) {
                this.onFinished.invoke();
            }
            this.processListener.getProcessWillTerminate().fire((Object)willBeDestroyed);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.onFinished.invoke();
            this.processListener.getProcessTerminated().fire((Object)event.getExitCode());
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            IAsyncSignal iAsyncSignal = this.processListener.getStartNotified();
            ProcessHandler processHandler = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
            Integer n = ProcessHandlerUtilKt.getProcessId(processHandler);
            Intrinsics.checkNotNull((Object)n);
            iAsyncSignal.fire((Object)n);
            ProcessHandler processHandler2 = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"getProcessHandler(...)");
            this.onStarted.invoke((Object)processHandler2);
        }

        public void processNotStarted() {
            this.processListener.getProcessNotStarted().fire((Object)Unit.INSTANCE);
            this.onFinished.invoke();
        }
    }
}

