/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.navbar;

import com.intellij.ide.impl.dataRules.GetDataRule;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.psi.PsiFile;
import com.intellij.rider.features.navbar.backend.MemberNavBarItem;
import com.intellij.rider.navbar.EntityNavBarItem;
import com.intellij.rider.navbar.RiderNavbarMembersSupport;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.StructureTimestamp;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.fileStructure.FrontendFileStructureHost;
import com.jetbrains.rdclient.fileStructure.ProtocolStructureViewTreeElement;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/rider/navbar/RiderNavBarMemberItemDataRule;", "Lcom/intellij/ide/impl/dataRules/GetDataRule;", "<init>", "()V", "getData", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "lastNodeAtCaret", "Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "lastDocumentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getSymbolFromEditor", "Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItem;", "", "project", "Lcom/intellij/openapi/project/Project;", "shouldUsePreviousStructure", "", "documentId", "timestamp", "Lcom/jetbrains/rd/ide/model/StructureTimestamp;", "structure", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "intellij.rider.navbar.backend"})
public final class RiderNavBarMemberItemDataRule
implements GetDataRule {
    @Nullable
    private ProtocolStructureViewTreeElement lastNodeAtCaret;
    @Nullable
    private RdDocumentId lastDocumentId;

    @Nullable
    public Pointer<? extends NavBarItem> getData(@NotNull DataProvider dataProvider) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        if (!UISettings.Companion.getInstance().getShowMembersInNavigationBar()) {
            return null;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataProvider);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DefaultNavBarItem<Object> defaultNavBarItem = this.getSymbolFromEditor(project2, dataProvider);
        return defaultNavBarItem != null ? defaultNavBarItem.createPointer() : null;
    }

    private final DefaultNavBarItem<Object> getSymbolFromEditor(Project project, DataProvider dataProvider) {
        ProtocolStructureViewTreeElement nextChild;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataProvider);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile((Editor)editor2);
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getLanguage()) == null) {
            return null;
        }
        PsiFile language = psiFile2;
        if (RiderNavbarMembersSupport.INSTANCE.forLanguage((Language)language) == null) {
            return null;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document, (Project)project);
        if (documentSynchronizer == null) {
            return null;
        }
        Triple triple = (Triple)FrontendFileStructureHost.Companion.getInstance(project).getStructureTree().getValueOrNull();
        if (triple == null) {
            return null;
        }
        Triple triple2 = triple;
        ProtocolStructureViewTreeElement structure = (ProtocolStructureViewTreeElement)triple2.component2();
        StructureTimestamp timestamp = (StructureTimestamp)triple2.component3();
        RdDocumentId currentDocumentId = documentSynchronizer.getDocumentId();
        if (this.shouldUsePreviousStructure(currentDocumentId, timestamp, structure, documentSynchronizer)) {
            ProtocolStructureViewTreeElement nodeAtCaret = this.lastNodeAtCaret;
            if (nodeAtCaret == null) {
                return null;
            }
            return new MemberNavBarItem(project, nodeAtCaret, psiFile);
        }
        int lastOffset = editor2.getCaretModel().getCurrentCaret().getOffset();
        ProtocolStructureViewTreeElement current = structure;
        block0: do {
            nextChild = null;
            for (ProtocolStructureViewTreeElement child : current.getChildren()) {
                boolean isNodeWithEmptyRange;
                TextRange range = child.getMyFakePsiNode().getRange();
                boolean bl = isNodeWithEmptyRange = range != null && range.contains(lastOffset);
                if (!isNodeWithEmptyRange && (range != null || !(!(child.getChildren().length == 0)))) continue;
                nextChild = child;
                continue block0;
            }
        } while (nextChild != null);
        if (current.getProtocolTreeNode().getId() == 0) {
            VirtualFile parentVirtualFile = psiFile.getVirtualFile();
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)parentVirtualFile);
            ProjectModelEntity entity = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)parentVirtualFile, (Project)project));
            this.lastNodeAtCaret = null;
            if (entity != null) {
                return new EntityNavBarItem(project, entity);
            }
            return null;
        }
        this.lastNodeAtCaret = current;
        this.lastDocumentId = current.getDocumentId();
        return new MemberNavBarItem(project, current, psiFile);
    }

    private final boolean shouldUsePreviousStructure(RdDocumentId documentId, StructureTimestamp timestamp, ProtocolStructureViewTreeElement structure, DocumentSynchronizer documentSynchronizer) {
        boolean newStructureIsEmpty = structure.getChildren().length == 0;
        boolean previousStructureDocumentIdEqualsCurrentDocumentIdStructure = Intrinsics.areEqual((Object)this.lastDocumentId, (Object)documentId);
        StructureTimestamp structureTimestamp = timestamp;
        boolean newStructureDocumentIdEqualsCurrentDocumentIdStructure = Intrinsics.areEqual((Object)(structureTimestamp != null ? structureTimestamp.getDocumentId() : null), (Object)documentId);
        StructureTimestamp structureTimestamp2 = timestamp;
        boolean differentDocumentVersions = !Intrinsics.areEqual((Object)documentSynchronizer.getVersion(), (Object)(structureTimestamp2 != null ? structureTimestamp2.getVersion() : null));
        return previousStructureDocumentIdEqualsCurrentDocumentIdStructure && newStructureDocumentIdEqualsCurrentDocumentIdStructure && (newStructureIsEmpty || differentDocumentVersions);
    }
}

