/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.navbar;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.NavBarItemProvider;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItemKt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rider.features.navbar.backend.MemberNavBarItem;
import com.intellij.rider.navbar.EntityNavBarItem;
import com.intellij.rider.navbar.RiderNavbarMembersSupport;
import com.jetbrains.rdclient.fileStructure.FrontendFileStructureHost;
import com.jetbrains.rdclient.fileStructure.ProtocolStructureViewTreeElement;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.ExternalSourceService;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J2\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0016j\b\u0012\u0004\u0012\u00020\u0011`\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/rider/navbar/RiderNavBarItemProvider;", "Lcom/intellij/platform/navbar/backend/NavBarItemProvider;", "<init>", "()V", "findParent", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "item", "iterateChildren", "", "findPsiFile", "Lcom/intellij/psi/PsiFile;", "findPsiFileChildren", "", "psiFile", "collectChildrenIncludingNestedFiles", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "result", "", "collectAllChildrenAndThis", "set", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "onlyNestedFiles", "", "intellij.rider.navbar.backend"})
@SourceDebugExtension(value={"SMAP\nRiderNavBarItemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNavBarItemProvider.kt\ncom/intellij/rider/navbar/RiderNavBarItemProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n669#2,11:181\n1557#2:195\n1628#2,3:196\n774#2:200\n865#2,2:201\n669#2,11:203\n3829#3:192\n4344#3,2:193\n11158#3:214\n11493#3,3:215\n1#4:199\n*S KotlinDebug\n*F\n+ 1 RiderNavBarItemProvider.kt\ncom/intellij/rider/navbar/RiderNavBarItemProvider\n*L\n73#1:181,11\n91#1:195\n91#1:196,3\n102#1:200\n102#1:201,2\n127#1:203,11\n90#1:192\n90#1:193,2\n160#1:214\n160#1:215,3\n*E\n"})
public final class RiderNavBarItemProvider
implements NavBarItemProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public NavBarItem findParent(@NotNull NavBarItem item) {
        Object entity;
        Project project;
        Object data;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item instanceof DefaultNavBarItem && (data = ((DefaultNavBarItem)item).getData()) instanceof PsiFile) {
            PsiFile psiFile;
            Object object = ((DefaultNavBarItem)item).getData();
            PsiFile psiFile2 = psiFile = object instanceof PsiFile ? (PsiFile)object : null;
            if (psiFile != null) {
                VirtualFile parentDirFile;
                PsiDirectory psiDirectory = psiFile.getParent();
                Object object2 = parentDirFile = psiDirectory != null ? psiDirectory.getVirtualFile() : null;
                if (parentDirFile != null) {
                    Project project2 = ((PsiFile)data).getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    Project project3 = project2;
                    ProjectModelEntity entity2 = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project3), (VirtualFile)parentDirFile, (Project)project3));
                    if (entity2 != null) {
                        return (NavBarItem)new EntityNavBarItem(project3, entity2);
                    }
                }
            }
        }
        if (item instanceof MemberNavBarItem) {
            project = ((MemberNavBarItem)item).getProject();
            ProtocolStructureViewTreeElement parent = ((MemberNavBarItem)item).getNode().getParent();
            if (parent != null && parent.getProtocolTreeNode().getId() != 0) {
                return (NavBarItem)new MemberNavBarItem(project, parent, ((MemberNavBarItem)item).getFile());
            }
            VirtualFile parentVirtualFile = ((MemberNavBarItem)item).getFile().getVirtualFile();
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)parentVirtualFile);
            entity = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)parentVirtualFile, (Project)project));
            if (entity != null) {
                return (NavBarItem)new EntityNavBarItem(project, (ProjectModelEntity)entity);
            }
            VirtualFile virtualFile = ((MemberNavBarItem)item).getFile().getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            return DefaultNavBarItemKt.createDefaultNavBarItem((Project)project, (VirtualFile)virtualFile);
        }
        if (item instanceof EntityNavBarItem) {
            project = ((EntityNavBarItem)item).getProject();
            ProjectModelEntity projectModelEntity = ((EntityNavBarItem)item).getEntity();
            if (projectModelEntity == null) {
                return null;
            }
            ProjectModelEntity entity3 = projectModelEntity;
            ProjectModelEntity projectModelEntity2 = entity3.getParentEntity();
            if (projectModelEntity2 == null) {
                return null;
            }
            ProjectModelEntity parentEntity = projectModelEntity2;
            return (NavBarItem)new EntityNavBarItem(project, parentEntity);
        }
        if (item instanceof DefaultNavBarItem) {
            VirtualFile externalSourceDirectory;
            Object v12;
            PsiFile virtualFile;
            block18: {
                void $this$singleOrNull$iv;
                Object object = ((DefaultNavBarItem)item).getData();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
                Project project4 = ((PsiElement)object).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                project = project4;
                entity = ((DefaultNavBarItem)item).getData();
                Object object3 = entity instanceof PsiFile ? (PsiFile)entity : null;
                if (object3 == null || (object3 = object3.getVirtualFile()) == null) {
                    Object object4 = ((DefaultNavBarItem)item).getData();
                    PsiDirectory psiDirectory = object4 instanceof PsiDirectory ? (PsiDirectory)object4 : null;
                    object3 = psiDirectory != null ? psiDirectory.getVirtualFile() : null;
                    if (object3 == null) {
                        return null;
                    }
                }
                virtualFile = object3;
                entity = ExternalSourceService.Companion.getInstance(project).getExternalSourceDirectories();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (!VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)virtualFile, (boolean)true)) continue;
                    if (found$iv) {
                        v12 = null;
                        break block18;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v12 = !found$iv ? null : single$iv;
            }
            VirtualFile virtualFile2 = externalSourceDirectory = (VirtualFile)v12;
            if (virtualFile2 != null) {
                return DefaultNavBarItemKt.createDefaultNavBarItem((Project)project, (VirtualFile)virtualFile2);
            }
            VirtualFile virtualFile3 = virtualFile.getParent();
            if (virtualFile3 == null) {
                return null;
            }
            VirtualFile parentVirtualFile = virtualFile3;
            ProjectModelEntity entity4 = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)parentVirtualFile, (Project)project));
            if (entity4 != null) {
                return (NavBarItem)new EntityNavBarItem(project, entity4);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<NavBarItem> iterateChildren(@NotNull NavBarItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item instanceof MemberNavBarItem) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            if (!UISettings.Companion.getInstance().getShowMembersInNavigationBar()) {
                return CollectionsKt.emptyList();
            }
            ProtocolStructureViewTreeElement[] $this$filter$iv = ((MemberNavBarItem)item).getNode().getChildren();
            boolean $i$f$filter = false;
            ProtocolStructureViewTreeElement[] protocolStructureViewTreeElementArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (ProtocolStructureViewTreeElement element$iv$iv : $this$filterTo$iv$iv) {
                void it = element$iv$iv;
                boolean bl = false;
                if (!(0 <= it.getProtocolTreeNode().getOffset() && it.getProtocolTreeNode().getOffset() < it.getProtocolTreeNode().getEndOffset())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ProtocolStructureViewTreeElement element$iv$iv;
                element$iv$iv = (ProtocolStructureViewTreeElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new MemberNavBarItem(it.getProject(), (ProtocolStructureViewTreeElement)it, ((MemberNavBarItem)item).getFile()));
            }
            return (List)destination$iv$iv;
        }
        Map navbarItems = new LinkedHashMap();
        if (item instanceof EntityNavBarItem) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Project project = ((EntityNavBarItem)item).getProject();
            ProjectModelEntity projectModelEntity = ((EntityNavBarItem)item).getEntity();
            if (projectModelEntity == null) {
                return CollectionsKt.emptyList();
            }
            ProjectModelEntity entity = projectModelEntity;
            VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)entity);
            Object object = new ArrayList();
            List $this$iterateChildren_u24lambda_u243 = object;
            boolean $i$a$-apply-RiderNavBarItemProvider$iterateChildren$childEntities$22 = false;
            this.collectChildrenIncludingNestedFiles(entity, $this$iterateChildren_u24lambda_u243);
            object = (Iterable)object;
            boolean $i$f$filter = false;
            void $i$a$-apply-RiderNavBarItemProvider$iterateChildren$childEntities$22 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ProjectModelEntity it = (ProjectModelEntity)element$iv$iv;
                boolean bl = false;
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
                RdProjectFileDescriptor rdProjectFileDescriptor = rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? (RdProjectFileDescriptor)rdProjectModelItemDescriptor : null;
                String buildAction = rdProjectFileDescriptor != null ? rdProjectFileDescriptor.getBuildAction() : null;
                if (!(buildAction == null || !StringsKt.equals((String)buildAction, (String)"AdditionalFiles", (boolean)true))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List childEntities = (List)destination$iv$iv;
            for (ProjectModelEntity childEntity : childEntities) {
                VirtualFile childVirtualFile;
                if (ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)childEntity) == null) continue;
                navbarItems.put(childVirtualFile, new EntityNavBarItem(project, childEntity));
            }
            if (CollectionsKt.any((Iterable)childEntities) && virtualFile != null && !virtualFile.isDirectory()) {
                navbarItems.put(virtualFile, new EntityNavBarItem(project, entity));
            }
            if (virtualFile != null) {
                object = ArrayIteratorKt.iterator((Object[])virtualFile.getChildren());
                while (object.hasNext()) {
                    VirtualFile childVirtualFile = (VirtualFile)object.next();
                    if (navbarItems.containsKey(childVirtualFile)) continue;
                    if (childVirtualFile.isDirectory()) {
                        Object v3;
                        block15: {
                            void $this$singleOrNull$iv;
                            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
                            Intrinsics.checkNotNull((Object)childVirtualFile);
                            destination$iv$iv = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)childVirtualFile, (Project)project);
                            boolean $i$f$singleOrNull = false;
                            Object single$iv = null;
                            boolean found$iv = false;
                            for (Object element$iv : $this$singleOrNull$iv) {
                                ProjectModelEntity it = (ProjectModelEntity)element$iv;
                                boolean bl = false;
                                if (!ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)it)) continue;
                                if (found$iv) {
                                    v3 = null;
                                    break block15;
                                }
                                single$iv = element$iv;
                                found$iv = true;
                            }
                            v3 = !found$iv ? null : single$iv;
                        }
                        ProjectModelEntity childProjectEntity = v3;
                        if (childProjectEntity != null) {
                            navbarItems.put(childVirtualFile, new EntityNavBarItem(project, childProjectEntity));
                            continue;
                        }
                    }
                    Intrinsics.checkNotNull((Object)childVirtualFile);
                    NavBarItem childItem = DefaultNavBarItemKt.createDefaultNavBarItem((Project)project, (VirtualFile)childVirtualFile);
                    if (childItem == null) continue;
                    navbarItems.put(childVirtualFile, childItem);
                }
            }
        }
        return CollectionsKt.plus((Collection)CollectionsKt.toMutableList(navbarItems.values()), (Iterable)this.findPsiFileChildren(this.findPsiFile(item)));
    }

    private final PsiFile findPsiFile(NavBarItem item) {
        if (item instanceof EntityNavBarItem) {
            VirtualFile virtualFile;
            ProjectModelEntity projectModelEntity = ((EntityNavBarItem)item).getEntity();
            if (projectModelEntity == null) {
                return null;
            }
            ProjectModelEntity entity = projectModelEntity;
            VirtualFile virtualFile2 = virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)entity);
            return virtualFile2 != null ? VirtualFileUtil.findPsiFile((VirtualFile)virtualFile2, (Project)((EntityNavBarItem)item).getProject()) : null;
        }
        DefaultNavBarItem defaultNavBarItem = item instanceof DefaultNavBarItem ? (DefaultNavBarItem)item : null;
        Object object = defaultNavBarItem != null ? defaultNavBarItem.getData() : null;
        PsiFile scratchPsiFile = object instanceof PsiFile ? (PsiFile)object : null;
        return scratchPsiFile;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NavBarItem> findPsiFileChildren(PsiFile psiFile) {
        if (psiFile != null && RiderNavbarMembersSupport.INSTANCE.forLanguage(psiFile.getLanguage()) != null) {
            ProtocolStructureViewTreeElement structure;
            if (!UISettings.Companion.getInstance().getShowMembersInNavigationBar()) {
                return CollectionsKt.emptyList();
            }
            Project project = psiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Triple triple = (Triple)FrontendFileStructureHost.Companion.getInstance(project).getStructureTree().getValueOrNull();
            Object object = structure = triple != null ? (ProtocolStructureViewTreeElement)triple.getSecond() : null;
            if (structure != null) {
                void $this$mapTo$iv$iv;
                ProtocolStructureViewTreeElement[] $this$map$iv = structure.getChildren();
                boolean $i$f$map = false;
                ProtocolStructureViewTreeElement[] protocolStructureViewTreeElementArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Project project2 = psiFile.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    collection.add(new MemberNavBarItem(project2, (ProtocolStructureViewTreeElement)it, psiFile));
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    private final void collectChildrenIncludingNestedFiles(ProjectModelEntity entity, List<ProjectModelEntity> result) {
        for (ProjectModelEntity childrenEntity : entity.getChildrenEntities()) {
            result.add(childrenEntity);
            if (!ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)childrenEntity)) continue;
            this.collectChildrenIncludingNestedFiles(childrenEntity, result);
        }
    }

    private final void collectAllChildrenAndThis(ProjectModelEntity entity, HashSet<ProjectModelEntity> set, boolean onlyNestedFiles) {
        set.add(entity);
        if (!onlyNestedFiles || ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)entity)) {
            for (ProjectModelEntity child : entity.getChildrenEntities()) {
                this.collectAllChildrenAndThis(child, set, onlyNestedFiles);
            }
        }
    }

    static /* synthetic */ void collectAllChildrenAndThis$default(RiderNavBarItemProvider riderNavBarItemProvider, ProjectModelEntity projectModelEntity, HashSet hashSet, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        riderNavBarItemProvider.collectAllChildrenAndThis(projectModelEntity, hashSet, bl);
    }
}

