/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.navbar;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.jetbrains.rider.projectView.RiderOpenFileDescriptorKt;
import com.jetbrains.rider.projectView.utils.NavigationUtilKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J+\u0010\u001e\u001a\u0004\u0018\u0001H\u001f\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010 2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0\"H\u0016\u00a2\u0006\u0002\u0010#J3\u0010$\u001a\u00020\u0010\"\n\b\u0000\u0010\u001f*\u0004\u0018\u00010 2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u001f0\"2\b\u0010%\u001a\u0004\u0018\u0001H\u001fH\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lcom/intellij/rider/navbar/NavigatableProjectModelEntityReference;", "Lcom/intellij/psi/impl/FakePsiElement;", "Lcom/intellij/pom/Navigatable;", "entityReference", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;Lcom/intellij/openapi/project/Project;)V", "getEntityReference", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "getEntity", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "navigate", "", "requestFocus", "", "canNavigate", "canNavigateToSource", "getContainingFile", "Lcom/intellij/psi/PsiFile;", "getName", "", "setName", "Lcom/intellij/psi/PsiElement;", "name", "getParent", "", "getCopyableUserData", "T", "", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putCopyableUserData", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "getProject", "intellij.rider.navbar.backend"})
public class NavigatableProjectModelEntityReference
extends FakePsiElement
implements Navigatable {
    @NotNull
    private final ProjectModelEntityReference entityReference;
    @NotNull
    private final Project myProject;

    public NavigatableProjectModelEntityReference(@NotNull ProjectModelEntityReference entityReference, @NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)entityReference, (String)"entityReference");
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.entityReference = entityReference;
        this.myProject = myProject;
    }

    @NotNull
    public final ProjectModelEntityReference getEntityReference() {
        return this.entityReference;
    }

    @Nullable
    public final ProjectModelEntity getEntity() {
        return this.entityReference.getEntity(this.getProject());
    }

    public void navigate(boolean requestFocus) {
        ProjectModelEntity currentEntity = this.getEntity();
        if (currentEntity == null) {
            return;
        }
        Integer n = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)currentEntity, (Project)this.getProject());
        if (n == null) {
            return;
        }
        int entityId = n;
        if (!this.canNavigateToSource()) {
            return;
        }
        VirtualFileUrl virtualFileUrl = currentEntity.getUrl();
        if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
            return;
        }
        VirtualFileUrl virtualFile = virtualFileUrl;
        RiderOpenFileDescriptorKt.withProjectModelId((int)entityId, () -> NavigatableProjectModelEntityReference.navigate$lambda$0((VirtualFile)virtualFile, this, requestFocus));
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        ProjectModelEntity projectModelEntity = this.getEntity();
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)projectModelEntity) : false;
    }

    @Nullable
    public PsiFile getContainingFile() {
        return null;
    }

    @NotNull
    public String getName() {
        Object object = this.getEntity();
        if (object == null || (object = object.getName()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (PsiElement)this;
    }

    @Nullable
    public Void getParent() {
        return null;
    }

    @Nullable
    public <T> T getCopyableUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return null;
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    private static final Unit navigate$lambda$0(VirtualFile $virtualFile, NavigatableProjectModelEntityReference this$0, boolean $requestFocus) {
        NavigationUtilKt.navigate((VirtualFile)$virtualFile, (Project)this$0.getProject(), (boolean)$requestFocus);
        return Unit.INSTANCE;
    }
}

