/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.GeometryKt;
import org.jetbrains.letsPlot.core.plot.base.DataFrame;
import org.jetbrains.letsPlot.core.plot.base.data.TransformVar;
import org.jetbrains.letsPlot.core.plot.base.stat.Stats;
import org.jetbrains.letsPlot.core.plot.builder.sampling.method.SamplingUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005J\"\u0010\t\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\u0005J#\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/sampling/method/SamplingUtil;", "", "()V", "distinctGroups", "", "", "groupMapper", "Lkotlin/Function1;", "size", "groupCount", "readPoints", "", "Lkotlin/collections/IndexedValue;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "population", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame;", "readPoints$plot_builder", "readPolygon", "xVar", "Lorg/jetbrains/letsPlot/core/plot/base/DataFrame$Variable;", "variables", "", "data", "yVar", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nSamplingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamplingUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/SamplingUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,3:71\n1549#2:74\n1620#2,3:75\n766#2:78\n857#2,2:79\n*S KotlinDebug\n*F\n+ 1 SamplingUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/sampling/method/SamplingUtil\n*L\n18#1:70\n18#1:71,3\n22#1:74\n22#1:75,3\n64#1:78\n64#1:79,2\n*E\n"})
public final class SamplingUtil {
    @NotNull
    public static final SamplingUtil INSTANCE = new SamplingUtil();

    private SamplingUtil() {
    }

    /*
     * WARNING - void declaration
     */
    public final int groupCount(@NotNull Function1<? super Integer, Integer> groupMapper2, int size2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)groupMapper2.invoke((Object)((int)it))).intValue());
        }
        return ((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv))).size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> distinctGroups(@NotNull Function1<? super Integer, Integer> groupMapper2, int size2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)groupMapper2.invoke((Object)((int)it))).intValue());
        }
        return CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    @Nullable
    public final DataFrame.Variable xVar(@NotNull Set<DataFrame.Variable> variables) {
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        return variables.contains(Stats.INSTANCE.getX()) ? Stats.INSTANCE.getX() : (variables.contains(TransformVar.INSTANCE.getX()) ? TransformVar.INSTANCE.getX() : null);
    }

    @NotNull
    public final DataFrame.Variable xVar(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        DataFrame.Variable variable = this.xVar(data.variables());
        if (variable == null) {
            throw new IllegalStateException("Can't apply sampling: couldn't deduce the (X) variable.");
        }
        return variable;
    }

    @NotNull
    public final DataFrame.Variable yVar(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(Stats.INSTANCE.getY())) {
            return Stats.INSTANCE.getY();
        }
        if (data.has(TransformVar.INSTANCE.getY())) {
            return TransformVar.INSTANCE.getY();
        }
        throw new IllegalStateException("Can't apply sampling: couldn't deduce the (Y) variable.");
    }

    @NotNull
    public final List<IndexedValue<DoubleVector>> readPoints$plot_builder(@NotNull DataFrame population) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        DataFrame.Variable xVar = this.xVar(population);
        DataFrame.Variable yVar = this.yVar(population);
        return SequencesKt.toList((Sequence)SequencesKt.mapIndexed((Sequence)SequencesKt.zip((Sequence)CollectionsKt.asSequence((Iterable)population.get(xVar)), (Sequence)CollectionsKt.asSequence((Iterable)population.get(yVar))), (Function2)readPoints.1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<IndexedValue<DoubleVector>>> readPolygon(@NotNull DataFrame population) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Iterable $this$filter$iv = this.readPoints$plot_builder(population);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            if (!(it.getValue() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List points2 = (List)destination$iv$iv;
        return GeometryKt.splitRings(points2, readPolygon.1.INSTANCE);
    }
}

