/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.stat.QQStat;
import org.jetbrains.letsPlot.core.stat.GammaDistributionKt;
import org.jetbrains.letsPlot.core.stat.NormalDistributionKt;
import org.jetbrains.letsPlot.core.stat.TDistributionKt;
import org.jetbrains.letsPlot.core.stat.UniformDistributionKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0007\u001a\u00020\u0004J(\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J:\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStatUtil;", "", "()V", "getEstimatedQuantile", "", "sortedSeries", "", "p", "getQuantileFunction", "Lkotlin/Function1;", "distribution", "Lorg/jetbrains/letsPlot/core/plot/base/stat/QQStat$Distribution;", "distributionParameters", "lineByPoints", "xCoord", "Lkotlin/Pair;", "yCoord", "plot-base"})
@SourceDebugExtension(value={"SMAP\nQQStatUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QQStatUtil.kt\norg/jetbrains/letsPlot/core/plot/base/stat/QQStatUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class QQStatUtil {
    @NotNull
    public static final QQStatUtil INSTANCE = new QQStatUtil();

    private QQStatUtil() {
    }

    @NotNull
    public final Function1<Double, Double> getQuantileFunction(@NotNull QQStat.Distribution distribution, @NotNull List<Double> distributionParameters) {
        Function1<Double, Double> function1;
        Intrinsics.checkNotNullParameter((Object)((Object)distribution), (String)"distribution");
        Intrinsics.checkNotNullParameter(distributionParameters, (String)"distributionParameters");
        switch (WhenMappings.$EnumSwitchMapping$0[distribution.ordinal()]) {
            case 1: {
                Double d = (Double)CollectionsKt.getOrNull(distributionParameters, (int)0);
                double mean2 = d != null ? d : 0.0;
                Double d2 = (Double)CollectionsKt.getOrNull(distributionParameters, (int)1);
                double standardDeviation = d2 != null ? d2 : 1.0;
                function1 = NormalDistributionKt.normalQuantile(mean2, standardDeviation);
                break;
            }
            case 2: {
                Double d = (Double)CollectionsKt.getOrNull(distributionParameters, (int)0);
                double a2 = d != null ? d : 0.0;
                Double d3 = (Double)CollectionsKt.getOrNull(distributionParameters, (int)1);
                double b2 = d3 != null ? d3 : 1.0;
                function1 = UniformDistributionKt.uniformQuantile(a2, b2);
                break;
            }
            case 3: {
                Double d = (Double)CollectionsKt.getOrNull(distributionParameters, (int)0);
                function1 = TDistributionKt.tQuantile(d != null ? d : 1.0);
                break;
            }
            case 4: {
                Double d = (Double)CollectionsKt.getOrNull(distributionParameters, (int)0);
                double alpha = d != null ? d : 1.0;
                Double d4 = (Double)CollectionsKt.getOrNull(distributionParameters, (int)1);
                double beta = d4 != null ? d4 : 1.0;
                function1 = GammaDistributionKt.gammaQuantile(alpha, beta);
                break;
            }
            case 5: {
                Double d = (Double)CollectionsKt.getOrNull(distributionParameters, (int)0);
                double lambda = d != null ? d : 1.0;
                function1 = GammaDistributionKt.gammaQuantile(1.0, lambda);
                break;
            }
            case 6: {
                Double d = (Double)CollectionsKt.getOrNull(distributionParameters, (int)0);
                double k = d != null ? d : 1.0;
                function1 = GammaDistributionKt.gammaQuantile(k / 2.0, 0.5);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function1;
    }

    public final double getEstimatedQuantile(@NotNull List<Double> sortedSeries, double p) {
        Intrinsics.checkNotNullParameter(sortedSeries, (String)"sortedSeries");
        if (!CollectionsKt.any((Iterable)sortedSeries)) {
            boolean $i$a$-require-QQStatUtil$getEstimatedQuantile$32 = false;
            String $i$a$-require-QQStatUtil$getEstimatedQuantile$32 = sortedSeries + " should not be empty";
            throw new IllegalArgumentException($i$a$-require-QQStatUtil$getEstimatedQuantile$32.toString());
        }
        if (!(0.0 <= p ? p <= 1.0 : false)) {
            boolean $i$a$-require-QQStatUtil$getEstimatedQuantile$42 = false;
            String $i$a$-require-QQStatUtil$getEstimatedQuantile$42 = p + " should be in [0, 1]";
            throw new IllegalArgumentException($i$a$-require-QQStatUtil$getEstimatedQuantile$42.toString());
        }
        int n = sortedSeries.size();
        if (n == 1) {
            return ((Number)CollectionsKt.first(sortedSeries)).doubleValue();
        }
        if (p < 1.0 / (double)n) {
            return ((Number)sortedSeries.get(0)).doubleValue() + ((double)n + 1.0) / (3.0 * (double)n) * (((Number)sortedSeries.get(1)).doubleValue() - ((Number)sortedSeries.get(0)).doubleValue());
        }
        if (p > ((double)n - 1.0) / (double)n) {
            return ((Number)sortedSeries.get(n - 2)).doubleValue() + (2.0 * (double)n - 1.0) / (3.0 * (double)n) * (((Number)sortedSeries.get(n - 1)).doubleValue() - ((Number)sortedSeries.get(n - 2)).doubleValue());
        }
        double h = ((double)n + 0.3333333333333333) * p - 0.6666666666666666;
        int i = (int)Math.floor(h);
        int j = (int)Math.ceil(h);
        return ((Number)sortedSeries.get(i)).doubleValue() + (h - (double)i) * (((Number)sortedSeries.get(j)).doubleValue() - ((Number)sortedSeries.get(i)).doubleValue());
    }

    @NotNull
    public final Function1<Double, Double> lineByPoints(@NotNull Pair<Double, Double> xCoord, @NotNull Pair<Double, Double> yCoord) {
        Intrinsics.checkNotNullParameter(xCoord, (String)"xCoord");
        Intrinsics.checkNotNullParameter(yCoord, (String)"yCoord");
        if (!(!(((Number)xCoord.getSecond()).doubleValue() == ((Number)xCoord.getFirst()).doubleValue()))) {
            boolean bl = false;
            String string = "Should be " + ((Number)xCoord.getFirst()).doubleValue() + " != " + ((Number)xCoord.getSecond()).doubleValue();
            throw new IllegalArgumentException(string.toString());
        }
        double slope = (((Number)yCoord.getSecond()).doubleValue() - ((Number)yCoord.getFirst()).doubleValue()) / (((Number)xCoord.getSecond()).doubleValue() - ((Number)xCoord.getFirst()).doubleValue());
        double intercept = ((Number)yCoord.getFirst()).doubleValue() - slope * ((Number)xCoord.getFirst()).doubleValue();
        return (Function1)new Function1<Double, Double>(slope, intercept){
            final /* synthetic */ double $slope;
            final /* synthetic */ double $intercept;
            {
                this.$slope = $slope;
                this.$intercept = $intercept;
                super(1);
            }

            @NotNull
            public final Double invoke(double x2) {
                return this.$slope * x2 + this.$intercept;
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[QQStat.Distribution.values().length];
            try {
                nArray[QQStat.Distribution.NORM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QQStat.Distribution.UNIFORM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QQStat.Distribution.T.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QQStat.Distribution.GAMMA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QQStat.Distribution.EXP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[QQStat.Distribution.CHI2.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

