/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.bistro.residual;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.GgplotKt;
import org.jetbrains.letsPlot.bistro.common.Plot2dUtil;
import org.jetbrains.letsPlot.bistro.residual.Model;
import org.jetbrains.letsPlot.bistro.residual.ResidualUtil;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.geom.geomHLine;
import org.jetbrains.letsPlot.intern.DummyFeature;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.GenericAesMapping;
import org.jetbrains.letsPlot.intern.Plot;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.themes.ThemeKt;
import org.jetbrains.letsPlot.themes.theme;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u00b1\u0001\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0017\u001a\u00020\u0018\u0012\u0006\u0010\u0019\u001a\u00020\u0018\u0012\u0006\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010 \u001a\u00020!J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001c\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/letsPlot/bistro/residual/ResidualPlotBuilder;", "", "data", "", "x", "", "y", "method", "polynomialDegree", "", "span", "", "loessCriticalSize", "samplingSeed", "", "geom", "bins", "binWidth", "color", "size", "", "alpha", "colorBy", "showLegend", "", "hline", "marginal", "(Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Double;IJLjava/lang/String;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/String;ZZLjava/lang/String;)V", "myData", "", "Ljava/lang/Integer;", "Ljava/lang/Double;", "build", "Lorg/jetbrains/letsPlot/intern/Plot;", "getModel", "Lorg/jetbrains/letsPlot/bistro/residual/Model;", "layers", "Lorg/jetbrains/letsPlot/intern/Feature;", "scales", "Companion", "plot-api"})
public final class ResidualPlotBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String x;
    @NotNull
    private final String y;
    @Nullable
    private final String method;
    @Nullable
    private final Integer polynomialDegree;
    @Nullable
    private final Double span;
    private final int loessCriticalSize;
    private final long samplingSeed;
    @Nullable
    private final String geom;
    @Nullable
    private final Object bins;
    @Nullable
    private final Object binWidth;
    @Nullable
    private final String color;
    @Nullable
    private final Number size;
    @Nullable
    private final Number alpha;
    @Nullable
    private final String colorBy;
    private final boolean showLegend;
    private final boolean hline;
    @NotNull
    private final String marginal;
    @NotNull
    private final Map<String, List<Object>> myData;
    public static final int LOESS_CRITICAL_SIZE_DEF = 1000;
    public static final long SAMPLING_SEED_DEF = 37L;
    @NotNull
    public static final String DEF_GEOM = "point";
    @NotNull
    public static final String DEF_MARGINAL = "dens:r";
    @NotNull
    private static final Color HLINE_COLOR = Color.Companion.getMAGENTA();
    @NotNull
    public static final String HLINE_LINETYPE = "dashed";

    public ResidualPlotBuilder(@NotNull Map<?, ?> data, @NotNull String x2, @NotNull String y2, @Nullable String method, @Nullable Integer polynomialDegree, @Nullable Double span, int loessCriticalSize, long samplingSeed, @Nullable String geom2, @Nullable Object bins, @Nullable Object binWidth, @Nullable String color, @Nullable Number size2, @Nullable Number alpha, @Nullable String colorBy, boolean showLegend, boolean hline2, @NotNull String marginal) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)x2, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y2, (String)"y");
        Intrinsics.checkNotNullParameter((Object)marginal, (String)"marginal");
        this.x = x2;
        this.y = y2;
        this.method = method;
        this.polynomialDegree = polynomialDegree;
        this.span = span;
        this.loessCriticalSize = loessCriticalSize;
        this.samplingSeed = samplingSeed;
        this.geom = geom2;
        this.bins = bins;
        this.binWidth = binWidth;
        this.color = color;
        this.size = size2;
        this.alpha = alpha;
        this.colorBy = colorBy;
        this.showLegend = showLegend;
        this.hline = hline2;
        this.marginal = marginal;
        this.myData = ToSpecConvertersKt.asPlotData(data);
    }

    @NotNull
    public final Plot build() {
        Map<?, ?> statData = ResidualUtil.INSTANCE.appendResiduals(this.myData, this.x, this.y, this.colorBy, this.getModel(), this.loessCriticalSize, this.samplingSeed);
        Function1 mapping2 = (Function1)new Function1<GenericAesMapping, Unit>(this){
            final /* synthetic */ ResidualPlotBuilder this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull GenericAesMapping $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                $this$null.setX(ResidualPlotBuilder.access$getX$p(this.this$0));
                $this$null.setY("residual");
                if (ResidualPlotBuilder.access$getColorBy$p(this.this$0) != null) {
                    $this$null.setColor(ResidualPlotBuilder.access$getColorBy$p(this.this$0));
                    $this$null.setFill(ResidualPlotBuilder.access$getColorBy$p(this.this$0));
                }
            }
        };
        Map<String, Boolean> map2 = ThemeKt.elementBlank();
        Map map3 = ThemeKt.elementText$default(null, null, null, null, null, null, null, null, false, 511, null);
        Map map4 = ThemeKt.elementText$default(null, null, null, null, null, null, null, null, false, 511, null);
        Map map5 = ThemeKt.elementLine$default(null, null, null, false, 15, null);
        Map map6 = ThemeKt.elementLine$default(null, null, null, false, 15, null);
        Map map7 = ThemeKt.elementText$default(null, null, null, null, null, null, null, null, false, 511, null);
        Map map8 = ThemeKt.elementText$default(null, null, null, null, null, null, null, null, false, 511, null);
        theme themeOptions = new theme(null, null, null, null, null, map2, null, null, null, null, map4, map8, null, map3, map7, null, null, map6, null, null, null, null, null, map5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -8547361, -1, Short.MAX_VALUE, null);
        return GgplotKt.letsPlot(statData, (Function1<? super GenericAesMapping, Unit>)mapping2).plus(this.layers()).plus(this.scales()).plus(themeOptions);
    }

    private final Model getModel() {
        Integer n = this.polynomialDegree;
        Double d = this.span;
        return new Model(this.method != null ? Model.Method.Companion.safeValueOf(this.method) : Model.Companion.getMETHOD_DEF(), n != null ? n : 1, d != null ? d : 0.5);
    }

    private final Feature scales() {
        String scaleLabel = Intrinsics.areEqual((Object)this.method, (Object)"none") ? this.y : this.y + " residual";
        return LabsKt.ylab(scaleLabel);
    }

    private final Feature layers() {
        Pair<Pair<Integer, Integer>, Pair<Number, Number>> pair2 = Plot2dUtil.INSTANCE.getBinParams2d(this.myData, this.x, this.y, this.bins, this.binWidth);
        Pair bins2d = (Pair)pair2.component1();
        Pair binWidth2d = (Pair)pair2.component2();
        Feature layers2 = DummyFeature.INSTANCE;
        layers2 = layers2.plus(Plot2dUtil.INSTANCE.getGeom2dLayer(this.geom, (Pair<Integer, Integer>)bins2d, (Pair<? extends Number, ? extends Number>)binWidth2d, this.color, this.size, this.alpha, this.colorBy, this.showLegend));
        if (this.hline) {
            layers2 = layers2.plus(new geomHLine(null, null, null, false, null, null, null, null, null, 0, null, HLINE_COLOR, HLINE_LINETYPE, null, null, null, 58879, null));
        }
        if (!Intrinsics.areEqual((Object)this.marginal, (Object)"none")) {
            layers2 = layers2.plus(Plot2dUtil.INSTANCE.getMarginalLayers(this.marginal, (Pair<Integer, Integer>)bins2d, (Pair<? extends Number, ? extends Number>)binWidth2d, this.color, this.colorBy, this.showLegend));
        }
        return layers2;
    }

    public static final /* synthetic */ String access$getX$p(ResidualPlotBuilder $this) {
        return $this.x;
    }

    public static final /* synthetic */ String access$getColorBy$p(ResidualPlotBuilder $this) {
        return $this.colorBy;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/bistro/residual/ResidualPlotBuilder$Companion;", "", "()V", "DEF_GEOM", "", "DEF_MARGINAL", "HLINE_COLOR", "Lorg/jetbrains/letsPlot/commons/values/Color;", "getHLINE_COLOR", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "HLINE_LINETYPE", "LOESS_CRITICAL_SIZE_DEF", "", "SAMPLING_SEED_DEF", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Color getHLINE_COLOR() {
            return HLINE_COLOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

