/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.protobuf.lang.annotation.OptionOccurrenceTracker;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbSymbol;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.PbTextExtensionName;
import com.intellij.protobuf.lang.psi.PbTextMessage;
import com.intellij.protobuf.lang.psi.PbTextRootMessage;
import com.intellij.protobuf.lang.psi.PbTextSymbolPath;
import com.intellij.protobuf.lang.psi.ProtoSymbolPath;
import com.intellij.protobuf.lang.psi.ProtoSymbolPathDelegate;
import com.intellij.protobuf.lang.psi.impl.PbTextElementBase;
import com.intellij.protobuf.lang.resolve.PbSymbolLookupElement;
import com.intellij.protobuf.lang.resolve.PbSymbolResolver;
import com.intellij.protobuf.lang.resolve.PbTextMessageSetSupportingExtensionNameReference;
import com.intellij.protobuf.lang.resolve.ProtoSymbolPathReference;
import com.intellij.protobuf.lang.resolve.ResolveFilters;
import com.intellij.protobuf.lang.resolve.SchemaInfo;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PbTextExtensionNameMixin
extends PbTextElementBase
implements PbTextExtensionName {
    PbTextExtensionNameMixin(ASTNode node) {
        super(node);
    }

    private QualifiedName getRelativeScope(ProtoSymbolPath path) {
        if (!(this.getContainingFile() instanceof PbFile) || this.isAnyTypeUrl()) {
            return null;
        }
        PbTextMessage message = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)path, PbTextMessage.class);
        if (message == null) {
            return null;
        }
        PbMessageType declaredMessage = message.getDeclaredMessage();
        if (declaredMessage == null) {
            return null;
        }
        PbSymbolOwner owner = declaredMessage.getSymbolOwner();
        return owner != null ? owner.getChildScope() : null;
    }

    @Override
    @NotNull
    public ProtoSymbolPathDelegate getDefaultPathDelegate() {
        return new ProtoSymbolPathDelegate(){

            @Override
            @Nullable
            public PsiReference getReference(ProtoSymbolPath path) {
                QualifiedName scope = PbTextExtensionNameMixin.this.getRelativeScope(path);
                PbTextRootMessage rootMessage = PbTextExtensionNameMixin.this.getRootMessage();
                if (rootMessage == null) {
                    return null;
                }
                SchemaInfo schemaInfo = rootMessage.getSchemaInfo();
                if (schemaInfo == null) {
                    return null;
                }
                PbSymbolResolver resolver = schemaInfo.getExtensionResolver();
                PbTextMessage parentMessage = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)PbTextExtensionNameMixin.this, PbTextMessage.class);
                if (parentMessage == null) {
                    return null;
                }
                PbMessageType declaredMessage = parentMessage.getDeclaredMessage();
                if (declaredMessage == null) {
                    return null;
                }
                Condition<PbSymbol> filter = PbTextExtensionNameMixin.this.getDomain() == null ? PbTextExtensionNameMixin.getExtensionFilter(declaredMessage) : ResolveFilters.packageOrMessage();
                return new ProtoSymbolPathReference(path, resolver, scope, ResolveFilters.anySymbol(), ResolveFilters.withUnsuggestableFilter(filter), symbol -> PbSymbolLookupElement.withUnusableFieldHighlight(symbol, PbTextExtensionNameMixin.this.getOccurrence()));
            }
        };
    }

    private static Condition<PbSymbol> getExtensionFilter(PbMessageType declaredMessage) {
        Condition<PbSymbol> base = ResolveFilters.packageOrMessageWithExtension();
        return Conditions.or(base, ResolveFilters.extendedFromType(declaredMessage));
    }

    @Override
    @Nullable
    public PsiReference getEffectiveReference() {
        PbTextSymbolPath symbolPath = this.getSymbolPath();
        if (symbolPath == null) {
            return null;
        }
        PsiReference symbolPathRef = symbolPath.getReference();
        if (symbolPathRef == null) {
            return null;
        }
        return new PbTextMessageSetSupportingExtensionNameReference(symbolPathRef);
    }

    private OptionOccurrenceTracker.Occurrence getOccurrence() {
        PbTextMessage parent = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)this, PbTextMessage.class);
        if (parent == null) {
            return null;
        }
        OptionOccurrenceTracker tracker = OptionOccurrenceTracker.forMessage(parent);
        if (tracker == null) {
            return null;
        }
        return tracker.getOccurrence(parent);
    }
}

