/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.annotation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.NavigationItem;
import com.intellij.protobuf.ide.PbCompositeModificationTracker;
import com.intellij.protobuf.lang.PbLangBundle;
import com.intellij.protobuf.lang.annotation.AnyType;
import com.intellij.protobuf.lang.psi.PbAggregateValue;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.PbTextElement;
import com.intellij.protobuf.lang.psi.PbTextExtensionName;
import com.intellij.protobuf.lang.psi.PbTextField;
import com.intellij.protobuf.lang.psi.PbTextFieldName;
import com.intellij.protobuf.lang.psi.PbTextMessage;
import com.intellij.protobuf.lang.psi.PbTextRootMessage;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.util.PbPsiImplUtil;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionOccurrenceTracker {
    private final Occurrence root = new Occurrence(null, null, null);
    private final Multimap<PsiElement, Occurrence> elementOccurrences = ArrayListMultimap.create();

    private OptionOccurrenceTracker() {
    }

    public static OptionOccurrenceTracker forOptionOwner(PbOptionOwner owner) {
        return (OptionOccurrenceTracker)CachedValuesManager.getCachedValue((PsiElement)owner, () -> {
            OptionOccurrenceTracker tracker = new OptionOccurrenceTracker();
            tracker.addAllOccurrences(owner);
            return CachedValueProvider.Result.create((Object)tracker, (Object[])new Object[]{PbCompositeModificationTracker.byElement(owner)});
        });
    }

    @Nullable
    public static OptionOccurrenceTracker forMessage(PbTextMessage message) {
        return (OptionOccurrenceTracker)CachedValuesManager.getCachedValue((PsiElement)message, () -> CachedValueProvider.Result.create((Object)OptionOccurrenceTracker.computeForMessage(message), (Object[])new Object[]{PbCompositeModificationTracker.byElement(message)}));
    }

    private static OptionOccurrenceTracker computeForMessage(PbTextMessage message) {
        if (message instanceof PbTextRootMessage) {
            if (message.getContainingFile() instanceof PbFile) {
                PbOptionOwner owner = PbPsiImplUtil.getOptionOwner(message);
                if (owner == null) {
                    return null;
                }
                return OptionOccurrenceTracker.forOptionOwner(owner);
            }
            OptionOccurrenceTracker tracker = new OptionOccurrenceTracker();
            tracker.addAllOccurrences(message);
            return tracker;
        }
        if (OptionOccurrenceTracker.isAnyBody(message)) {
            OptionOccurrenceTracker tracker = new OptionOccurrenceTracker();
            tracker.addAllOccurrences(message);
            return tracker;
        }
        PbTextMessage parent = (PbTextMessage)PsiTreeUtil.getParentOfType((PsiElement)message, PbTextMessage.class);
        if (parent == null) {
            return null;
        }
        return OptionOccurrenceTracker.forMessage(parent);
    }

    private static boolean isAnyBody(PbTextMessage message) {
        PbTextField parentField = (PbTextField)PsiTreeUtil.getParentOfType((PsiElement)message, PbTextField.class);
        if (parentField == null) {
            return false;
        }
        PbTextExtensionName extensionName = parentField.getFieldName().getExtensionName();
        return extensionName != null && extensionName.isAnyTypeUrl();
    }

    @NotNull
    public Occurrence getRootOccurrence() {
        Occurrence occurrence = this.root;
        if (occurrence == null) {
            OptionOccurrenceTracker.$$$reportNull$$$0(0);
        }
        return occurrence;
    }

    @Nullable
    public Occurrence getOccurrence(PbOptionName name) {
        return this.elementOccurrences.get((Object)name).stream().findFirst().orElse(null);
    }

    @NotNull
    public Collection<Occurrence> getOccurrences(PbTextFieldName name) {
        Collection collection = this.elementOccurrences.get((Object)name);
        if (collection == null) {
            OptionOccurrenceTracker.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public Occurrence getOccurrence(PbTextMessage message) {
        return this.elementOccurrences.get((Object)message).stream().findFirst().orElse(null);
    }

    private void addAllOccurrences(PbOptionOwner optionOwner) {
        for (PbOptionExpression option : optionOwner.getOptions()) {
            PbAggregateValue aggregateValue;
            PbOptionName name = option.getOptionName();
            Occurrence occurrence = this.addName(name);
            if (occurrence == null || (aggregateValue = option.getAggregateValue()) == null) continue;
            this.addTextMessage(aggregateValue, occurrence);
        }
    }

    private void addAllOccurrences(PbTextMessage message) {
        this.addTextMessage(message, this.root);
    }

    private Occurrence addName(PbOptionName name) {
        return this.addName(name, false);
    }

    private Occurrence addName(PbOptionName name, boolean merge) {
        PbField field;
        Occurrence occurrence;
        PbOptionName qualifier = name.getQualifier();
        if (qualifier != null) {
            occurrence = this.addName(qualifier, true);
            if (occurrence == null) {
                return null;
            }
        } else {
            occurrence = this.root;
        }
        if ((field = OptionOccurrenceTracker.resolveField(name)) == null) {
            return null;
        }
        Occurrence nextOccurrence = merge ? occurrence.mergeOccurrence(field) : occurrence.addOccurrence(field);
        this.elementOccurrences.put((Object)name, (Object)nextOccurrence);
        return nextOccurrence;
    }

    private void addTextMessage(PbTextMessage message, Occurrence occurrence) {
        this.elementOccurrences.put((Object)message, (Object)occurrence);
        for (PbTextField field : message.getFields()) {
            PbTextFieldName fieldName = field.getFieldName();
            PbTextExtensionName extensionName = fieldName.getExtensionName();
            if (extensionName != null && extensionName.isAnyTypeUrl()) {
                AnyType type = AnyType.forElement(message.getDeclaredMessage());
                if (type == null) continue;
                this.elementOccurrences.put((Object)fieldName, (Object)occurrence.addOccurrence(type.getTypeUrlField()));
                this.elementOccurrences.put((Object)fieldName, (Object)occurrence.addOccurrence(type.getValueField()));
                continue;
            }
            PbField declaredField = fieldName.getDeclaredField();
            if (declaredField == null) continue;
            for (PbTextElement element : field.getValues()) {
                Occurrence nextOccurrence = occurrence.addOccurrence(declaredField);
                this.elementOccurrences.put((Object)fieldName, (Object)nextOccurrence);
                if (!(element instanceof PbTextMessage)) continue;
                this.addTextMessage((PbTextMessage)element, nextOccurrence);
            }
        }
    }

    private static PbField resolveField(PbOptionName name) {
        return PbPsiUtil.resolveRefToType(name.getEffectiveReference(), PbField.class);
    }

    private static PbMessageType getFieldType(PbField field) {
        PbTypeName typeName = field.getTypeName();
        if (typeName == null) {
            return null;
        }
        return PbPsiUtil.resolveRefToType(typeName.getEffectiveReference(), PbMessageType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/protobuf/lang/annotation/OptionOccurrenceTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootOccurrence";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccurrences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class Occurrence {
        private final Multimap<PbField, Occurrence> registeredFields = ArrayListMultimap.create();
        private final Map<PbOneofDefinition, PbField> registeredOneofFields = new HashMap<PbOneofDefinition, PbField>();
        private final PbField field;
        private final PsiElement annotationElement;
        private final Occurrence parent;

        private Occurrence(PbField field, PsiElement annotationElement, Occurrence parent) {
            this.field = field;
            this.annotationElement = annotationElement;
            this.parent = parent;
        }

        public void annotate(AnnotationHolder holder, PsiElement annotationElement) {
            Occurrence first = this.parent.firstOccurrence(this.field);
            if (first != null && !first.equals(this) && !this.field.isRepeated()) {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("non.repeated.field.specified.multiple.times", this.field.getName())).range(annotationElement).create();
            } else {
                PbField previousOneofField;
                PbOneofDefinition oneof = this.field.getOneof();
                PbField pbField = previousOneofField = oneof != null ? this.parent.registeredOneofFields.get(oneof) : null;
                if (previousOneofField != null && !previousOneofField.equals(this.field)) {
                    holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("multiple.oneof.fields.specified", this.field.getName(), previousOneofField.getName(), oneof.getName())).range(annotationElement).create();
                }
            }
            this.annotateMissingRequiredFields(holder, annotationElement);
        }

        public boolean canFieldBeUsed(PbField field) {
            PbOneofDefinition oneof = field.getOneof();
            if (oneof != null && this.registeredOneofFields.containsKey(oneof)) {
                return false;
            }
            return !this.registeredFields.containsKey((Object)field) || field.isRepeated();
        }

        public boolean canFieldBeUsedOrMerged(PbField field) {
            PbField oneofField;
            PbOneofDefinition oneof = field.getOneof();
            if (oneof != null && (oneofField = this.registeredOneofFields.get(oneof)) != null && !field.equals(oneofField)) {
                return false;
            }
            if (this.registeredFields.containsKey((Object)field) && !field.isRepeated()) {
                PbTypeName typeName = field.getTypeName();
                if (typeName == null) {
                    return false;
                }
                PbNamedTypeElement namedTypeElement = PbPsiUtil.resolveRefToType(typeName.getEffectiveReference(), PbNamedTypeElement.class);
                return namedTypeElement instanceof PbMessageType;
            }
            return true;
        }

        private Occurrence addOccurrence(PbField field) {
            PbOneofDefinition oneof = field.getOneof();
            if (oneof != null && !this.registeredOneofFields.containsKey(oneof)) {
                this.registeredOneofFields.put(oneof, field);
            }
            Occurrence occurrence = new Occurrence(field, this.annotationElement, this);
            this.registeredFields.put((Object)field, (Object)occurrence);
            return occurrence;
        }

        private Occurrence mergeOccurrence(PbField field) {
            Occurrence occurrence = this.firstOccurrence(field);
            if (occurrence != null) {
                return occurrence;
            }
            return this.addOccurrence(field);
        }

        private void annotateMissingRequiredFields(AnnotationHolder holder, PsiElement annotationElement) {
            PbMessageType message = OptionOccurrenceTracker.getFieldType(this.field);
            if (message == null) {
                return;
            }
            List missingFieldNames = message.getSymbols(PbField.class).stream().filter(f -> f.isRequired() && !this.registeredFields.containsKey(f)).map(NavigationItem::getName).collect(Collectors.toList());
            if (!missingFieldNames.isEmpty()) {
                holder.newAnnotation(HighlightSeverity.ERROR, PbLangBundle.message("missing.required.fields", message.getName(), String.join((CharSequence)", ", missingFieldNames))).range(annotationElement).create();
            }
        }

        private Occurrence firstOccurrence(PbField field) {
            return this.registeredFields.get((Object)field).stream().findFirst().orElse(null);
        }
    }
}

