/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.unreal.toolWindow;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.InvalidExpressionException;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u001c\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/cpp/unreal/toolWindow/FileRegexpMultiFilter;", "Lcom/intellij/execution/filters/Filter;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "expression", "", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myPattern", "Ljava/util/regex/Pattern;", "myHasLine", "", "myHasColumn", "substituteMacrosWithRegexps", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "createOpenFileHyperlink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "fileName", "column", "Companion", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nFileRegexpMultiFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileRegexpMultiFilter.kt\ncom/jetbrains/rider/cpp/unreal/toolWindow/FileRegexpMultiFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n1755#2,3:125\n1#3:128\n15#4:129\n*S KotlinDebug\n*F\n+ 1 FileRegexpMultiFilter.kt\ncom/jetbrains/rider/cpp/unreal/toolWindow/FileRegexpMultiFilter\n*L\n80#1:125,3\n34#1:129\n*E\n"})
public final class FileRegexpMultiFilter
implements Filter,
DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Pattern myPattern;
    private boolean myHasLine;
    private boolean myHasColumn;
    @NotNull
    public static final String FILE_PATH_MACROS = "$FILE_PATH$";
    @NotNull
    public static final String LINE_MACROS = "$LINE$";
    @NotNull
    public static final String COLUMN_MACROS = "$COLUMN$";
    @NotNull
    private static final String FILE_PATH_REGEXP = "(^|[\\W])(?<file>(?:\\p{Alpha}\\:|/)[0-9 a-z_A-Z\\-\\\\./]+)";
    @NotNull
    private static final String LINE_REGEXP = "(?<line>[0-9]+)";
    @NotNull
    private static final String COLUMN_REGEXP = "(?<column>[0-9]+)";
    @NotNull
    private static final String FILE_STR = "file";
    @NotNull
    private static final String LINE_STR = "line";
    @NotNull
    private static final String COLUMN_STR = "column";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Set<String> setOfExcludedExtensions;

    public FileRegexpMultiFilter(@NotNull Project project, @NotNull String expression) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.project = project;
        if (StringUtil.isEmptyOrSpaces((String)expression)) {
            throw new InvalidExpressionException("expression is empty");
        }
        String convertedExpression = this.substituteMacrosWithRegexps(expression);
        this.myPattern = Pattern.compile(convertedExpression, 8);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final String substituteMacrosWithRegexps(String expression) {
        String result = expression;
        int filePathIndex = StringsKt.indexOf$default((CharSequence)result, (String)FILE_PATH_MACROS, (int)0, (boolean)false, (int)6, null);
        int lineIndex = StringsKt.indexOf$default((CharSequence)result, (String)LINE_MACROS, (int)0, (boolean)false, (int)6, null);
        int columnIndex = StringsKt.indexOf$default((CharSequence)result, (String)COLUMN_MACROS, (int)0, (boolean)false, (int)6, null);
        if (filePathIndex == -1) {
            throw new InvalidExpressionException("Expression must contain $FILE_PATH$ macros.");
        }
        result = StringUtil.replace((String)result, (String)FILE_PATH_MACROS, (String)FILE_PATH_REGEXP);
        if (lineIndex != -1) {
            result = StringUtil.replace((String)result, (String)LINE_MACROS, (String)LINE_REGEXP);
            this.myHasLine = true;
        }
        if (columnIndex != -1) {
            result = StringUtil.replace((String)result, (String)COLUMN_MACROS, (String)COLUMN_REGEXP);
            this.myHasColumn = true;
        }
        return result;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)LINE_STR);
        List result = new ArrayList();
        Matcher matcher = this.myPattern.matcher(StringUtil.newBombedCharSequence((CharSequence)line, (long)100L));
        try {
            while (matcher.find()) {
                String string;
                String lineString;
                boolean bl;
                String filePath;
                block15: {
                    String string2 = matcher.group(FILE_STR);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                    filePath = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                    Iterable $this$any$iv = setOfExcludedExtensions;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.endsWith((String)filePath, (String)it, (boolean)true)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (bl) continue;
                if (this.myHasLine) {
                    String string3 = matcher.group(LINE_STR);
                    v3 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                } else {
                    v3 = lineString = "0";
                }
                if (this.myHasColumn) {
                    String string4 = matcher.group(COLUMN_STR);
                    string = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(...)");
                } else {
                    string = "0";
                }
                String columnString = string;
                int lineNumber = 0;
                int columnNumber = 0;
                try {
                    lineNumber = Integer.parseInt(lineString);
                    if (lineNumber > 0) {
                        --lineNumber;
                    }
                    if ((columnNumber = Integer.parseInt(columnString)) > 0) {
                        --columnNumber;
                    }
                }
                catch (NumberFormatException it) {
                    // empty catch block
                }
                int highlightStartOffset = entireLength - line.length() + matcher.start(FILE_STR);
                int highlightEndOffset = highlightStartOffset + filePath.length();
                HyperlinkInfo info = this.createOpenFileHyperlink(filePath, lineNumber, columnNumber);
                if (info == null) continue;
                result.add(new Filter.Result(highlightStartOffset, highlightEndOffset, info));
            }
        }
        catch (ProcessCanceledException e) {
            logger.warn("Too long matching '" + line + "' by '" + this.myPattern + "' in " + this.getClass().getName());
        }
        if (result.isEmpty()) {
            return null;
        }
        return new Filter.Result(result);
    }

    private final HyperlinkInfo createOpenFileHyperlink(String fileName, int line, int column) {
        OpenFileHyperlinkInfo openFileHyperlinkInfo;
        VirtualFile file;
        String normalizedFileName = StringsKt.replace$default((String)fileName, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        VirtualFile virtualFile = file = LocalFileSystem.getInstance().findFileByPathIfCached(normalizedFileName);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            openFileHyperlinkInfo = new OpenFileHyperlinkInfo(this.project, it, line, column);
        } else {
            openFileHyperlinkInfo = null;
        }
        return (HyperlinkInfo)openFileHyperlinkInfo;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileRegexpMultiFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FileRegexpMultiFilter.logger = logger;
        Object[] objectArray = new String[]{".exe", ".dll"};
        setOfExcludedExtensions = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/cpp/unreal/toolWindow/FileRegexpMultiFilter$Companion;", "", "<init>", "()V", "FILE_PATH_MACROS", "", "Lorg/jetbrains/annotations/NonNls;", "LINE_MACROS", "COLUMN_MACROS", "FILE_PATH_REGEXP", "LINE_REGEXP", "COLUMN_REGEXP", "FILE_STR", "LINE_STR", "COLUMN_STR", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "setOfExcludedExtensions", "", "intellij.rider.plugins.cpp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

