/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.run.configurations.rdjson;

import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfiguration;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfigurationParameters;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfigurationViewModel;
import com.jetbrains.rider.cpp.run.configurations.rdjson.RdJsonConfigurationParameters;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.model.RunnableProjectKind;
import com.jetbrains.rider.model.RunnableProjectsModel;
import com.jetbrains.rider.projectView.SolutionConfigurationManager;
import com.jetbrains.rider.run.configurations.ProjectExKt;
import com.jetbrains.rider.run.configurations.controls.AnchoredPanel;
import com.jetbrains.rider.run.configurations.controls.ControlViewBuilder;
import com.jetbrains.rider.run.configurations.controls.RunConfigurationViewModelBase;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/cpp/run/configurations/rdjson/RdJsonConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "runnableProjectKind", "Lcom/jetbrains/rider/model/RunnableProjectKind;", "runConfigId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/RunnableProjectKind;Ljava/lang/String;)V", "viewModel", "Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationViewModel;", "getViewModel", "()Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationViewModel;", "setViewModel", "(Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationViewModel;)V", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "editorLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "disposeEditor", "", "resetEditorFrom", "configuration", "applyEditorTo", "createEditor", "Ljavax/swing/JComponent;", "intellij.rider.plugins.cpp"})
public final class RdJsonConfigurationEditor
extends SettingsEditor<CppProjectConfiguration> {
    @NotNull
    private final Project project;
    @NotNull
    private final RunnableProjectKind runnableProjectKind;
    @NotNull
    private final String runConfigId;
    public CppProjectConfigurationViewModel viewModel;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final SequentialLifetimes editorLifetime;

    public RdJsonConfigurationEditor(@NotNull Project project, @NotNull RunnableProjectKind runnableProjectKind, @NotNull String runConfigId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)runnableProjectKind, (String)"runnableProjectKind");
        Intrinsics.checkNotNullParameter((Object)runConfigId, (String)"runConfigId");
        this.project = project;
        this.runnableProjectKind = runnableProjectKind;
        this.runConfigId = runConfigId;
        this.lifetimeDefinition = Lifetime.Companion.getEternal().createNested();
        this.editorLifetime = new SequentialLifetimes(this.lifetimeDefinition.getLifetime());
    }

    @NotNull
    public final CppProjectConfigurationViewModel getViewModel() {
        CppProjectConfigurationViewModel cppProjectConfigurationViewModel = this.viewModel;
        if (cppProjectConfigurationViewModel != null) {
            return cppProjectConfigurationViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        return null;
    }

    public final void setViewModel(@NotNull CppProjectConfigurationViewModel cppProjectConfigurationViewModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)cppProjectConfigurationViewModel), (String)"<set-?>");
        this.viewModel = cppProjectConfigurationViewModel;
    }

    protected void disposeEditor() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        super.disposeEditor();
    }

    protected void resetEditorFrom(@NotNull CppProjectConfiguration configuration) {
        RdJsonConfigurationParameters rdJsonConfigurationParameters;
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        CppProjectConfigurationParameters parameters = configuration.getParameters();
        RdJsonConfigurationParameters $this$resetEditorFrom_u24lambda_u240 = rdJsonConfigurationParameters = new RdJsonConfigurationParameters(parameters.getProjectKind(), parameters.getDefaultTerminalInteractionBehavior());
        boolean bl = false;
        $this$resetEditorFrom_u24lambda_u240.setProjectFilePath(parameters.getProjectFilePath());
        $this$resetEditorFrom_u24lambda_u240.getParametersMap().reset(parameters.getParametersMap());
        RdJsonConfigurationParameters clone = rdJsonConfigurationParameters;
        this.getViewModel().reset(clone);
    }

    protected void applyEditorTo(@NotNull CppProjectConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        RunnableProject selectedProject = (RunnableProject)this.getViewModel().getProjectSelector().getProject().getValueOrNull();
        if (selectedProject != null) {
            configuration.setProjectFilePath(selectedProject.getProjectFilePath());
            configuration.getParameters().getParametersMap().reset(this.getViewModel().getEditableConfiguration());
        }
    }

    @NotNull
    public JComponent createEditor() {
        LifetimeDefinition lifetime = this.editorLifetime.next();
        SolutionConfigurationManager configurationManager = SolutionConfigurationManager.Companion.tryGetInstance(this.project);
        Lifetime lifetime2 = (Lifetime)lifetime;
        RunnableProjectsModel runnableProjectsModel = ProjectExKt.getRunnableProjectsModelIfAvailable((Project)this.project);
        SolutionConfigurationManager solutionConfigurationManager = configurationManager;
        Object object = solutionConfigurationManager != null ? solutionConfigurationManager.getActiveConfigurationAndPlatform() : null;
        SolutionConfigurationManager solutionConfigurationManager2 = configurationManager;
        List list = solutionConfigurationManager2 != null ? solutionConfigurationManager2.getSolutionConfigurationsAndPlatforms() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.setViewModel(new CppProjectConfigurationViewModel(this.project, lifetime2, runnableProjectsModel, (RdConfigurationAndPlatform)object, list, this.runnableProjectKind));
        AnchoredPanel editor = new ControlViewBuilder((Lifetime)lifetime, this.project, this.runConfigId).build((RunConfigurationViewModelBase)this.getViewModel());
        int minWidth = editor.getMinimumSize().width;
        JPanel gap = new JPanel();
        gap.setMinimumSize(new Dimension(minWidth, 0));
        gap.setPreferredSize(new Dimension(0, 0));
        editor.add((Component)gap);
        IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null).allowPumpProtocolForComponent((Component)editor, LifetimeDisposableExKt.createNestedDisposable((Lifetime)((Lifetime)lifetime), (String)"RdJsonConfigurationEditor"));
        return (JComponent)editor;
    }
}

