/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.run.configurations;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfiguration;
import com.jetbrains.rider.cpp.run.configurations.CppProjectConfigurationType;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.run.configurations.ConfigurationContextExKt;
import com.jetbrains.rider.run.configurations.RiderProjectConfigurationProducerBase;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfigurationProducer;", "Lcom/jetbrains/rider/run/configurations/RiderProjectConfigurationProducerBase;", "Lcom/jetbrains/rider/cpp/run/configurations/CppProjectConfiguration;", "<init>", "()V", "isConfigurationFromContext", "", "configurationConfiguration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "trySetupConfigurationFromRunnableProject", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "configuration", "selectedProjectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "intellij.rider.plugins.cpp"})
public final class CppProjectConfigurationProducer
extends RiderProjectConfigurationProducerBase<CppProjectConfiguration> {
    public CppProjectConfigurationProducer() {
        super(CppProjectConfigurationType.class);
    }

    public boolean isConfigurationFromContext(@NotNull CppProjectConfiguration configurationConfiguration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configurationConfiguration), (String)"configurationConfiguration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ProjectModelEntity projectModelEntity = ConfigurationContextExKt.getSelectedProject((ConfigurationContext)context);
        if (projectModelEntity == null) {
            return false;
        }
        ProjectModelEntity item = projectModelEntity;
        Object object = ProjectModelEntityExtensionsKt.getFile((ProjectModelEntity)item);
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        return Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)object), (Object)configurationConfiguration.getParameters().getProjectFilePath());
    }

    protected boolean trySetupConfigurationFromRunnableProject(@NotNull RunnableProject runnableProject, @NotNull CppProjectConfiguration configuration, @NotNull ProjectModelEntity selectedProjectEntity) {
        Intrinsics.checkNotNullParameter((Object)runnableProject, (String)"runnableProject");
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)selectedProjectEntity, (String)"selectedProjectEntity");
        if (!CppProjectConfigurationType.Companion.isTypeApplicable(runnableProject.getKind()) || !StringsKt.endsWith((String)runnableProject.getProjectFilePath(), (String)".vcxproj", (boolean)true)) {
            return false;
        }
        configuration.setName(runnableProject.getFullName());
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CppProjectConfigurationType.Companion.setupFromProject(project, configuration, runnableProject);
        return true;
    }
}

