/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver;

import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.mixedmode.XMixedModeUtilsKt;
import com.intellij.xdebugger.impl.util.XDebugSessionUtilsKt;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoNativeDebugProcess;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MixedModeLLDBDataStore;
import com.jetbrains.rider.cpp.debugger.mixedMode.mono.driver.MonoMixedMonoLLDBDriver;
import java.util.concurrent.Semaphore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010 \u001a\u00020!2\u0006\u0010\f\u001a\u00020!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020#J\u0006\u0010'\u001a\u00020#J\u001f\u0010(\u001a\u0002H)\"\u0004\b\u0000\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0+\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020#J\u000e\u0010.\u001a\u00020\r2\u0006\u0010/\u001a\u00020\rJ\u0006\u00100\u001a\u00020#J\u000e\u00101\u001a\u00020#2\u0006\u00102\u001a\u000203R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00064"}, d2={"Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedModeLLDBDriverSupport;", "", "process", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoNativeDebugProcess;", "driver", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;", "<init>", "(Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoNativeDebugProcess;Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;)V", "getProcess", "()Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/MixedModeMonoNativeDebugProcess;", "getDriver", "()Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedMonoLLDBDriver;", "value", "", "swallowExceptionHandling", "getSwallowExceptionHandling", "()Z", "technicalResumeRequested", "getTechnicalResumeRequested", "isProcessSemanticallySuspended", "runningSemaphore", "Ljava/util/concurrent/Semaphore;", "suspendedSemaphore", "onSessionResume", "session", "Lcom/intellij/xdebugger/XDebugSession;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "refresher", "Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore;", "getRefresher", "()Lcom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MixedModeLLDBDataStore;", "refreshValueIfNeeded", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "stateChanged", "", "state", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$TargetState;", "loadScripts", "resumeAndWaitSilent", "waitUntilSessionResumed", "T", "f", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "waitForProcessResumed", "stopWhileProcess", "swallowStop", "waitForProcessSuspended", "saveReturnValueIfNeeded", "stopPlace", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "intellij.rider.plugins.cpp"})
@SourceDebugExtension(value={"SMAP\nMonoMixedModeLLDBDriverSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonoMixedModeLLDBDriverSupport.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedModeLLDBDriverSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,141:1\n1863#2,2:142\n*S KotlinDebug\n*F\n+ 1 MonoMixedModeLLDBDriverSupport.kt\ncom/jetbrains/rider/cpp/debugger/mixedMode/mono/driver/MonoMixedModeLLDBDriverSupport\n*L\n116#1:142,2\n*E\n"})
public final class MonoMixedModeLLDBDriverSupport {
    @NotNull
    private final MixedModeMonoNativeDebugProcess process;
    @NotNull
    private final MonoMixedMonoLLDBDriver driver;
    private volatile boolean swallowExceptionHandling;
    private volatile boolean technicalResumeRequested;
    private volatile boolean isProcessSemanticallySuspended;
    @NotNull
    private final Semaphore runningSemaphore;
    @NotNull
    private final Semaphore suspendedSemaphore;
    @Nullable
    private Semaphore onSessionResume;
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final MixedModeLLDBDataStore refresher;

    public MonoMixedModeLLDBDriverSupport(@NotNull MixedModeMonoNativeDebugProcess process, @NotNull MonoMixedMonoLLDBDriver driver) {
        Intrinsics.checkNotNullParameter((Object)((Object)process), (String)"process");
        Intrinsics.checkNotNullParameter((Object)((Object)driver), (String)"driver");
        this.process = process;
        this.driver = driver;
        this.runningSemaphore = new Semaphore(0, true);
        this.suspendedSemaphore = new Semaphore(1, true);
        XDebugSession xDebugSession = this.process.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        this.session = xDebugSession;
        this.refresher = new MixedModeLLDBDataStore(this.driver);
        XDebugSessionUtilsKt.adviseOnSettingsChanged((XDebugSession)this.session, () -> MonoMixedModeLLDBDriverSupport._init_$lambda$1(this));
    }

    @NotNull
    public final MixedModeMonoNativeDebugProcess getProcess() {
        return this.process;
    }

    @NotNull
    public final MonoMixedMonoLLDBDriver getDriver() {
        return this.driver;
    }

    public final boolean getSwallowExceptionHandling() {
        return this.swallowExceptionHandling;
    }

    public final boolean getTechnicalResumeRequested() {
        return this.technicalResumeRequested;
    }

    public final boolean isProcessSemanticallySuspended() {
        return this.isProcessSemanticallySuspended;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final MixedModeLLDBDataStore getRefresher() {
        return this.refresher;
    }

    @NotNull
    public final LLValue refreshValueIfNeeded(@NotNull LLValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return XMixedModeUtilsKt.isMixedModeHighProcessReady((XDebugSession)this.session) ? this.refresher.refreshValue(value) : value;
    }

    public final void stateChanged(@NotNull DebuggerDriver.TargetState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        boolean bl = this.isProcessSemanticallySuspended = state == DebuggerDriver.TargetState.RUNNING && this.technicalResumeRequested || state == DebuggerDriver.TargetState.SUSPENDED;
        if (state == DebuggerDriver.TargetState.RUNNING) {
            Semaphore semaphore = this.onSessionResume;
            if (semaphore != null) {
                semaphore.release();
            }
            this.suspendedSemaphore.acquire();
            this.runningSemaphore.release();
        }
        if (state == DebuggerDriver.TargetState.SUSPENDED) {
            this.runningSemaphore.acquire();
            this.suspendedSemaphore.release();
        }
    }

    public final void loadScripts() {
        this.driver.executeInterpreterCommand("command script import mixed_mode.jb_mono_utils");
    }

    public final void resumeAndWaitSilent() {
        boolean bl;
        boolean bl2 = bl = this.runningSemaphore.availablePermits() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.technicalResumeRequested = true;
        this.driver.resume();
        this.technicalResumeRequested = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T waitUntilSessionResumed(@NotNull Function0<? extends T> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        try {
            this.onSessionResume = new Semaphore(0);
            Object object = f.invoke();
            return (T)object;
        }
        finally {
            Semaphore semaphore = this.onSessionResume;
            if (semaphore == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            semaphore.acquire();
            this.onSessionResume = null;
        }
    }

    public final void waitForProcessResumed() {
        this.runningSemaphore.acquire();
        this.runningSemaphore.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean stopWhileProcess(boolean swallowStop) {
        boolean bl;
        boolean bl2 = bl = this.suspendedSemaphore.availablePermits() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        try {
            this.swallowExceptionHandling = swallowStop;
            if (!this.driver.interruptProcess()) {
                bl = false;
                return bl;
            }
            Iterable $this$forEach$iv = this.driver.getThreads();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Long tid;
                LLThread t = (LLThread)element$iv;
                boolean bl3 = false;
                String string = t.getTid();
                Long l = tid = string != null ? Long.valueOf(Long.parseLong(string)) : null;
                XDebugProcess xDebugProcess = XMixedModeUtilsKt.getLowLevelProcessOrThrow((XDebugSession)this.session);
                Intrinsics.checkNotNull((Object)xDebugProcess, (String)"null cannot be cast to non-null type com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoNativeDebugProcess");
                long l2 = ((MixedModeMonoNativeDebugProcess)xDebugProcess).getHelperThreadNativeId();
                if (l != null && l == l2) continue;
                this.driver.unfreezeThread(t);
            }
        }
        finally {
            this.swallowExceptionHandling = false;
        }
        return true;
    }

    public final void waitForProcessSuspended() {
        this.suspendedSemaphore.acquire();
        this.suspendedSemaphore.release();
    }

    public final void saveReturnValueIfNeeded(@NotNull DebuggerDriver.StopPlace stopPlace) {
        Intrinsics.checkNotNullParameter((Object)stopPlace, (String)"stopPlace");
        LLValue lLValue = stopPlace.returnValue;
        if (lLValue == null) {
            return;
        }
        LLValue returnValue = lLValue;
        String string = returnValue.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String identifier = string;
        XDebugProcess xDebugProcess = XMixedModeUtilsKt.getLowLevelProcessOrThrow((XDebugSession)this.session);
        Intrinsics.checkNotNull((Object)xDebugProcess, (String)"null cannot be cast to non-null type com.jetbrains.rider.cpp.debugger.mixedMode.mono.MixedModeMonoNativeDebugProcess");
        ((MixedModeMonoNativeDebugProcess)xDebugProcess).postCommand(arg_0 -> MonoMixedModeLLDBDriverSupport.saveReturnValueIfNeeded$lambda$3(this, stopPlace, identifier, returnValue, arg_0));
    }

    private static final void lambda$1$lambda$0(MonoMixedModeLLDBDriverSupport this$0, DebuggerDriver it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.refresher.resetSavedLLData();
    }

    private static final Unit _init_$lambda$1(MonoMixedModeLLDBDriverSupport this$0) {
        this$0.process.postCommand(arg_0 -> MonoMixedModeLLDBDriverSupport.lambda$1$lambda$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final void saveReturnValueIfNeeded$lambda$3(MonoMixedModeLLDBDriverSupport this$0, DebuggerDriver.StopPlace $stopPlace, String $identifier, LLValue $returnValue, DebuggerDriver it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MixedModeLLDBDataStore mixedModeLLDBDataStore = this$0.refresher;
        LLFrame lLFrame = $stopPlace.frame;
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame");
        LLThread lLThread = $stopPlace.thread;
        Intrinsics.checkNotNullExpressionValue((Object)lLThread, (String)"thread");
        mixedModeLLDBDataStore.saveFrame(lLFrame, lLThread);
        this$0.refresher.saveEvaluatedValueAndLoadData($stopPlace.thread.getId(), $identifier, $stopPlace.frame.getIndex(), $returnValue);
    }
}

